<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="row ">
            <div class="col-md-4">
                <h4><?php echo e($apartment->name); ?> EXPENSES</h4>
            </div>

            <div class="col-md-4">
                <!-- Middle section left empty -->
                <?php if(session('error')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>
            </div>
            <div class="col-md-4">

                <!-- Apartment Selection Dropdown -->

           </div>

        </div>
    </div>

<style>
    .expenses{
        margin: 2rem;
    }
    .inner-box h5{
        text-align: center;
    }
</style>

                <div class="row">
                    <div class="container-fluid">
                        <div class="expenses">
                            <div class="row outer-box">
                                <div class="col-md-6">
                                    <div class="inner-box">
                                        <h5>Fixed Expenses</h5>
                                        <table id="fixed-expenses-table">
                                            <thead>
                                                <tr>
                                                    <th><input type="checkbox" id="select-all" onclick="selectAllCheckboxes()"></th>
                                                    <th>Description</th>
                                                    <th>Amount</th>
                                                    <th>Frequency</th>
                                                    <th>Start Date</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $fixedExpenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><input type="checkbox" class="invoice-checkbox"></td>
                                                        <td><?php echo e($expense->name); ?></td>
                                                        <td><?php echo e($expense->amount); ?></td>
                                                        <td><?php echo e($expense->frequency); ?></td>
                                                        <td><?php echo e($expense->start_date); ?></td>
                                                        <td><?php echo e($expense->status); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>

                                        <button class="button-secondary" type="button" id="openFixedExpenseForm" onclick="openFixedExpenseForm()">Add Fixed Expense</button>
                                            <button class="button button-danger" type="button" id="openFixedExpenseForm" onclick="deleteSelectedFixedExpense()">Delete Selected Expense</button>
                                    <!-- Include the form popup container -->
                                <div id="formPopup" style="display: none;"></div>

<script>

    function openFixedExpenseForm() {
        // Function to open the form popup
    console.log('Button clicked!');
        // Prevent default form submission
    event.preventDefault();
        // You may use AJAX to load the form content dynamically
        fetch("<?php echo e(route('apartment-expenses.create-fixed-expense', $apartment)); ?>")
            .then(response => response.text())
            .then(formHtml => {
                document.getElementById('formPopup').innerHTML = formHtml;
                document.getElementById('formPopup').style.display = 'block';
            })
            .catch(error => {
                console.error('Error loading form:', error);
                // Handle errors if needed
            });
    }

    // Function to submit the form via AJAX
    function submitFixedExpenseForm() {
        // You may use AJAX to submit the form data
        fetch("<?php echo e(route('apartment-expenses.store-fixed-expense', $apartment)); ?>", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Accept': 'application/json'
            },
            body: JSON.stringify({
            'name': document.getElementById('name').value,
            'amount': document.getElementById('amount').value,
            'frequency': document.getElementById('frequency').value,
            'start_date': document.getElementById('start_date').value,
            'status': document.getElementById('status').value,
            // Add other fields as needed
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Success
            alert('Fixed Expense added successfully!');
            // Refresh the fixed expenses table
            refreshFixedExpensesTable();
             // Hide the form container
             document.getElementById('fixedExpenseForm').style.display = 'none';
        } else {
            // Error, handle validation errors
            if (data.errors) {
                alert('Validation Errors: ' + JSON.stringify(data.errors));
            } else {
                alert('Unknown Error');
            }
        }
    })
        .catch(error => {
            console.error('Error:', error);
            // Handle errors if needed
        });
    }




    function refreshFixedExpensesTable() {
    const apartmentId = <?php echo e($apartment->id); ?>;
    const getFixedExpensesRoute = "<?php echo e(route('apartment-expenses.get-fixed-expenses', ['apartment' => ':apartmentId'])); ?>".replace(':apartmentId', apartmentId);

    console.log('Starting refresh...');

    fetch(getFixedExpensesRoute)
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! Status: ${response.status}`);
            }
            console.log('Fetch response:', response);
            return response.text();
        })
        .then(tableHtml => {
            document.getElementById('fixed-expenses-table').innerHTML = tableHtml;
        })
        .catch(error => {
            console.error('Error refreshing fixed expenses table:', error);
            // Handle errors if needed
        });
}

</script>
<script>
    function deleteSelectedFixedExpense() {
        var table = document.getElementById('fixed-expenses-table');
        var checkboxes = table.querySelectorAll('tbody .invoice-checkbox:checked');

        if (checkboxes.length === 0) {
            console.log('No expenses selected for deletion.');
            alert('Please select at least one expense to delete.');
            return;
        }

        if (confirm('Are you sure you want to delete the selected expenses?')) {
            checkboxes.forEach(function(checkbox) {
                var expenseId = checkbox.closest('tr').getAttribute('data-expense-id'); // Assuming you have an attribute to store the expense ID

                // Send an HTTP request to delete the expense from the database
                fetch('/apartments/<?php echo e($apartment->id); ?>/expenses/destroy-fixed-expense/' + expenseId, {
                    method: 'DELETE',
                })
                .then(response => {
                    if (response.ok) {
                        console.log('Expense with ID', expenseId, 'deleted successfully.');
                        checkbox.closest('tr').remove(); // Remove the row from the HTML table
                    } else {
                        console.error('Failed to delete expense with ID', expenseId);
                    }
                })
                .catch(error => {
                    console.error('Error occurred while deleting expense:', error);
                });
            });
        }
    }

    function selectAllCheckboxes() {
        var selectAllCheckbox = document.getElementById('select-all');
        var checkboxes = document.querySelectorAll('.invoice-checkbox');

        checkboxes.forEach(function(checkbox) {
            checkbox.checked = selectAllCheckbox.checked;
        });
    }

    console.log('JavaScript loaded.');

    document.getElementById('openFixedExpenseForm').addEventListener('click', function() {
        console.log('Add Fixed Expense button clicked.');
        // You can add logic here to open the form for adding a fixed expense
    });

    document.getElementById('deleteSelectedExpense').addEventListener('click', function() {
        console.log('Delete Selected Expense button clicked.');
        deleteSelectedFixedExpense(); // Call the function to delete selected expenses
    });
</script>


                                    </div>

                                </div>
                                <div class="col-md-6">
                                    <div class="inner-box">
                                        <h5>Varying Expenses</h5>
                                    </div>
                                    <div class="inner-box">
                                        <h5>Fixed Expenses Invoices</h5>
                                    </div>
                                    <div class="inner-box">
                                        <h5>Varying Expenses Invoices</h5>
                                    </div>

                                </div>
                            </div>

                        </div>

                        <!-- Include the form popup container -->
<div id="formPopup" style="display: none;"></div>
                        <form method="post" action="<?php echo e(route('apartments.store')); ?>">
                            <?php echo csrf_field(); ?>
                            <!-- Include all necessary fields for apartment creation -->
                            <label for="apartment_name">Apartment Name:</label>
                            <input type="text" name="apartment_name" required>

                            <!-- Add more fields as needed -->

                            <button type="submit">Create Apartment</button>
                        </form>

                    </div>
                </div>
</div>
<script>

    function updateTable(newExpense) {
        // Update the table with the new expense data
        const tableBody = document.querySelector('table tbody');
        const newRow = document.createElement('tr');
        newRow.innerHTML = `
            <td>${newExpense.amount}</td>
            <td>${newExpense.frequency}</td>
            <td>${newExpense.start_date}</td>
            <td>${newExpense.status}</td>
        `;

        tableBody.appendChild(newRow);
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.apartment-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\BarakaDemo\BarakaDemo\resources\views/landlord/apartments/expenses.blade.php ENDPATH**/ ?>