<style>
    .paid-row {
        background-color: #c3e6cb; /* Green background for paid rows */
    }

    .unpaid-row {
        background-color: #f5c6cb; /* Red background for unpaid rows */
    }
    .partial-row{background-color: dddbec;}
</style>

<table id= "Apartment-this-month-invoices"class="table display">
        <thead>
            <tr>

                <th><a  class="sort-header" data-column-index="1" data-sort-type="string">Invoice #</a></th>
                <th><a  class="sort-header" data-column-index="2" data-sort-type="string">Client Name</a></th>
                <th><a  class="sort-header" data-column-index="3" data-sort-type="numeric">Room</a></th>
                <th><a  class="sort-header" data-column-index="4" data-sort-type="date">Invoice Date</a></th>
                <th><a  class="sort-header" data-column-index="5" data-sort-type="date">Due Date</a></th>
                <th><a  class="sort-header" data-column-index="6" data-sort-type="numeric">Total</a></th>
                <th><a  class="sort-header" data-column-index="7" data-sort-type="string">Payment Method</a></th>
                <th><a  class="sort-header" data-column-index="8" data-sort-type="string">Status</a></th>
                <th><a  class="sort-header" data-column-index="9" data-sort-type="numeric">Balance</a></th>
                <th><a  class="sort-header" data-column-index="10" data-sort-type="numeric">Compounded balance</a></th>


            </tr>
        </thead>
                    
        <tbody>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $userCompoundedBalances[$user->id]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoiceData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $invoice = $invoiceData['invoice'];
                        $compoundedBalance = $invoiceData['compounded_balance'];
                        $rowClass = '';

if ($invoice->payment_status === 'paid') {
    $rowClass = 'paid-row';
} elseif ($invoice->payment_status === 'unpaid') {
    $rowClass = 'unpaid-row';
} elseif ($invoice->payment_status === 'partial') {
    $rowClass = 'partial-row';
}

            ?>
            <tr class="<?php echo e($rowClass); ?>">

                    <td>
                        <a href="<?php echo e(route('landlord-edit-invoice', ['apartment'=>$apartment->id, 'invoice' => $invoice->id])); ?>">

                            <?php echo $invoice->invoice_number; ?>
                        </a>
                    </td>
                    <td><a href="<?php echo e(route('landlord-view-tenant-profile', ['apartment' => $apartment->id, 'usersInApartment' => $invoice->user->id ])); ?>" class="user-link"><?php echo e($invoice->user->name); ?></td>
                    <td><?php echo e(optional($invoice->rooms)->room_number); ?></td>
                    <td><?php echo $invoice->created_at; ?></td>
                    <td><?php echo $invoice->due_date; ?></td>
                    <td><?php echo e($apartment->currency); ?><?php echo e(number_format($invoice->total_amount, 2)); ?> </td>
                    <td>Mpesa</td>
                    <td class="text-uppercase">
                        <?php if($invoice->payment_status == 'paid'): ?>
                            <span class="badge badge-success">PAID</span>
                        <?php elseif($invoice->payment_status == 'partial'): ?>
                            <span class="badge badge-warning">PARTIAL</span>
                        <?php else: ?>
                            <span class="badge badge-danger">UNPAID</span>
                        <?php endif; ?>
                    </td>

                    <td><?php echo e($apartment->currency); ?><?php echo e(number_format($invoice->balance, 2)); ?></td>
                    <td><strong><?php echo e($apartment->currency); ?><?php echo e(number_format($compoundedBalance, 2)); ?></strong></td>


                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
<?php /**PATH C:\wamp64\www\BarakaDemo\BarakaDemo\resources\views/partials/_pdf-apartmentthismonthinvoicestable.blade.php ENDPATH**/ ?>