<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <div class="row justify-content-center">
        <?php echo $__env->make('partials._message_box', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>


<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-10 py-4">
            <div class="card py-4">
                <div class="card-header"><?php echo e(__('Manage Licenses')); ?>

                <div class="card-tools float-right">
                    <div class="form-group mb-0">
                        <form method="get" action="<?php echo e(route('licenses.purchase-page')); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-success">Purchase Another License</button>
                        </form>
                    </div>

                </div>
                </div>

                <div class="card-head py-4">
                    <div class="row justify-content-center">
                        <div class="col-md-10">
                            <p>Do you wish to have your license key activated?</p>
                        </div>
                        <div class="row">
                            <div class="">
                            <form method="post" action="<?php echo e(route('licenses.install-key')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="input-group">
                                    <input type="text" class="form-control" name="upgrade_plan" placeholder="Enter Key">
                                    <div class="input-group-append">
                                        <button type="submit" class="btn btn-primary">Install Key</button>
                                    </div>
                                </div>
                            </form>
                            </div>
                        </div>

                    </div>
                </div>
<div class="card-header"></div>
                <div class="card-body">
                    <h5>My Licenses</h5>
                    <?php $__empty_1 = true; $__currentLoopData = $user->licensePurchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $licensePurchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="card mb-3">
                            <div class="card-body">
                                <p><strong>License Type:</strong> <?php echo e($licensePurchase->license_type); ?></p>
                                <p><strong>License Key:</strong> <?php echo e($licensePurchase->license_key); ?></p>
                                <p><strong>Status:</strong> <?php echo e($licensePurchase->status); ?></p>
                                <p><strong>Expiry Date:</strong> <?php echo e($licensePurchase->expiry_date); ?></p>
                                <p><strong>Purchase Date:</strong> <?php echo e($licensePurchase->purchase_date); ?></p>

                                <div class="mt-3">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <form method="post" action="<?php echo e(route('licenses.reissue')); ?>">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-secondary">Request Reissue</button>
                                            </form>
                                        </div>
                                        <div class="col-md-4">
                                             <!-- Add button to show renewal form -->
    <?php if($licensePurchase->license_type !== 'demo'): ?>
    <button type="button" class="btn btn-secondary" data-toggle="modal" data-target="#renewModal">
        Renew License
    </button>
<?php endif; ?>
                                        </div>
                                        <div class="col-md-4">
                                            <!-- Input form for possible upgrade -->
                                            <form method="get" action="<?php echo e(route('licenses.upgrade-page')); ?>">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-secondary">Upgrade</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p>You don't have a license. Purchase one to start managing your property and access premium features.</p>
                        <form method="get" action="<?php echo e(route('licenses.purchase-page')); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-success">Purchase License</button>
                        </form>
                    <?php endif; ?>
                </div>
                <div class="col-md-12">
                    <form method="get" action="<?php echo e(route('licenses.purchase-page')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="card-footer">
                        <button type="submit" class="btn btn-primary center">Purchase Another License</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>





</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.landlord-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\BarakaDemo\BarakaDemo\resources\views/landlord/license/licenseinfo.blade.php ENDPATH**/ ?>