<?php $__env->startSection('content'); ?>
    <!-- Add jQuery library -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

    <style>
        .widget-row {
            display: flex;
            flex-wrap: wrap;
        }

        .col-md-4 {
            flex: 0 0 33.33%;
            max-width: 33.33%;
        }

        .widget {
            border: 1px solid #ccc;
            margin: 10px;
            overflow: hidden;
            width: 100%;
            box-sizing: border-box;
            position: relative;
        }

        .widget-header {
            background-color: #f4f4f4;
            padding: 5px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            cursor: move;
            border-bottom: 1px solid #ccc;
        }

        .widget-icons {
            display: flex;
            gap: 5px;
        }

        .widget-icons i {
            padding: 5px;
            cursor: pointer;
            border-radius: 3px;
        }

        .widget-icons i:hover {
            background-color: #ddd;
        }

        .resize-handle {
            width: 10px;
            height: 100%;
            position: absolute;
            right: 0;
            top: 0;
            cursor: ew-resize;
        }

        .widget-content {
            padding: 10px;
            max-height: 300px;
            overflow-y: auto;
        }

        .expense-buttons {
            display: flex;
            align-items: center;
        }

        .expense-buttons button {
            flex: 1;
            padding: 10px;
        }

        .separator {
            border-right: 1px solid #ccc;
            height: 20px;
            margin: 0 10px;
        }

        .red-row {
            background-color: #ffcccc;
            /* Light red */
        }

        .green-row {
            background-color: #ccffcc;
            /* Light green */
        }

        .thumbs-up {
            color: green;
        }

        .thumbs-down {
            color: red;
        }

        .table-responsive {
            max-height: 300px;
            /* Adjust this value as needed */
            overflow-y: auto;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="row ">
                <div class="col-md-4">

                    <!-- Apartment Selection Dropdown -->
                    <?php echo $__env->make('partials._apartment_dropdown', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>

                <div class="col-md-4">
                    <!-- Middle section left empty -->
                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>
                </div>

                <div class="col-md-4">
                    <h6>CARETAKER</h6>
                    <ul>
                        <?php $__currentLoopData = $caretakers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $caretaker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($caretaker->name); ?> - (<?php echo e($caretaker->phone_number); ?>)</li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>

                </div>



                




            </div>
        </div>







        <div class="container-fluid">
            <div class="row">


                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <a href="<?php echo e(route('landlord.manage.rooms', $apartment->id)); ?>"
                        style="text-decoration: none; color: inherit;">
                        <div class="small-box bg-blue">
                            <div class="inner">
                                <p>TOTAL ROOMS</p>
                                <h4 class="center bold"><?php echo e($apartment->rooms->count()); ?></h4>
                            </div>
                            <div class="icon">
                                <i class="ion ion-person-add"></i>
                            </div>
                        </div>
                    </a>
                </div>

                <!--/Total user -->

                <!--Total user -->

                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <a href="<?php echo e(route('landlord.manage.users', $apartment->id)); ?>"
                        style="text-decoration: none; color: inherit;">
                        <div class="small-box bg-yellow">
                            <div class="inner">
                                <p>TOTAL USERS</p>
                                <h4 class="center"><?php echo e($totalUsersCount); ?></h4>
                            </div>
                            <div class="icon">
                                <i class="ion ion-person-add"></i>
                            </div>
                        </div>
                    </a>
                </div>

                <!--/Total user -->

                

                <div class="col-lg-3 col-6">
                    <!-- small box -->

                    <div class="small-box bg-success">
                        <div class="inner">
                            <a href="<?php echo e(route('landlord.apartment-this-month-invoices', $apartment->id)); ?>"
                                style="text-decoration: none; color: inherit;">
                                <div id="amountpaidthismonth" style="display:none">
                                    <h3><?php echo e($apartment->currency); ?>


                                        <?php echo e(number_format($totalPaidThisMonth, 2)); ?><sup
                                            style="font-size: 20px"><?php echo e($percentagePaid); ?></sup>
                            </a>
                        </div>
                        </h3>

                        <p>Amount Paid (This Month) <i class="fas fa-eye eye-icon-paid"></i></p>
                    </div>
                    <div class="icon">
                        <i class="ion ion-stats-bars"></i>
                    </div>
                    

                    <script>
                        $(document).ready(function() {
                            // Assume these variables are set based on your settings page
                            var showPaidBalanceSetting = true; // Change this based on your setting
                            var showUnpaidBalanceSetting = true; // Change this based on your setting

                            // Toggle visibility of the amount paid this month on eye icon click
                            $(".eye-icon-paid").click(function() {
                                if (showPaidBalanceSetting) {
                                    $("#amountpaidthismonth").toggle();
                                }
                            });

                            // Show/hide share script on hover
                            $(".eye-icon-paid").hover(function() {
                                if (showPaidBalanceSetting) {
                                    // Add your share script logic here for the first eye icon
                                }
                            }, function() {
                                if (showPaidBalanceSetting) {
                                    // Add your hide script logic here for the first eye icon
                                }
                            });

                            // Toggle visibility of the amount unpaid this month on eye icon click
                            $(".eye-icon-unpaid").click(function() {
                                if (showUnpaidBalanceSetting) {
                                    $("#amountunpaidthismonth").toggle();
                                }
                            });

                            // Show/hide share script on hover
                            $(".eye-icon-unpaid").hover(function() {
                                if (showUnpaidBalanceSetting) {
                                    // Add your share script logic here for the second eye icon
                                }
                            }, function() {
                                if (showUnpaidBalanceSetting) {
                                    // Add your hide script logic here for the second eye icon
                                }
                            });
                        });
                    </script>


                </div>

            </div>
            <!-- ./col -->
            <div class="col-lg-3 col-6">
                <!-- small box -->

                <div class="small-box bg-danger">
                    <div class="inner">
                        <a href="<?php echo e(route('landlord.apartment-this-month-invoices', $apartment->id)); ?>"
                            style="text-decoration: none; color: inherit;">
                            <div id="amountunpaidthismonth" style="display:none">
                                <h3><?php echo e($apartment->currency); ?><?php echo e(number_format($totalUnpaidThisMonth, 2)); ?>

                            </div>
                            </h3>
                        </a>

                        <p>Areas (This Month) <i class="fas fa-eye eye-icon-unpaid"></i></p>
                    </div>
                    <div class="icon">
                        <i class="ion ion-person-add"></i>
                    </div>

                </div>
                </a>
            </div>
        </div>

        <!-- Main row -->
        <div class="row">
            <!-- Left col -->
            <div class="col-md-8">
                <!-- TABLE: LATEST Payments -->
                <div class="card">
                    <div class="card-header border-transparent">
                        <h3 class="card-title">Latest Payments</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table m-0">
                                <thead>
                                    <tr>
                                        <th>Invoice Number</th>
                                        <th>User Name</th>
                                        <th>Payment Date</th>
                                        <th>Amount Paid</th>
                                        <!-- Add more columns as needed -->
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $recentPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(isset($invoice->payments) && is_iterable($invoice->payments)): ?>
                                            <?php
                                                // Sort payments by payment date in descending order and take the latest 5
                                                $latestPayments = collect($invoice->payments)
                                                    ->sortByDesc('payment_date')
                                                    ->take(5);
                                            ?>
                                            <?php $__currentLoopData = $latestPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <?php if($index === 0): ?>
                                                        <!-- Check if it's the first payment to display invoice number -->
                                                        <td rowspan="<?php echo e($latestPayments->count()); ?>">
                                                            <?php echo e($invoice->invoice_number); ?></td>
                                                        <td rowspan="<?php echo e($latestPayments->count()); ?>">
                                                            <?php echo e($invoice->user->name); ?></td>
                                                    <?php endif; ?>
                                                    <td><?php echo e($payment['payment_date']); ?></td>
                                                    <td><?php echo e($payment['payment_amount']); ?></td>
                                                    <!-- Add more columns as needed -->
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <tr>
                                                <td><?php echo e($invoice->invoice_number); ?></td>
                                                <td><?php echo e($invoice->user->name); ?></td>
                                                <td colspan="2">No payments available</td>
                                                <!-- colspan to span across columns -->
                                                <!-- Add more columns as needed -->
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>


                        </div>
                        <!-- /.table-responsive -->
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer clearfix">
                        <a href="javascript:void(0)" class="btn btn-sm btn-info float-left">Add New Payment</a>
                        <a href="<?php echo e(route('landlord.apartment-payments', ['apartment' => $apartment->id])); ?>"
                            class="btn btn-sm btn-secondary float-right">View All Payments</a>
                    </div>
                    <!-- /.card-footer -->
                </div>
                <!-- /.card -->
                <!-- MAP & BOX PANE -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">New Visitors</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body p-0">
                        <div class="d-md-flex">
                            <div class="p-1 flex-fill" style="overflow: hidden">
                                <!-- Map will be created here -->
                                <div id="world-map-markers" style="height: 325px; overflow: hidden">
                                    <div class="map"></div>
                                </div>
                            </div>
                            <div class="card-pane-right bg-success pt-2 pb-2 pl-4 pr-4">
                                <div class="description-block mb-4">
                                    <div class="sparkbar pad" data-color="#fff">90,70,90,70,75,80,70</div>
                                    <h5 class="description-header">8390</h5>
                                    <span class="description-text">Visits</span>
                                </div>
                                <!-- /.description-block -->
                                <div class="description-block mb-4">
                                    <div class="sparkbar pad" data-color="#fff">90,50,90,70,61,83,63</div>
                                    <h5 class="description-header">30%</h5>
                                    <span class="description-text">Referrals</span>
                                </div>
                                <!-- /.description-block -->
                                <div class="description-block">
                                    <div class="sparkbar pad" data-color="#fff">90,50,90,70,61,83,63</div>
                                    <h5 class="description-header">70%</h5>
                                    <span class="description-text">Organic</span>
                                </div>
                                <!-- /.description-block -->
                            </div><!-- /.card-pane-right -->
                        </div><!-- /.d-md-flex -->
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
                <div class="row">
                    <div class="col-md-6">
                        <!-- DIRECT CHAT -->
                        <div class="card direct-chat direct-chat-warning">
                            <div class="card-header">
                                <h3 class="card-title">Tenant Complains</h3>

                                <div class="card-tools">
                                    <span title="3 New Messages" class="badge badge-warning">3</span>
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    <button type="button" class="btn btn-tool" title="Contacts"
                                        data-widget="chat-pane-toggle">
                                        <i class="fas fa-comments"></i>
                                    </button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <!-- Conversations are loaded here -->
                                <div class="direct-chat-messages">
                                    <!-- Message. Default to the left -->
                                    <div class="direct-chat-msg">
                                        <div class="direct-chat-infos clearfix">
                                            <span class="direct-chat-name float-left">Alexander Pierce</span>
                                            <span class="direct-chat-timestamp float-right">23 Jan 2:00 pm</span>
                                        </div>
                                        <!-- /.direct-chat-infos -->
                                        <img class="direct-chat-img" src="dist/img/user1-128x128.jpg"
                                            alt="message user image">
                                        <!-- /.direct-chat-img -->
                                        <div class="direct-chat-text">
                                            Is this template really for free? That's unbelievable!
                                        </div>
                                        <!-- /.direct-chat-text -->
                                    </div>
                                    <!-- /.direct-chat-msg -->

                                    <!-- Message to the right -->
                                    <div class="direct-chat-msg right">
                                        <div class="direct-chat-infos clearfix">
                                            <span class="direct-chat-name float-right">Sarah Bullock</span>
                                            <span class="direct-chat-timestamp float-left">23 Jan 2:05 pm</span>
                                        </div>
                                        <!-- /.direct-chat-infos -->
                                        <img class="direct-chat-img" src="dist/img/user3-128x128.jpg"
                                            alt="message user image">
                                        <!-- /.direct-chat-img -->
                                        <div class="direct-chat-text">
                                            You better believe it!
                                        </div>
                                        <!-- /.direct-chat-text -->
                                    </div>
                                    <!-- /.direct-chat-msg -->

                                    <!-- Message. Default to the left -->
                                    <div class="direct-chat-msg">
                                        <div class="direct-chat-infos clearfix">
                                            <span class="direct-chat-name float-left">Alexander Pierce</span>
                                            <span class="direct-chat-timestamp float-right">23 Jan 5:37 pm</span>
                                        </div>
                                        <!-- /.direct-chat-infos -->
                                        <img class="direct-chat-img" src="dist/img/user1-128x128.jpg"
                                            alt="message user image">
                                        <!-- /.direct-chat-img -->
                                        <div class="direct-chat-text">
                                            Working with AdminLTE on a great new app! Wanna join?
                                        </div>
                                        <!-- /.direct-chat-text -->
                                    </div>
                                    <!-- /.direct-chat-msg -->

                                    <!-- Message to the right -->
                                    <div class="direct-chat-msg right">
                                        <div class="direct-chat-infos clearfix">
                                            <span class="direct-chat-name float-right">Sarah Bullock</span>
                                            <span class="direct-chat-timestamp float-left">23 Jan 6:10 pm</span>
                                        </div>
                                        <!-- /.direct-chat-infos -->
                                        <img class="direct-chat-img" src="dist/img/user3-128x128.jpg"
                                            alt="message user image">
                                        <!-- /.direct-chat-img -->
                                        <div class="direct-chat-text">
                                            I would love to.
                                        </div>
                                        <!-- /.direct-chat-text -->
                                    </div>
                                    <!-- /.direct-chat-msg -->

                                </div>
                                <!--/.direct-chat-messages-->

                                <!-- Contacts are loaded here -->
                                <div class="direct-chat-contacts">
                                    <ul class="contacts-list">
                                        <li>
                                            <a href="#">
                                                <img class="contacts-list-img" src="dist/img/user1-128x128.jpg"
                                                    alt="User Avatar">

                                                <div class="contacts-list-info">
                                                    <span class="contacts-list-name">
                                                        Count Dracula
                                                        <small class="contacts-list-date float-right">2/28/2015</small>
                                                    </span>
                                                    <span class="contacts-list-msg">How have you been? I
                                                        was...</span>
                                                </div>
                                                <!-- /.contacts-list-info -->
                                            </a>
                                        </li>
                                        <!-- End Contact Item -->
                                        <li>
                                            <a href="#">
                                                <img class="contacts-list-img" src="dist/img/user7-128x128.jpg"
                                                    alt="User Avatar">

                                                <div class="contacts-list-info">
                                                    <span class="contacts-list-name">
                                                        Sarah Doe
                                                        <small class="contacts-list-date float-right">2/23/2015</small>
                                                    </span>
                                                    <span class="contacts-list-msg">I will be waiting for...</span>
                                                </div>
                                                <!-- /.contacts-list-info -->
                                            </a>
                                        </li>
                                        <!-- End Contact Item -->
                                        <li>
                                            <a href="#">
                                                <img class="contacts-list-img" src="dist/img/user3-128x128.jpg"
                                                    alt="User Avatar">

                                                <div class="contacts-list-info">
                                                    <span class="contacts-list-name">
                                                        Nadia Jolie
                                                        <small class="contacts-list-date float-right">2/20/2015</small>
                                                    </span>
                                                    <span class="contacts-list-msg">I'll call you back at...</span>
                                                </div>
                                                <!-- /.contacts-list-info -->
                                            </a>
                                        </li>
                                        <!-- End Contact Item -->
                                        <li>
                                            <a href="#">
                                                <img class="contacts-list-img" src="dist/img/user5-128x128.jpg"
                                                    alt="User Avatar">

                                                <div class="contacts-list-info">
                                                    <span class="contacts-list-name">
                                                        Nora S. Vans
                                                        <small class="contacts-list-date float-right">2/10/2015</small>
                                                    </span>
                                                    <span class="contacts-list-msg">Where is your new...</span>
                                                </div>
                                                <!-- /.contacts-list-info -->
                                            </a>
                                        </li>
                                        <!-- End Contact Item -->
                                        <li>
                                            <a href="#">
                                                <img class="contacts-list-img" src="dist/img/user6-128x128.jpg"
                                                    alt="User Avatar">

                                                <div class="contacts-list-info">
                                                    <span class="contacts-list-name">
                                                        John K.
                                                        <small class="contacts-list-date float-right">1/27/2015</small>
                                                    </span>
                                                    <span class="contacts-list-msg">Can I take a look at...</span>
                                                </div>
                                                <!-- /.contacts-list-info -->
                                            </a>
                                        </li>
                                        <!-- End Contact Item -->
                                        <li>
                                            <a href="#">
                                                <img class="contacts-list-img" src="dist/img/user8-128x128.jpg"
                                                    alt="User Avatar">

                                                <div class="contacts-list-info">
                                                    <span class="contacts-list-name">
                                                        Kenneth M.
                                                        <small class="contacts-list-date float-right">1/4/2015</small>
                                                    </span>
                                                    <span class="contacts-list-msg">Never mind I found...</span>
                                                </div>
                                                <!-- /.contacts-list-info -->
                                            </a>
                                        </li>
                                        <!-- End Contact Item -->
                                    </ul>
                                    <!-- /.contacts-list -->
                                </div>
                                <!-- /.direct-chat-pane -->
                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer">
                                <form action="#" method="post">
                                    <div class="input-group">
                                        <input type="text" name="message" placeholder="Type Message ..."
                                            class="form-control">
                                        <span class="input-group-append">
                                            <button type="button" class="btn btn-warning">Send</button>
                                        </span>
                                    </div>
                                </form>
                            </div>
                            <!-- /.card-footer-->
                        </div>
                        <!--/.direct-chat -->
                    </div>
                    <!-- /.col -->

                    <div class="col-md-6">
                        <!-- USERS LIST -->
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Apartment Users</h3>

                                <div class="card-tools">
                                    <span class="badge badge-danger">8 New Members</span>
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body p-0">
                                <ul class="users-list clearfix">
                                    <li>
                                        <img src="dist/img/user1-128x128.jpg" alt="User Image">
                                        <a class="users-list-name" href="#">Alexander Pierce</a>
                                        <span class="users-list-date">Today</span>
                                    </li>
                                    <li>
                                        <img src="dist/img/user8-128x128.jpg" alt="User Image">
                                        <a class="users-list-name" href="#">Norman</a>
                                        <span class="users-list-date">Yesterday</span>
                                    </li>
                                    <li>
                                        <img src="dist/img/user7-128x128.jpg" alt="User Image">
                                        <a class="users-list-name" href="#">Jane</a>
                                        <span class="users-list-date">12 Jan</span>
                                    </li>
                                    <li>
                                        <img src="dist/img/user6-128x128.jpg" alt="User Image">
                                        <a class="users-list-name" href="#">John</a>
                                        <span class="users-list-date">12 Jan</span>
                                    </li>
                                    <li>
                                        <img src="dist/img/user2-160x160.jpg" alt="User Image">
                                        <a class="users-list-name" href="#">Alexander</a>
                                        <span class="users-list-date">13 Jan</span>
                                    </li>
                                    <li>
                                        <img src="dist/img/user5-128x128.jpg" alt="User Image">
                                        <a class="users-list-name" href="#">Sarah</a>
                                        <span class="users-list-date">14 Jan</span>
                                    </li>
                                    <li>
                                        <img src="dist/img/user4-128x128.jpg" alt="User Image">
                                        <a class="users-list-name" href="#">Nora</a>
                                        <span class="users-list-date">15 Jan</span>
                                    </li>
                                    <li>
                                        <img src="dist/img/user3-128x128.jpg" alt="User Image">
                                        <a class="users-list-name" href="#">Nadia</a>
                                        <span class="users-list-date">15 Jan</span>
                                    </li>
                                </ul>
                                <!-- /.users-list -->
                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer text-center">
                                <a href="javascript:">View All Users</a>
                            </div>
                            <!-- /.card-footer -->
                        </div>
                        <!--/.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->

                <!-- TABLE: LATEST Payments -->
                <div class="card">
                    <div class="card-header border-transparent">
                        <h3 class="card-title">Latest Payments</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table m-0">
                                <thead>
                                    <tr>
                                        <th>Order ID</th>
                                        <th>Item</th>
                                        <th>Status</th>
                                        <th>Popularity</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><a href="pages/examples/invoice.html">OR9842</a></td>
                                        <td>Call of Duty IV</td>
                                        <td><span class="badge badge-success">Shipped</span></td>
                                        <td>
                                            <div class="sparkbar" data-color="#00a65a" data-height="20">
                                                90,80,90,-70,61,-83,63</div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><a href="pages/examples/invoice.html">OR1848</a></td>
                                        <td>Samsung Smart TV</td>
                                        <td><span class="badge badge-warning">Pending</span></td>
                                        <td>
                                            <div class="sparkbar" data-color="#f39c12" data-height="20">
                                                90,80,-90,70,61,-83,68</div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><a href="pages/examples/invoice.html">OR7429</a></td>
                                        <td>iPhone 6 Plus</td>
                                        <td><span class="badge badge-danger">Delivered</span></td>
                                        <td>
                                            <div class="sparkbar" data-color="#f56954" data-height="20">
                                                90,-80,90,70,-61,83,63</div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><a href="pages/examples/invoice.html">OR7429</a></td>
                                        <td>Samsung Smart TV</td>
                                        <td><span class="badge badge-info">Processing</span></td>
                                        <td>
                                            <div class="sparkbar" data-color="#00c0ef" data-height="20">
                                                90,80,-90,70,-61,83,63</div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><a href="pages/examples/invoice.html">OR1848</a></td>
                                        <td>Samsung Smart TV</td>
                                        <td><span class="badge badge-warning">Pending</span></td>
                                        <td>
                                            <div class="sparkbar" data-color="#f39c12" data-height="20">
                                                90,80,-90,70,61,-83,68</div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><a href="pages/examples/invoice.html">OR7429</a></td>
                                        <td>iPhone 6 Plus</td>
                                        <td><span class="badge badge-danger">Delivered</span></td>
                                        <td>
                                            <div class="sparkbar" data-color="#f56954" data-height="20">
                                                90,-80,90,70,-61,83,63</div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><a href="pages/examples/invoice.html">OR9842</a></td>
                                        <td>Call of Duty IV</td>
                                        <td><span class="badge badge-success">Shipped</span></td>
                                        <td>
                                            <div class="sparkbar" data-color="#00a65a" data-height="20">
                                                90,80,90,-70,61,-83,63</div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- /.table-responsive -->
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer clearfix">
                        <a href="javascript:void(0)" class="btn btn-sm btn-info float-left">Place New Order</a>
                        <a href="javascript:void(0)" class="btn btn-sm btn-secondary float-right">View All
                            Orders</a>
                    </div>
                    <!-- /.card-footer -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->

            <div class="col-md-4 col-sm-12">

                <!-- PRODUCT LIST -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Apartment Settings Monitor</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table m-0" id="statusTable">

                                <thead>
                                    <tr>
                                        <th>No</th>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>Settings</td>
                                        <td>80%</td>

                                        <td>
                                            <button class="thumbs-up">👍</button>

                                        </td>

                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td>Terms and Conditions</td>
                                        <td>Present</td>

                                        <td>
                                            <button class="thumbs-up">👍</button>

                                        </td>

                                    </tr>
                                    <tr>
                                        <td>3</td>
                                        <td>Emails</td>
                                        <td>Not Set</td>

                                        <td>
                                            <button class="thumbs-up">👍</button>

                                        </td>

                                    </tr>
                                    <tr>
                                        <td>4</td>
                                        <td>SMS</td>
                                        <td>Not Set</td>

                                        <td>
                                            <button class="thumbs-up">👍</button>

                                        </td>

                                    </tr>
                                    <tr>
                                        <td>5</td>
                                        <td>Payment Method</td>
                                        <td>M-pesa</td>

                                        <td>
                                            <button class="thumbs-up">👍</button>

                                        </td>

                                    </tr>
                                    <tr>
                                        <td>6</td>
                                        <td>Caretaker</td>
                                        <td>Not Set</td>

                                        <td>
                                            <button class="thumbs-up" onclick="changeStatus(this)">👍</button>

                                        </td>

                                    </tr>
                                    <tr>
                                        <td>7</td>
                                        <td>Caretaker</td>
                                        <td>Not Set</td>

                                        <td>
                                            <button class="thumbs-up" onclick="changeStatus(this)">👍</button>

                                        </td>

                                    </tr>

                                    <tr>
                                        <td>8</td>
                                        <td>Caretaker</td>
                                        <td>Not Set</td>

                                        <td>
                                            <button class="thumbs-down" onclick="changeStatus(this)">👎</button>

                                        </td>

                                    </tr>
                                    <tr>
                                        <td>9</td>
                                        <td>Electricity</td>
                                        <td>Not Set</td>

                                        <td>

                                            <button class="thumbs-down" onclick="changeStatus(this)">👎</button>
                                        </td>

                                    </tr>
                                    <!-- Add more fixed expense rows as needed -->

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer text-center">
                        <a href="javascript:void(0)" class="uppercase">View All Products</a>
                    </div>
                    <!-- /.card-footer -->
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Browser Usage</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="chart-responsive">
                                    <canvas id="pieChart" height="150"></canvas>
                                </div>
                                <!-- ./chart-responsive -->
                            </div>
                            <!-- /.col -->
                            <div class="col-md-4">
                                <ul class="chart-legend clearfix">
                                    <li><i class="far fa-circle text-danger"></i> Chrome</li>
                                    <li><i class="far fa-circle text-success"></i> IE</li>
                                    <li><i class="far fa-circle text-warning"></i> FireFox</li>
                                    <li><i class="far fa-circle text-info"></i> Safari</li>
                                    <li><i class="far fa-circle text-primary"></i> Opera</li>
                                    <li><i class="far fa-circle text-secondary"></i> Navigator</li>
                                </ul>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer p-0">
                        <ul class="nav nav-pills flex-column">
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    United States of America
                                    <span class="float-right text-danger">
                                        <i class="fas fa-arrow-down text-sm"></i>
                                        12%</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    India
                                    <span class="float-right text-success">
                                        <i class="fas fa-arrow-up text-sm"></i> 4%
                                    </span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    China
                                    <span class="float-right text-warning">
                                        <i class="fas fa-arrow-left text-sm"></i> 0%
                                    </span>
                                </a>
                            </li>
                        </ul>
                    </div>
                    <!-- /.footer -->
                </div>
                <!-- /.card -->

                <!-- PRODUCT LIST -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Apartment Rooms</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body p-0">
                        <ul class="products-list product-list-in-card pl-2 pr-2">
                            <li class="item">
                                <div class="product-img">
                                    <img src="dist/img/default-150x150.png" alt="Product Image" class="img-size-50">
                                </div>
                                <div class="product-info">
                                    <a href="javascript:void(0)" class="product-title">Samsung TV
                                        <span class="badge badge-warning float-right">$1800</span></a>
                                    <span class="product-description">
                                        Samsung 32" 1080p 60Hz LED Smart HDTV.
                                    </span>
                                </div>
                            </li>
                            <!-- /.item -->
                            <li class="item">
                                <div class="product-img">
                                    <img src="dist/img/default-150x150.png" alt="Product Image" class="img-size-50">
                                </div>
                                <div class="product-info">
                                    <a href="javascript:void(0)" class="product-title">Bicycle
                                        <span class="badge badge-info float-right">$700</span></a>
                                    <span class="product-description">
                                        26" Mongoose Dolomite Men's 7-speed, Navy Blue.
                                    </span>
                                </div>
                            </li>
                            <!-- /.item -->
                            <li class="item">
                                <div class="product-img">
                                    <img src="dist/img/default-150x150.png" alt="Product Image" class="img-size-50">
                                </div>
                                <div class="product-info">
                                    <a href="javascript:void(0)" class="product-title">
                                        Xbox One <span class="badge badge-danger float-right">
                                            $350
                                        </span>
                                    </a>
                                    <span class="product-description">
                                        Xbox One Console Bundle with Halo Master Chief Collection.
                                    </span>
                                </div>
                            </li>
                            <!-- /.item -->
                            <li class="item">
                                <div class="product-img">
                                    <img src="dist/img/default-150x150.png" alt="Product Image" class="img-size-50">
                                </div>
                                <div class="product-info">
                                    <a href="javascript:void(0)" class="product-title">PlayStation 4
                                        <span class="badge badge-success float-right">$399</span></a>
                                    <span class="product-description">
                                        PlayStation 4 500GB Console (PS4)
                                    </span>
                                </div>
                            </li>
                            <!-- /.item -->
                        </ul>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer text-center">
                        <a href="javascript:void(0)" class="uppercase">View All Products</a>
                    </div>
                    <!-- /.card-footer -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div><!--/. container-fluid -->
    </section>
    <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.apartment-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\BarakaDemo\BarakaDemo\resources\views/landlord/apartmentdashboard.blade.php ENDPATH**/ ?>