<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="row">
                <div class="container">
                    <!-- Main content -->
                    <div class="invoice p-5 mb-6">
                        <!-- title row -->
                        <div class="row">

                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h4>
                                            <!-- Display apartment image -->
<?php if($imagePath): ?>
<img src="<?php echo e(asset($imagePath)); ?>" alt="Apartment Image">
<?php endif; ?>

                                        </h4>
                                    </div>
                                    <div class="col-md-6">
                                        <h4>
                                            <strong class="float-center <?php echo e($invoice->payment_status); ?>"><?php echo e($invoice->payment_status); ?></strong>
                                        </h4>
                                    </div>
                                </div>


                                </h4>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- title row -->
                        <div class="row">

                            <div class="col-12">
                                <h4>
                                    <strong>#<?php echo e($invoice->invoice_number); ?></strong>
                                    <small class="float-right"><?php echo e($invoice->created_at); ?></small>
                                </h4>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- info row -->
                        <div class="row invoice-info">
                            <!-- /.col -->
                            <div class="col-md-4 col-sm-12 col-lg-4 invoice-col">
                                Invoiced To
                                <address>
                                    <strong><?php echo e(Auth::user()->name); ?> <?php echo e(Auth::user()->last_name); ?></strong><br>
                                    <?php echo e(Auth::user()->city); ?>,<?php echo e(Auth::user()->address_1); ?><br>
                                    San Francisco, CA 94107<br>
                                    Phone: <?php echo e(Auth::user()->phone_number); ?><br>
                                    <?php echo e(Auth::user()->email); ?>

                                </address>
                            </div>
                            <!-- /.col -->
                            <div class="col-md-4 col-sm-12 col-lg-4 invoice-col">
                                From
                                <address>
                                    <strong><?php echo e($apartment->name); ?></strong><br>
                                    <?php echo e($apartment->address); ?>,<?php echo e($apartment->city); ?><br>
                                    <?php echo e($apartment->location); ?>,<?php echo e($apartment->city); ?><br>
                                    Phone: <?php echo e($apartment->phone); ?><br>
                                    Email: <?php echo e($apartment->email); ?>

                                </address>
                            </div>

                            <div class="col-md-4 col-sm-12 col-lg-4 invoice-col">
                                <b>Payment Method: <?php echo e(Auth::user()->payment_method); ?></b><br>
                                <br>
                                <b>Instructions<br>
                                    <b>Paybill:</b> 247247<br>
                                    <b>Account No:</b> 0280180439380<br>
                                    <button type="button" class="btn btn-success"><i
                                        class="far fa-credit-card"></i> Submit
                                    Payment
                                </button>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->

                        <!-- Table row -->
                        <div class="row">
                            <h5>Invoice Items</h5>

                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Description</th>
                                        <th> Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td> <?php echo e($invoice->invoice_items); ?>


                                        </td>
                                        <td>
                                            <?php echo e($apartment->currency); ?>.<?php echo e($invoice->total_amount); ?>

                                        </td>
                                    </tr>
                                </tbody>
                            </table>

                        </div>
                        <!-- /.col -->

                        <!-- /.row -->

                        <div class="row">
                            <!-- accepted payments column -->
                            <div class="col-6">
                                <p class="lead">Payment Methods:</p>
                                <img src="../../dist/img/credit/mpesa.png" alt="Mpesa">
                                <img src="../../dist/img/credit/visa.png" alt="Visa">
                                <img src="../../dist/img/credit/mastercard.png" alt="Mastercard">
                                <img src="../../dist/img/credit/american-express.png" alt="American Express">
                                <img src="../../dist/img/credit/paypal2.png" alt="Paypal">
                                <img src="../../dist/img/credit/cash.png" alt="Cash">

                                <p class="text-muted well well-sm shadow-none" style="margin-top: 10px;">
                                    This apartment suports the above payment methods
                                </p>
                            </div>
                            <!-- /.col -->
                            <div class="col-6">
                                

                                <div class="table-responsive">
                                    <table class="table">
                                        <tr>
                                            <th style="width:50%">Subtotal:</th>
                                            <td><strong><?php echo e($apartment->currency); ?>.<?php echo e($invoice->total_amount); ?></strong></td>
                                        </tr>
                                        <tr>
                                            <th>Tax (0%)</th>
                                            <td><?php echo e($apartment->currency); ?>.0</td>
                                        </tr>

                                        <tr>
                                            <th>Total:</th>
                                            <td><strong><?php echo e($apartment->currency); ?>.<?php echo e($invoice->total_amount); ?></strong></td>
                                        </tr>
                                    </table>
                                </div>

                            </div>
                        </div>
                        <!-- /.col -->

                        <!-- /.row -->
                        
                        <div class="row">
                            <div class="col">
                                <h4>Transactions</h4>

                                <?php if(!empty($invoice->payments) && is_array(json_decode($invoice->payments, true))): ?>
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Payment Method</th>
                                                <th>Transaction ID</th>
                                                <th>Amount</th>
                                                <th>Transaction Fee</th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = json_decode($invoice->payments, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($transaction['payment_date']); ?></td>
                                                <td><?php echo e($transaction['payment_method']); ?></td>
                                                <td><?php echo e($transaction['transaction_id']); ?></td>
                                                <td><?php echo e($transaction['payment_amount']); ?></td>
                                                <td><?php echo e($transaction['transaction_fee']); ?></td>


                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                <?php else: ?>
                                    <p>No transactions available.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <!-- this row will not appear when printing -->
                        <div class="row no-print">
                            <div class="col-12">
                                <a href="invoice-print.html" rel="noopener" target="_blank" class="btn btn-default"><i
                                        class="fas fa-print"></i> Print</a>

                                <button type="button" class="btn btn-primary float-right" style="margin-right: 5px;">
                                    <i class="fas fa-download"></i> Generate PDF
                                </button>
                            </div>
                        </div>
                    </div>
                    <!-- /.invoice -->
                </div>
            </div>
            
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.tenant2-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\BarakaDemo\BarakaDemo\resources\views/tenant/invoices/invoice.blade.php ENDPATH**/ ?>