<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row">
                    <div class="col-md-4">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Client info</h4>
                                    </div>
                                    <div class="card-body">
                                        <h6>Name: <strong><?php echo e(auth()->user()->name); ?></strong></h6>
                                        
                                    </div>
                                    <div class="card-footer">
                                        <button class="btn btn-success">Update</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card card-primary card-outline">
                                    <div class="card-header">
                                        <h4>INVOICES</h4>
                                    </div>
                                    <div class="info-box mb-3 bg-success">
                                        <span class="info-box-icon"><i class="far fa-heart"></i></span>

                                        <div class="info-box-content">
                                            <span class="info-box-text">You have no pending invoices</span>
                                            <span class="info-box-number">0</span>
                                        </div>
                                        <!-- /.info-box-content -->
                                    </div>
                                    <div class="card-body">
                                        <a href="<?php echo e(route('tenant.list-invoices')); ?>"> My invoices</a>
                                    </div>
                                    <div class="card-footer">
                                        <button class="btn btn-primary">Generate New Invoice</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3>Shortcuts</h3>
                                    </div>
                                    <div class="card-body">
                                        <!-- Info Boxes Style 2 -->
                        <div class="info-box mb-3 bg-warning">
                            <span class="info-box-icon"><i class="fas fa-tag"></i></span>

                            <div class="info-box-content">
                                <span class="info-box-text">Inventory</span>
                                <span class="info-box-number">5,200</span>
                            </div>
                            <!-- /.info-box-content -->
                        </div>
                        <!-- /.info-box -->

                        <!-- /.info-box -->
                        <div class="info-box mb-3 bg-danger">
                            <span class="info-box-icon"><i class="fas fa-cloud-download-alt"></i></span>

                            <div class="info-box-content">
                                <span class="info-box-text">Downloads</span>
                                <span class="info-box-number">114,381</span>
                            </div>
                            <!-- /.info-box-content -->
                        </div>
                        <!-- /.info-box -->
                        <div class="info-box mb-3 bg-info">
                            <span class="info-box-icon"><i class="far fa-comment"></i></span>

                            <div class="info-box-content">
                                <span class="info-box-text">Direct Messages</span>
                                <span class="info-box-number">163,921</span>
                            </div>
                            <!-- /.info-box-content -->
                        </div>
                        <!-- /.info-box -->
                                        <ul>
                                            <li><a>Book New Room</a></li>
                                            <li><a>View My Roles/Duties</a></li>
                                            <li><a>Logout</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-8 sm-12">
                        <div class="row">

                            <h1>My Transactions</h1>
                            <div class="card card-success card-outline">
                            <table class="table table-responsive">

                                <?php if($transactions->isEmpty()): ?>
                                <p>No transactions found for this user.</p>
                            <?php else: ?>
                            <table class="table table-responsive" id="transaction-table">
                                <thead>
                                    <tr>
                                        <th>Invoice Number</th>
                                        <th class="sort" data-sort="payment-date">Payment Date</th>
                                        <th>Payment Amount</th>
                                        <th>Payment Method</th>
                                        <th>Transaction ID</th>
                                        <th class="capitalize">Transaction Fee</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($payment['invoice_number']); ?></td>
                                            <td class="payment-date"><?php echo e($payment['payment_date']); ?></td>
                                            <td><?php echo e($payment['payment_amount']); ?></td>
                                            <td><?php echo e($payment['payment_method']); ?></td>
                                            <td class="capitalize"><?php echo e($payment['transaction_id']); ?></td>
                                            <td><?php echo e($payment['transaction_fee']); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <?php endif; ?>
                            </table>
                            <hr>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.tenant2-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\BarakaDemo\BarakaDemo\resources\views/tenant/transactions.blade.php ENDPATH**/ ?>