<?php
$apartmentName= $apartment->name ;
$apartmentId= $apartment->id ;
$pageTitle="ADD USER";
$title=$apartmentName.' - '. $pageTitle;
?>


<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">

      <div class="container-fluid">
                <?php echo $__env->make('partials._apartment_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <button id="syncButton" class="btn btn-primary">Sync</button>
                <div class="col-sm-4">
                    <div id="alertContainer"></div>
                </div>
                    <table class="table" id="userTable">
                        <thead>
                            <tr>
                                <th>UserID</th>
                                <th>User</th>
                                <th>Phone</th>
                                <th>Room No</th>
                                <th>Role</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $usersWithRooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <td><?php echo e($user->id); ?></td>
                            <td><?php echo e(optional($user)->name); ?></td>
                            <td><?php echo e($user->phone_number); ?></td>
                            <td>
                                <?php if($user->rooms->isNotEmpty() && $user->rooms[0]->pivot): ?>
                                    <?php echo e($user->rooms[0]->pivot->rooms_id); ?>

                                <?php else: ?>
                                    No room assigned
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($user->apartments->isNotEmpty() && isset($user->apartments[0]->pivot->role)): ?>
                                    <?php echo e($user->apartments[0]->pivot->role); ?>

                                <?php else: ?>
                                    Not listed
                                <?php endif; ?>
                            </td>



                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-secondary dropdown-toggle" type="button" id="userActions" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Actions
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="userActions">
                                                <a class="dropdown-item" href="#">Remove from Room</a>
                                                <a class="dropdown-item" href="#">Assign Role</a>
                                                <!-- Add other action links as needed -->
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

      </div>
    </div>
</div>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.apartment-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\BarakaDemo\BarakaDemo\resources\views/landlord/users/add-user.blade.php ENDPATH**/ ?>