
@extends('layouts.user-layout')

@section('content')



<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <div class="content-wrapper">
        <div class="row justify-content-center">
            @include('partials._message_box')
        </div>
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0"> Check Out Apartment  <small>Featues</small></h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="#">Layout</a></li>
              <li class="breadcrumb-item active">Top Navigation</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <!-- Main content -->
    <div class="content">
        <div class="container">
          <div class="row">
            <div class="col-lg-6">
              <div class="card">
                <card-header>
                    <h1>Empty Rooms</h1>
                </card-header>
                <div class="card-body">
                    <div id="message"></div>
                    <div id="emptyRooms"></div>

                    <div class="inner-box">
                        <div class="results-box" id="results">
                            <!-- Individual room items will be displayed here -->
                        </div>
                    </div>
                </div>
              </div>
            </div>
          </div>
        </div>
    </div>
    </div>
</div>


{{-- <script>
    // Fetch data from the /empty-rooms endpoint
    fetch('/empty-rooms')
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            // Render the fetched data
            renderEmptyRooms(data);
            showMessage('Fetch successful', 'success');
        })
        .catch(error => {
            console.error('Error fetching empty rooms:', error);
            showMessage('Fetch failed', 'error');
        });

    // Function to render the empty rooms data
    function renderEmptyRooms(data) {
        const emptyRoomsDiv = document.getElementById('emptyRooms');

        // Check if there are empty rooms
        if (data.length > 0) {
            // Count the number of available rooms
            const numRooms = data.length;

            // Create a message indicating the number of available rooms
            const message = document.createElement('p');
            message.textContent = `Total ${numRooms} empty rooms available.`;
            emptyRoomsDiv.appendChild(message);

            // Iterate over each room and create HTML elements to display them
            data.forEach(room => {
                const roomDiv = document.createElement('div');
                roomDiv.classList.add('room');

                const roomNumber = document.createElement('h2');
                roomNumber.textContent = 'Room Number: ' + room.room_number;

                const price = document.createElement('p');
                price.textContent = 'Price: ' + room.price;

                const billingCycle = document.createElement('p');
                billingCycle.textContent = 'Billing Cycle: ' + room.billing_cycle;

                const roomSize = document.createElement('p');
                roomSize.textContent = 'Room Size: ' + room.room_size;

                const image = document.createElement('img');
                image.src = room.image ? room.image : 'no-image.png'; // Default image if no image is available
                image.alt = 'Room Image';

                // Append elements to the roomDiv
                roomDiv.appendChild(roomNumber);
                roomDiv.appendChild(price);
                roomDiv.appendChild(billingCycle);
                roomDiv.appendChild(roomSize);
                roomDiv.appendChild(image);

                // Append the roomDiv to the emptyRoomsDiv
                emptyRoomsDiv.appendChild(roomDiv);
            });
        } else {
            // Display a message if no empty rooms are available
            emptyRoomsDiv.textContent = 'No empty rooms available.';
        }
    }

    // Function to display a message on the view
    function showMessage(message, messageType) {
        const messageDiv = document.getElementById('message');
        messageDiv.textContent = message;
        messageDiv.classList.add(messageType);
    }
</script> --}}

<script>
    // Function to fetch both apartments and rooms
    function fetchApartmentsAndRooms() {
        // Fetch apartments
        var apartmentsXHR = new XMLHttpRequest();
        apartmentsXHR.open('GET', 'http://barakademo/api/v1/apartments', true);
        apartmentsXHR.setRequestHeader('Accept', 'application/json');

        apartmentsXHR.onreadystatechange = function() {
            if (apartmentsXHR.readyState === XMLHttpRequest.DONE) {
                if (apartmentsXHR.status === 200) {
                    var apartmentsResponse = JSON.parse(apartmentsXHR.responseText);
                    displayApartments(apartmentsResponse.apartments);
                } else {
                    console.error('Error fetching apartments:', apartmentsXHR.status);
                }
            }
        };

        apartmentsXHR.send();
    }

    // Function to display apartments
    function displayApartments(apartments) {
        // Store apartment data in a global variable or data structure for later use
        window.apartmentsData = apartments;

        // Fetch rooms after fetching apartments
        var roomsXHR = new XMLHttpRequest();
        roomsXHR.open('GET', 'http://barakademo/api/v1/rooms', true);
        roomsXHR.setRequestHeader('Accept', 'application/json');

        roomsXHR.onreadystatechange = function() {
            if (roomsXHR.readyState === XMLHttpRequest.DONE) {
                if (roomsXHR.status === 200) {
                    var roomsResponse = JSON.parse(roomsXHR.responseText);
                    displayRooms(roomsResponse.rooms);
                } else {
                    console.error('Error fetching rooms:', roomsXHR.status);
                }
            }
        };

        roomsXHR.send();
    }
     // Function to find apartment by room ID
     function findApartmentByRoomId(roomId) {
        // Search for apartment by room ID in the stored apartment data
        if (window.apartmentsData) {
            return window.apartmentsData.find(function(apartment) {
                // Check if the current room ID exists in the apartment's associated rooms
                return apartment.rooms.some(function(room) {
                    return room.id === roomId;
                });
            });
        } else {
            return null;
        }
    }
    // Fetch apartments and rooms on page load
    document.addEventListener('DOMContentLoaded', function() {
                                        fetchApartmentsAndRooms();
                                    });

    // JavaScript for slideshow functionality
    function showSlides(roomId) {
        var slideIndex = 0;
        var slides = document.querySelectorAll(`#slideshow-${roomId} .mySlides`);

        function displaySlide() {
            if (slides.length === 1) return; // Do not change slide if only one slide
            for (var i = 0; i < slides.length; i++) {
                slides[i].style.display = 'none';
            }
            slideIndex++;
            if (slideIndex > slides.length) { slideIndex = 1 }
            slides[slideIndex - 1].style.display = 'block';
            var timeoutDuration = slides.length === 0 ? 2000 : 5000; // If no slides, display static image for 5 seconds
            setTimeout(displaySlide, timeoutDuration); // Change image after timeout duration
        }

        displaySlide();
    }


                function displayRooms(rooms) {
                var resultsDiv = document.getElementById('results');

                // Clear existing content
                resultsDiv.innerHTML = '';

                // Display fetched rooms
                rooms.forEach(function(room) {
                    console.log("Processing room:", room);

                    var roomItem = document.createElement('div');
                    roomItem.classList.add('room-item');

                    // Fetch apartment details based on the pivot table relationship
                    var apartment = findApartmentByRoomId(room.id);
                    console.log("Apartment details for room", room.id, ":", apartment);

                    // Create elements to display room data
                var roomDetails = `
                    <div class="slideshow-container" id="slideshow-${room.id}">
                        ${getRoomImages(room)}
                    </div>
                    <div class="room-details">
                        <h3>${apartment ? apartment.currency : 'Unknown Type'} ${room.price}</h3>
                        <p>Description: ${room.description}</p>
                        <p>Location: ${apartment ? apartment.location : 'Unknown Location'}</p>
                        <p>City: ${apartment ? apartment.city : 'Unknown City'}</p>
                        <p>Type: ${apartment ? apartment.type : 'Unknown Type'}</p>
                        <p>Size: ${room.room_size}</p>
                        <button onclick="addToWatchlist(${room.id})">Add to Watchlist</button>
                        <button onclick="bookRoom(${room.id})">Book</button>
                    </div>
                `;


                    roomItem.innerHTML = roomDetails;
                    resultsDiv.appendChild(roomItem);
                     // Show slides for this room
                    showSlides(room.id);

                    // Log room ID and slideshow container ID for debugging
                    console.log("Room ID:", room.id);
                    console.log("Slideshow Container ID:", `slideshow-${room.id}`);
                });
            }

            function getRoomImages(room) {
                    var images = room.room_images;

                    if (images && images.length > 0) {
                        return images.map(function(image) {
                            return `
                                <div class="mySlides fade">
                                    <img src="${image.url}" class="room-image" alt="Room Image">
                                </div>
                            `;
                        }).join('');
                    } else {
                        // If no room images are available, try to display the apartment image
                        var apartmentImages = room.apartment ? room.apartment.images : null;
                        if (apartmentImages && apartmentImages.length > 0) {
                            return apartmentImages.slice(0, 5).map(function(image) {
                                return `
                                    <div class="mySlides fade">
                                        <img src="${image.url}" class="room-image" alt="Apartment Image">
                                    </div>
                                `;
                            }).join('');
                        } else {
                            // If no apartment images are available, display a default image
                            return `
                                <div class="mySlides fade">
                                    <img src="dist/img/AdminLTELogo.png" class="room-image" alt="Default Image">
                                </div>
                            `;
                        }
                    }
                }
                function addToWatchlist(roomId) {
fetch('/api/v1/watchlist/add', {
method: 'POST',
headers: {
'Content-Type': 'application/json',
'X-XSRF-TOKEN': getCookie('XSRF-TOKEN'), // Include XSRF-TOKEN for CSRF protection
'Authorization': 'Bearer ' + getCookie('laravel_session'), // Include laravel_session cookie
credentials: 'include' // Include cookies in the request
},
body: JSON.stringify({ watchable_id: roomId, watchable_type: 'Room' }),
})
.then(response => {
if (response.ok) {
// Handle success
alert('Room added to watchlist successfully');
} else {
// Handle errors
alert('Failed to add room to watchlist');
}
})
.catch(error => {
// Handle network errors or other exceptions
alert('Error occurred while adding room to watchlist: ' + error.message);
});
}

// Helper function to retrieve a specific cookie by name
function getCookie(name) {
const cookieValue = document.cookie.match('(^|;)\\s*' + name + '\\s*=\\s*([^;]+)');
return cookieValue ? cookieValue.pop() : '';
}




function updateUIAfterWatchlistAddition(roomId) {
// Update UI to reflect the change (e.g., change button text, style, etc.)
const watchlistButton = document.getElementById(`watchlist-button-${roomId}`);
if (watchlistButton) {
watchlistButton.textContent = 'Added to Watchlist';
watchlistButton.disabled = true; // Disable button to prevent duplicate addition
// Add additional styling or UI updates as needed
}
}

function bookRoom(roomId) {
fetch('/api/v1/rooms/book', {
method: 'POST',
headers: {
'Content-Type': 'application/json',
// Add any additional headers if required (e.g., authorization token)
},
body: JSON.stringify({ roomId: roomId }),
})
.then(response => {
if (response.ok) {
// Handle success (e.g., show a success message)
alert('Room booked successfully!');
} else {
// Handle errors (e.g., show an error message)
alert('Failed to book the room. Please try again.');
}
})
.catch(error => {
// Handle network errors or other exceptions
console.error('Error occurred while booking the room:', error);
alert('An error occurred while booking the room. Please try again later.');
});
}
// Function to book a room
function bookRoom(roomId, startDate, endDate) {
fetch('/api/rooms/book', {
method: 'POST',
headers: {
'Content-Type': 'application/json',
'Authorization': 'Bearer ' + getCookie('laravel_session'), // Include authentication token
},
body: JSON.stringify({
room_id: roomId,
start_date: startDate,
end_date: endDate
}),
})
.then(response => {
if (response.ok) {
// Handle success
alert('Room booked successfully');
} else {
// Handle errors
alert('Failed to book room');
}
})
.catch(error => {
// Handle network errors or other exceptions
console.error('Error occurred while booking room:', error);
});
}

// Function to book a service
function bookService(serviceId, startDate, endDate) {
fetch('/api/services/book', {
method: 'POST',
headers: {
'Content-Type': 'application/json',
'Authorization': 'Bearer ' + getCookie('laravel_session'), // Include authentication token
},
body: JSON.stringify({
service_id: serviceId,
start_date: startDate,
end_date: endDate
}),
})
.then(response => {
if (response.ok) {
// Handle success
alert('Service booked successfully');
} else {
// Handle errors
alert('Failed to book service');
}
})
.catch(error => {
// Handle network errors or other exceptions
console.error('Error occurred while booking service:', error);
});
}

// Get the modal
var modal = document.getElementById("bookingModal");

// Get the button that opens the modal
var bookButton = document.getElementById("bookButton");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close")[0];

// When the user clicks on the button, open the modal
bookButton.onclick = function() {
modal.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
modal.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
if (event.target == modal) {
modal.style.display = "none";
}
}

// Handle booking confirmation
var confirmBookingButton = document.getElementById("confirmBooking");
confirmBookingButton.onclick = function() {
var startDate = document.getElementById("startDate").value;
var endDate = document.getElementById("endDate").value;

// Call the appropriate booking function here (e.g., bookRoom or bookService)
bookRoom(startDate, endDate);
}


</script>

@endsection
