@extends('layouts.tenant2-layout')

@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row">
                    <div class="col-md-4">
                        <div class="row">
                            <div class="col-md-12">


                                <div class="card">
                                    <div class="card-header">
                                        <h4>Client info</h4>

                                    </div>
                                    <div class="card-body">
                                        <h6>Name:<strong>{{ auth()->user()->name }} </strong></h6>
                                        <h6>Role:<strong>{{ auth()->user()->role }} </strong></h6>
                                        <h6>Name:<strong>{{ auth()->user()->name }} </strong></h6>
                                    </div>
                                    <div class="card-footer">
                                        <button class="btn btn-success"> Update</button>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">


                                <div class="card">
                                    <div class="card-header">
                                        <h4>Contacts</h4>

                                    </div>
                                    <div class="card-body">
                                        <h5>Name:{{ auth()->user()->name }}</h5>
                                    </div>
                                    <div class="card-footer">
                                        <button class="btn btn-success"> New Contact</button>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">


                                <div class="card">
                                    <div class="card-header">
                                        <h3>Shortcuts</h3>

                                    </div>
                                    <div class="card-body">

                                            <ul>
                                                <li><a>Book New Room</a></li>
                                                <li><a>View My Roles/Duties</a></li>
                                                <li><a>Logout</a></li>
                                            </ul>

                                    </div>


                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">


                                <div class="card">
                                    <div class="card-header">
                                        <h3>Apartment Info</h3>

                                    </div>
                                    <div class="card-body">
                                        @if($apartment)
    <!-- Display apartment details -->
    <p>Apartment Name: {{ $apartment->name }}</p>
    <!-- Other apartment details -->

@else
    <!-- User does not belong to any apartment -->
    <p>You do not belong to any apartment.</p>
    <form action="{{ route('request-approval') }}" method="post">
        @csrf
        <select name="apartment_id">
            @foreach($apartments as $apartment)
                <option value="{{ $apartment->id }}">{{ $apartment->name }}</option>
            @endforeach
        </select>
        <button type="submit">Send Request</button>
    </form>
@endif

                                    </div>


                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-md-8 sm-12">
                        <div class="row ">
                            <div class="col-sm-6">


                                <h1>Welcome, {{ auth()->user()->name }}</h1>

                            </div>
                        </div>




                        <div class="content-header data-card-row row ">

                            <div class="col-lg-3 col-6">
                                <!-- small box -->
                                <a href="{{ route('tenantservices.index') }}"
                                    style="text-decoration: none; color: inherit;">
                                    <div class="small-box bg-blue">
                                        <div class="inner">
                                            <p>Services</p>
                                            <h3 class="center">1</h3>
                                        </div>
                                        <div class="icon">
                                            <i class="ion ion-person-add"></i>
                                        </div>
                                    </div>
                                </a>
                            </div>



                            <!--Total user -->

                            <div class="col-lg-3 col-6">
                                <!-- small box -->
                                <a href="', $apartment->id)}}" style="text-decoration: none; color: inherit;">
                                    <div class="small-box bg-yellow">
                                        <div class="inner">
                                            <p>Tickets</p>
                                            <h3 class="center">3</h3>
                                        </div>
                                        <div class="icon">
                                            <i class="ion ion-person-add"></i>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            <!--/Total user -->

                            <!--Total user -->

                            <div class="col-lg-3 col-6">
                                <!-- small box -->
                                <a href="', $apartment->id)}}" style="text-decoration: none; color: inherit;">
                                    <div class="small-box bg-yellow">
                                        <div class="inner">
                                            <p>Rooms</p>
                                            <h3 class="center">1</h3>
                                        </div>
                                        <div class="icon">
                                            <i class="ion ion-person-add"></i>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="col-lg-3 col-6">
                                <!-- small box -->
                                <a href="{{ route('tenant.list-invoices') }}"
                                    style="text-decoration: none; color: inherit;">
                                    <div class="small-box bg-danger">
                                        <div class="inner">
                                            <p>INVOICES</p>
                                            <h3 class="center">3</h3>
                                        </div>
                                        <div class="icon">
                                            <i class="ion ion-person-add"></i>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Your Active Rooms/Services</h4>

                                    </div>
                                    <div class="card-body">
                                        @if($tenantRooms->count() > 0 || $tenantServices->count() > 0)
                                        <!-- Display rooms and services in a table -->
                                        <h5>Rooms</h5>
                                        <table class="table table-responsive">
                                            <thead>
                                                <tr>
                                                    <th>Room Number</th>

                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <!-- Loop through tenant rooms -->
                                                @foreach($tenantRooms as $room)
                                                <tr>
                                                    <td>{{ $room->room_number}}</td>
                                                    <td></td> <!-- Leave service cell blank for now -->
                                                    <td>
                                                        <a href="{{ route('room.details', $room->id) }}" class="btn btn-primary">Manage</a>
                                                    </td>
                                                </tr>
                                                @endforeach

                                                <!-- Loop through tenant services -->
                                                @foreach($tenantServices as $service)
                                                <tr>
                                                    <td></td> <!-- Leave room cell blank for services -->
                                                    <td>{{ $service->name }}</td>
                                                    <td></td> <!-- No action needed for services -->
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                        <h5>Services</h5>
                                        <table class="table table-responsive">
                                            <thead>
                                                <tr>

                                                    <th>Service</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>


                                                <!-- Loop through tenant services -->
                                                @foreach($tenantServices as $service)
                                                <tr>
                                                    <td></td> <!-- Leave room cell blank for services -->
                                                    <td>{{ $service->name }}</td>
                                                    <td></td> <!-- No action needed for services -->
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    @else
                                        <!-- Show message if no rooms or services -->
                                        <p>You have no rooms or services.</p>
                                        <button onclick="window.location='{{ route('find.room') }}'" class="btn btn-primary">Find Room</button>
                                        <!-- Add a similar button for finding services if needed -->
                                    @endif

                            </div>
                                    </div>


                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Refer a Friend to us</h4>
                                    </div>
                                    <div class="card-body">
                                        List rooms
                                    </div>

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Raise Concern to management</h4>
                                    </div>
                                    <div class="card-body">
                                        List rooms
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
        {{-- <div class="container">
            <div class="row">
                <h1>All my Invoices</h1>

                <table class="table">
                    <thead>
                        <tr>
                            <th>Invoice Number</th>
                            <th>Room Number</th>
                            <th>Invoice Date</th>
                            <th>Due Date</th>
                            <th>Amount</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($invoices as $invoice)
                            <tr>
                                <td>
                                    <a href="{{ route('tenant.view-invoice', ['id' => $invoice->id]) }}">
                                        {{ $invoice->invoice_number }}
                                    </a>
                                <td>
                                    {{ $invoice->rooms->room_number }}
                                </td>
                                <td>{{ $invoice->created_at }}</td>
                                <td>{{ $invoice->due_date }}</td>
                                <td>{{ $invoice->total_amount }}</td>
                                <td>{{ $invoice->payment_status }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>





            </div>
        </div> --}}



        <hr>

    </div>
    </div>
@endsection
