@extends('layouts.tenant2-layout')

@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row">
                    <div class="col-md-4">
                        <div class="row">
                            <div class="col-md-12">


                                <div class="card">
                                    <div class="card-header">
                                        <h1>Client info</h1>

                                    </div>
                                    <div class="card-body">
                                        <h1>Name:{{ auth()->user()->name }}</h1>
                                    </div>
                                    <div class="card-footer">
                                        <button class="btn btn-success"> Update</button>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">


                                <div class="card">
                                    <div class="card-header">
                                        <h1>0 Invoices Due</h1>

                                    </div>
                                    <div class="card-body">
                                        <h1>You have no unpaid invoices at this time.</h1>
                                    </div>
                                    <div class="card-footer">
                                        <button class="btn btn-success"> New Contact</button>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">


                                <div class="card">
                                    <div class="card-header">
                                        <h1>Status</h1>

                                    </div>
                                    <div class="card-body">

                                        <ul>
                                            <li><a>Paid</a></li>
                                            <li><a>Unpaid</a></li>
                                            <li><a>Cancelled</a></li>
                                            <li><a>Refunded</a></li>
                                        </ul>

                                    </div>


                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">


                                <div class="card">
                                    <div class="card-header">
                                        <h1>Shortcuts</h1>

                                    </div>
                                    <div class="card-body">

                                        <ul>
                                            <li><a href="{{route('tenant-transactions')}}">Transactions</a></li>
                                            <li><a href="#">Unpaid</a></li>
                                            <li><a href="#">Cancelled</a></li>
                                            <li><a href="#">Refunded</a></li>
                                        </ul>


                                    </div>


                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-md-8 sm-12">
                        <div class="row">
                            <div class="col-md-12">
                                <h3>My Invoices</h3>
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Showing 10 out of 20 Invoices</h3>
                                        <div class="card-tools">
                                            <div class="input-group input-group-sm" style="width: 150px;">
                                              <input type="text" name="table_search" class="form-control float-right" placeholder="Search">

                                              <div class="input-group-append">
                                                <button type="submit" class="btn btn-default">
                                                  <i class="fas fa-search"></i>
                                                </button>
                                              </div>
                                            </div>
                                          </div>
                                        </div>
                                        <!-- /.card-header -->
                                        <div class="card-body table-responsive p-0">
                                          <table class="table table-hover text-nowrap">
                                            <thead>
                                                <tr>
                                                    <th>Invoice Number</th>
                                                    <th>Room Number</th>
                                                    <th>Invoice Date</th>
                                                    <th>Due Date</th>
                                                    <th>Amount</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($invoices as $invoice)
                                                    <tr>
                                                        <td>
                                                            <a href="{{ route('tenant.view-invoice', ['id' => $invoice->id]) }}">
                                                                {{ $invoice->invoice_number }}
                                                            </a>
                                                        <td>
                                                            {{ $invoice->rooms->room_number }}
                                                        </td>
                                                        <td>{{ $invoice->created_at }}</td>
                                                        <td>{{ $invoice->due_date }}</td>
                                                        <td>{{ $invoice->total_amount }}</td>
                                                        <td>{{ $invoice->payment_status }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- /.card-body -->
                                    <div class="card-footer clearfix">
                                        <ul class="pagination pagination-sm m-0 float-right">
                                            <li class="page-item"><a class="page-link" href="#">&laquo;</a></li>
                                            <li class="page-item"><a class="page-link" href="#">1</a></li>
                                            <li class="page-item"><a class="page-link" href="#">2</a></li>
                                            <li class="page-item"><a class="page-link" href="#">3</a></li>
                                            <li class="page-item"><a class="page-link" href="#">&raquo;</a></li>
                                        </ul>
                                    </div>
                                </div>
                                <!-- /.card -->

                                {{-- <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Condensed Full Width Table</h3>
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body p-0">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th style="width: 10px">#</th>
                                                    <th>Task</th>
                                                    <th>Progress</th>
                                                    <th style="width: 40px">Label</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>1.</td>
                                                    <td>Update software</td>
                                                    <td>
                                                        <div class="progress progress-xs">
                                                            <div class="progress-bar progress-bar-danger"
                                                                style="width: 55%"></div>
                                                        </div>
                                                    </td>
                                                    <td><span class="badge bg-danger">55%</span></td>
                                                </tr>
                                                <tr>
                                                    <td>2.</td>
                                                    <td>Clean database</td>
                                                    <td>
                                                        <div class="progress progress-xs">
                                                            <div class="progress-bar bg-warning" style="width: 70%"></div>
                                                        </div>
                                                    </td>
                                                    <td><span class="badge bg-warning">70%</span></td>
                                                </tr>
                                                <tr>
                                                    <td>3.</td>
                                                    <td>Cron job running</td>
                                                    <td>
                                                        <div class="progress progress-xs progress-striped active">
                                                            <div class="progress-bar bg-primary" style="width: 30%"></div>
                                                        </div>
                                                    </td>
                                                    <td><span class="badge bg-primary">30%</span></td>
                                                </tr>
                                                <tr>
                                                    <td>4.</td>
                                                    <td>Fix and squish bugs</td>
                                                    <td>
                                                        <div class="progress progress-xs progress-striped active">
                                                            <div class="progress-bar bg-success" style="width: 90%"></div>
                                                        </div>
                                                    </td>
                                                    <td><span class="badge bg-success">90%</span></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- /.card-body -->
                                </div> --}}
                                <!-- /.card -->
                            </div>
                        </div>
                        {{-- <div class="row">
                            <div class="col-md-12">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Invoice Number</th>
                                            <th>Room Number</th>
                                            <th>Invoice Date</th>
                                            <th>Due Date</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($invoices as $invoice)
                                            <tr>
                                                <td>
                                                    <a href="{{ route('tenant.view-invoice', ['id' => $invoice->id]) }}">
                                                        {{ $invoice->invoice_number }}
                                                    </a>
                                                <td>
                                                    {{ $invoice->rooms->room_number }}
                                                </td>
                                                <td>{{ $invoice->created_at }}</td>
                                                <td>{{ $invoice->due_date }}</td>
                                                <td>{{ $invoice->total_amount }}</td>
                                                <td>{{ $invoice->payment_status }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>


                            </div>
                        </div> --}}
                    </div>


                </div>
            </div>
        </div>
        {{-- <div class="container">
            <div class="row">
                <h1>All my Invoices</h1>

                <table class="table">
                    <thead>
                        <tr>
                            <th>Invoice Number</th>
                            <th>Room Number</th>
                            <th>Invoice Date</th>
                            <th>Due Date</th>
                            <th>Amount</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($invoices as $invoice)
                            <tr>
                                <td>
                                    <a href="{{ route('tenant.view-invoice', ['id' => $invoice->id]) }}">
                                        {{ $invoice->invoice_number }}
                                    </a>
                                <td>
                                    {{ $invoice->rooms->room_number }}
                                </td>
                                <td>{{ $invoice->created_at }}</td>
                                <td>{{ $invoice->due_date }}</td>
                                <td>{{ $invoice->total_amount }}</td>
                                <td>{{ $invoice->payment_status }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>





            </div>
        </div> --}}



        <hr>

    </div>
    </div>
@endsection
