@extends('admin.layouts.admin-layout')
<link href="{{ asset('css/profile.css') }}" rel="stylesheet">
<style>

</style>
@section('content')
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row p-2 ">

                <div class="col-md-2">User ID: {{ $user->id }}</div>
                <div class="col-md-2">Apartment Name:</div>
                <div class="col-md-2">Room Number:</div>
                <div class="col-md-2">Room Price:</div>
            </div>
            <div class="row">
                @include('partials._message_box')
            </div>

            <form method="POST" action="{{ route('profile.update') }}" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <section>
                    <div class="container rounded bg-white mt-5 mb-5">
                        <div class="row">
                            <div class="col-md-3 border-right">
                                <div class="d-flex flex-column align-items-center text-center p-3 py-5"><img
                                        class="rounded-circle mt-5" width="150px" src="{{ asset($user->profile_picture) }}"
                                        alt="Avatar"></span><span class="text-black-50">{{ $user->email }}</span><span>
                                    </span></div>
                            </div>



                            <div class="col-md-5 border-right">
                                <div class="p-3 py-5">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h4 class="text-right">Profile Settings</h4>
                                    </div>
                                    <div class="row mt-2">
                                        <div class="col-md-6"><label class="labels">First Name </label><input type="text"
                                                id="firstName" name="firstName" class="form-control"
                                                placeholder="first name" value="{{ old('name', $user->first_name) }}"></div>
                                        <div class="col-md-6"><label class="labels">Surname</label><input type="text"
                                                name="surname" class="form-control" value="{{ old('name', $user->name) }}"
                                                placeholder="surname"></div>
                                    </div>
                                    <div class="row mt-3">
                                        <div class="col-md-12"><label class="labels">Last Name</label><input type="text"
                                                class="form-control" placeholder="enter Last Name"
                                                value="{{ old('name', $user->last_name) }}"></div>
                                        <div class="col-md-12"><label class="labels">Mobile Number</label><input
                                                type="text" name="phone_number" class="form-control"
                                                placeholder="enter phone number"
                                                value="{{ old('name', $user->phone_number) }}"></div>
                                        <div class="col-md-12"><label class="labels">Mobile Number</label><input
                                                type="text" name="email" class="form-control" placeholder="enter email"
                                                value="{{ old('name', $user->email) }}"></div>
                                        <div class="col-md-12"><label class="labels">Address Line 1</label><input
                                                type="text" name="address1" class="form-control"
                                                placeholder="enter address line 1"
                                                value="{{ old('name', $user->address_1) }}"></div>
                                        <div class="col-md-12"><label class="labels">Address Line 2</label><input
                                                type="text" name="address2" class="form-control"
                                                placeholder="enter address line 2"
                                                value="{{ old('name', $user->address_2) }}"></div>
                                        <div class="form-group">
                                            <label for="secondary_telephone">Secondary Telephone</label>
                                            <input type="text" name="secondary_telephone" id="secondary_telephone"
                                                name="secondary_telephone" class="form-control"
                                                value="{{ old('secondary_telephone', $user->secondary_telephone) }}">
                                        </div>
                                        <div class="col-md-12"><label class="labels">Country</label><input type="text"
                                                id="country" name="country" class="form-control"
                                                placeholder="enter address line 2"
                                                value="{{ old('name', $user->country) }}"></div>
                                        <div class="col-md-12"><label class="labels">County</label><input type="text"
                                                class="form-control" placeholder="enter address line 2"
                                                value="{{ old('name', $user->county) }}"></div>

                                        <div class="col-md-12"><label class="labels">Education</label><input
                                                type="text" class="form-control" placeholder="education"
                                                value="{{ old('name', $user->education_level) }}"></div>
                                    </div>
                                    <div class="row mt-3">
                                        <div class="col-md-6"><label class="labels">County</label><input type="text"
                                                class="form-control" placeholder="country" value=""></div>
                                        <div class="col-md-6"><label class="labels">Location</label><input type="text"
                                                class="form-control" value="" placeholder="state"></div>
                                        <div class="col-md-6"><label class="labels">City</label><input type="text"
                                                id="city" name="city" class="form-control"
                                                value="{{ old('name', $user->city) }}" placeholder="state"></div>
                                    </div>
                                    <div class="form-group">
                                        <label for="profile_picture">Profile Picture</label>
                                        <input type="file" name="profile_picture" id="profile_picture"
                                            class="form-control-file">
                                    </div>
                                    <div class="mt-5 text-center">
                                        <button class="btn btn-primary profile-button" type="submit">Save
                                            Profile</button>
                                        <button class="btn btn-primary profile-button bg-grey" type="submit">Cancel
                                            Changes</button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="p-3 py-5">

                                    <div class="d-flex justify-content-between align-items-center experience"><span>Edit
                                            Experience</span><span class="border px-3 p-1 add-experience"><i
                                                class="fa fa-plus"></i>&nbsp;Experience</span></div><br>
                                    <div class="col-md-12"><label class="labels">Experience in Designing</label><input
                                            type="text" class="form-control" placeholder="experience" value="">
                                    </div> <br>
                                    <div class="col-md-12"><label class="labels">Additional Details</label><input
                                            type="text" class="form-control" placeholder="additional details"
                                            value=""></div>
                                </div>
                            </div>
            </form>
        </div>
    </div>
@endsection
