<style>
    .paid-row {
        background-color: #c3e6cb; /* Green background for paid rows */
    }

    .unpaid-row {
        background-color: #f5c6cb; /* Red background for unpaid rows */
    }
</style>

<table id= "Apartment-this-month-invoices"class="table display">
        <thead>
            <tr>
                <th><input type="checkbox" id="select-all" onclick="selectAllCheckboxes()"></th>
                <th><a  class="sort-header" data-column-index="1" data-sort-type="string">Invoice #</a></th>
                <th><a  class="sort-header" data-column-index="2" data-sort-type="string">Client Name</a></th>
                <th><a  class="sort-header" data-column-index="3" data-sort-type="numeric">Room</a></th>
                <th><a  class="sort-header" data-column-index="4" data-sort-type="date">Invoice Date</a></th>
                <th><a  class="sort-header" data-column-index="5" data-sort-type="date">Due Date</a></th>
                <th><a  class="sort-header" data-column-index="6" data-sort-type="numeric">Total</a></th>
                <th><a  class="sort-header" data-column-index="7" data-sort-type="string">Payment Method</a></th>
                <th><a  class="sort-header" data-column-index="8" data-sort-type="string">Status</a></th>
                <th><a  class="sort-header" data-column-index="9" data-sort-type="numeric">Balance</a></th>
                <th><a  class="sort-header" data-column-index="10" data-sort-type="numeric">Compounded balance</a></th>
                <th><a  class="sort-header" data-column-index="10" data-sort-type="numeric">Send</a></th>
                <th><a  class="sort-header" data-column-index="10" data-sort-type="numeric">Action</a></th>

            </tr>
        </thead>
                    {{-- <form action="{{ route('landlord.apartment-this-month-invoices', ['apartment'=>$apartment->id]) }}" method="GET">
                        <select name="status" onchange="this.form.submit()">
                            <option value="all" {{ $paymentStatus === 'all' ? 'selected' : '' }}>All</option>
                            <option value="Paid" {{ $paymentStatus === 'Paid' ? 'selected' : '' }}>Paid</option>
                            <option value="Unpaid" {{ $paymentStatus === 'Unpaid' ? 'selected' : '' }}>Unpaid</option>
                        </select>
                    </form>
                </th>
                <th>Balance</th>
                <th>Compounded balance</th>
            </tr>
        </thead> --}}
        <tbody>
            @foreach ($users as $user)
                @foreach ($userCompoundedBalances[$user->id] as $invoiceData)
                    @php
                        $invoice = $invoiceData['invoice'];
                        $compoundedBalance = $invoiceData['compounded_balance'];
                        $rowClass = $invoice->payment_status === 'paid' ? 'paid-row' : ($invoice->payment_status === 'unpaid' ? 'unpaid-row' : '');
            @endphp
            <tr class="{{ $rowClass }}">
                    <td><input type="checkbox" class="invoice-checkbox" data-invoice-id="<?php echo $invoice->id; ?>"></td>
                    <td>
                        <a href="{{ route('landlord-edit-invoice', ['apartment'=>$apartment->id, 'invoice' => $invoice->id]) }}">

                            <?php echo $invoice->invoice_number; ?>
                        </a>
                    </td>
                    <td><a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment->id, 'usersInApartment' => $invoice->user->id ]) }}" class="user-link">{{ $invoice->user->name }}</td>
                    <td>{{ optional($invoice->rooms)->room_number }}</td>
                    <td><?php echo $invoice->created_at; ?></td>
                    <td><?php echo $invoice->due_date; ?></td>
                    <td>{{$apartment->currency}}{{ number_format($invoice->total_amount, 2)}} </td>
                    <td>Mpesa</td>
                    <td class="text-uppercase">
                        @if($invoice->payment_status == 'paid')
                            <span class="badge badge-success">PAID</span>
                        @elseif($invoice->payment_status == 'partial')
                            <span class="badge badge-warning">PARTIAL</span>
                        @else
                            <span class="badge badge-danger">UNPAID</span>
                        @endif
                    </td>

                    <td>{{$apartment->currency}}{{ number_format($invoice->balance, 2) }}</td>
                    <td><strong>{{$apartment->currency}}{{ number_format($compoundedBalance, 2) }}</strong></td>
                    <td>
                        <div class="dropdown">
                            <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                Actions
                            </button>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                <!-- Dropdown item for sending emails -->
                                <a class="dropdown-item send-email" href="#" data-invoice-id="{{ $invoice->id }}" data-recipient-email="{{ $invoice->user->email }}">
                                    <img src="email_icon.png" alt="Send Email">
                                </a>

                                <!-- Dropdown item for sending SMS -->
                                <a class="dropdown-item send-sms" href="#" data-user-phone="{{ $invoice->user->phone_number }}" data-invoice-id="{{ $invoice->id }}">
                                    <img src="sms_icon.png" alt="Send SMS">
                                </a>
                            </div>
                        </div>
                    </td>

                    <td><!-- View Email Template button -->
                        <button class="btn btn-primary view-email-template-btn" data-toggle="modal" data-target="#emailTemplateModal"
                            data-template-id="{{ $emailTemplate->id }}"
                            data-apartment-id="{{ $apartment->id }}"
                            data-recipient-name="{{ $invoice->user->name }}"
                            data-invoice-number="{{ $invoice->invoice_number }}"
                            data-invoice-amount="{{$apartment->currency}}{{ number_format($invoice->total_amount, 2)}}"
                            data-invoice-date="{{ $invoice->created_at }}"
                            data-invoice-due_date="{{ $invoice->due_date }}"
                            data-room-number="{{ optional($invoice->rooms)->room_number }}"
                            data-compounded-balance="{{$apartment->currency}}{{ number_format($compoundedBalance, 2) }}"
                            data-invoice-balance="{{$apartment->currency}}{{ number_format($invoice->balance, 2) }}">
                            View
                        </button></td>

                </tr>
                @endforeach
                @endforeach
        </tbody>
    </table>
