 {{--  Display recent payments in a table --}}


    <table class="table table-responsive">
        <thead>
            <tr>
                <th>Invoice Number</th>
                <th>User Name</th>
                <th>Payment Date</th>
                <th>Amount Paid</th>
                <!-- Add more columns as needed -->
            </tr>
        </thead>
        <tbody>
            @foreach ($apartmentRecentPayments as $invoice)
                @if(isset($invoice->payments) && is_iterable($invoice->payments))
                    @foreach ($invoice->payments as $index => $payment)
                        <tr>
                            @if($index === 0) <!-- Check if it's the first payment to display invoice number -->
                                <td rowspan="{{ count($invoice->payments) }}">{{ $invoice->invoice_number }}</td>
                                <td rowspan="{{ count($invoice->payments) }}">{{ $invoice->user->name }}</td>
                            @endif
                            <td>{{ $payment['payment_date'] }}</td>
                            <td>{{ $payment['payment_amount'] }}</td>
                            <!-- Add more columns as needed -->
                        </tr>
                    @endforeach
                @else
                    <tr>
                        <td>{{ $invoice->invoice_number }}</td>
                        <td>{{ $invoice->user->name }}</td>
                        <td colspan="2">No payments available</td> <!-- colspan to span across columns -->
                        <!-- Add more columns as needed -->
                    </tr>
                @endif
            @endforeach
        </tbody>
    </table>


