<!DOCTYPE html>
<!-- Admin CSS and other head content -->
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title> {{ config('app.name') }}</title>
    <base href="{{ \URL::to('/') }}">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="{{ asset('plugins/fontawesome-free/css/all.min.css') }}">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Tempusdominus Bootstrap 4 -->
    <link rel="stylesheet"
        href="{{ asset('plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
    <!-- iCheck -->
    <link rel="stylesheet" href="{{ asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}">
    <!-- JQVMap -->
    <link rel="stylesheet" href="{{ asset('plugins/jqvmap/jqvmap.min.css') }}">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{ asset('css/adminlte.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/landlord.css') }}">
    <link rel="stylesheet" href="{{ asset('css/settingss.css') }}">
    {{-- <link rel="stylesheet" href="{{ asset('css/pacmis.min.css')}}">
  <link rel="stylesheet" href="{{ asset('css/pacmis.css')}}">
  <link rel="stylesheet" href="{{ asset('css/settings.css')}}"> --}}

    <!-- overlayScrollbars -->
    <link rel="stylesheet" href="{{ asset('plugins/overlayScrollbars/css/OverlayScrollbars.min.css') }}">
    <!-- Daterange picker -->
    <link rel="stylesheet" href="{{ asset('plugins/daterangepicker/daterangepicker.css') }}">
    <!-- summernote -->
    <link rel="stylesheet" href="{{ asset('plugins/summernote/summernote-bs4.min.css') }}">
</head>

<!-- Admin content -->

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">

        {{-- <!-- Preloader -->
                    <div class="preloader flex-column justify-content-center align-items-center">
                        <img class="animation__shake" src="dist/img/pacmislogo.png" alt="AdminLTELogo" height="300" width="300">
                    </div> --}}

        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand navbar-blue navbar-light">
            <!-- Left navbar links -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i
                            class="fas fa-bars"></i></a>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    <a href="{{ route('landlord-home') }}" class="nav-link">Clients</a>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    <a href="{{ route('landlord-home') }}" class="nav-link">Orders</a>
                </li>
                {{-- <li class="nav-item d-none d-sm-inline-block">
                    <a href{{ route('landlord-home') }} class="nav-link">Billing</a>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    <a href{{ route('landlord-home') }} class="nav-link">Support</a>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    <a href{{ route('landlord-home') }} class="nav-link">Utilities</a>
                </li> --}}
                <li class="nav-item d-none d-sm-inline-block">
                    <a href{{ route('landlord-home') }} class="nav-link">Addons</a>
                </li>
            </ul>

            <!-- Right navbar links -->
            <ul class="navbar-nav ml-auto">
                <!-- Navbar Search -->
                <li class="nav-item">
                    <a class="nav-link" data-widget="navbar-search" href="#" role="button">
                        <i class="fas fa-search"></i>
                    </a>
                    <div class="navbar-search-block">
                        <form class="form-inline">
                            <div class="input-group input-group-sm">
                                <input class="form-control form-control-navbar" type="search" placeholder="Search"
                                    aria-label="Search">
                                <div class="input-group-append">
                                    <button class="btn btn-navbar" type="submit">
                                        <i class="fas fa-search"></i>
                                    </button>
                                    <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </li>



                <li class="fixed nav-item dropdown user-menu">
                    <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">
                        <img src="{{ asset('storage/' . auth()->user()->profile_picture) }}" alt="User Avatar"
                            class="user-image img-circle elevation-2" alt="User Image">
                        <span class="d-none d-md-inline">@auth
                                {{ Auth::user()->id }}
                            @endauth
                        </span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                        <!-- User image -->
                        <li class="user-header bg-primary">
                            <img src="{{ asset('storage/' . auth()->user()->profile_picture) }}" alt="User Avatar"
                                class="img-circle elevation-2" alt="User Image">

                            <p>
                                {{ Auth::user()->name }}
                                <small>Member since Nov. 2012</small>
                            </p>
                        </li>

                        <!-- Menu Footer-->
                        <li class="user-footer">
                            <a href="{{ route('profile.show') }}"class="btn btn-default btn-flat">Profile</a>
                            <a href="/logout" class="btn btn-default btn-flat float-right">Sign out</a>
                        </li>
                    </ul>
                </li>


            </ul>
        </nav>

        <!-- /.navbar -->
    </div>


    <!-- Main Sidebar Container -->
    <aside class="main-sidebar sidebar-dark-primary elevation-4">
        <!-- Brand Logo -->
        <a href="" class="brand-link">
            <img src="dist/img/pacmislogo.png" alt="PACMIS Logo" class="brand-image  elevation-3"
                style="opacity: .8">
            <span class="brand-text font-weight-light">{{ config('app.name') }}</span>
        </a>

        <!-- Sidebar -->
        <div class="sidebar" style="background-color: #5f74eb; color: rgba(0, 0, 0, 0.918)">
            <!-- Sidebar user panel (optional) -->
            <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                <div class="image">
                    <img src="dist/img/user2-160x160.jpg" class="img-circle elevation-2" alt="User Image">
                </div>
                <div class="/profile">
                    <a href="#" class="d-block">{{ Auth::user()->name }}</a>
                </div>
            </div>

            <!-- SidebarSearch Form -->

            <!-- Sidebar Menu -->
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                    data-accordion="false">
                    <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->
                    <li class="nav-item menu-open">
                        <a href="{{ route('landlord-home') }}" class="nav-link">
                            <i class="nav-icon fas fa-tachometer-alt"></i>
                            <p>
                                Dashboard
                                <i class="right fas "></i>
                            </p>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('landlord-home') }}" class="nav-link">
                            <i class="nav-icon fas fa-th"></i>
                            <p>
                                Payments
                                {{-- <span class="right badge badge-danger">New</span> --}}
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="landlord/Users" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Online Payments</p>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="landlord/Users" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Offline Payments</p>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="landlord/Users" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Payment Gateways</p>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="landlord/Users" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Invoice Lite</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="landlord/Users" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Pricing</p>
                                </a>
                                <ul>
                                    <p>Categories</p>
                                    <p>Pack</p>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a href="landlord/Users" class="nav-link">
                            <i class="nav-icon fas fa-copy"></i>
                            <p>
                                User Management
                                <i class="fas fa-angle-left right"></i>
                                <span class="badge badge-info right">6</span>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="landlord/Users" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>All Users</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="landlord/landlords" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Landlords</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="landlord/Users" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Caretakers </p>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="{{ route('tickets.create') }}" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Tickets</p>
                                </a>
                            </li>

                        </ul>
                    </li>
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fas fa-chart-pie"></i>
                            <p>
                                Apartments
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="{{ route('landlord.all-apartments') }}" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Active Apartments</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Pending Apartments</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Cancelled Apartments</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>uPlot</p>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="nav-item">
                        <a href="/landlord/pages/roomsoccupied" class="nav-link">
                            <i class="nav-icon fas fa-tree"></i>
                            <p>
                                Rooms
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="/landlord/pages/roomsoccupied" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>All Rooms</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="/landlord/apartments" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Apartments</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('roomsApartments') }}" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Empty Rooms</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="/landlord/rooms" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Pending Rooms</p>
                                </a>
                            </li>
                        </ul>
                    </li>

                    {{-- payment reports --}}
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fas fa-chart-pie"></i>
                            <p>
                                Payment Reports
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="{{ route('landlord.this-month-report') }}" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>This Month</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('landlord.monthly-report') }}" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Monthly Reports</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Inline</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>uPlot</p>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fas fa-edit"></i>
                            <p>
                                Documentation
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="pages/forms/general.html" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Terms and Conditions</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="pages/forms/advanced.html" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Announcements</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="pages/forms/editors.html" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Roles & Duties</p>
                                </a>
                            </li>

                        </ul>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('landlord.invoices') }}" class="nav-link">
                            <i class="nav-icon fas fa-table"></i>
                            <p>
                                Invoices
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="{{ route('landlord.invoices') }}" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>All Invoices</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('landlord.invoices') }}" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Paid</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('landlord.this-month-invoices') }}" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>This Month</p>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('landlord-marketingplace') }}" class="nav-link">
                            <i class="nav-icon fas fa-table"></i>
                            <p>
                                Market Place
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="{{ route('landlord-marketingplace') }}" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>All</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('landlord-marketingplace') }}" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Utensils</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('landlord-marketingplace') }}" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Cars</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-header">Personal</li>


                    <li class="nav-item">
                        <a href="{{ route('landlord-license', ['user' => Auth::user()->id]) }}" class="nav-link">
                            <i class="nav-icon fas fa-columns"></i>
                            <p>
                                License
                            </p>
                        </a>
                    </li>


                </ul>


                </ul>
            </nav>
            <!-- /.sidebar-menu -->
            <!-- Sidebar footer -->
            <div class="sidebar-footer">
                <!-- Content for the footer section -->
                <!-- You can add any content or links here -->
                <p>Thank You for managing with us</p>
            </div>
            </nav>
        </div>

        <!-- /.sidebar -->
    </aside>
</body>

<div id="app">
    @yield('content')
</div>

<!-- Admin scripts -->
@yield('scripts')
<footer class="main-footer">
    <strong>Copyright &copy; 2024 <a href="https://PACMIS.com">PACMIS</a>.</strong>
    All rights reserved.
    <div class="float-right d-none d-sm-inline-block">
        <b>Version</b> 1.0.0
    </div>
</footer>

<!-- Control Sidebar -->
<aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
</aside>
<!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="{{ asset('plugins/jquery/jquery.min.js') }}"></script>
<!-- jQuery UI 1.11.4 -->
<script src="{{ asset('plugins/jquery-ui/jquery-ui.min.js') }}"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
    $.widget.bridge('uibutton', $.ui.button)
</script>
<!-- Bootstrap 4 -->
<script src="{{ asset('plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
<!-- ChartJS -->
<script src="{{ asset('plugins/chart.js/Chart.min.js') }}"></script>
<!-- Sparkline -->
<script src="{{ asset('plugins/sparklines/sparkline.js') }}"></script>
<!-- JQVMap -->
<script src="{{ asset('plugins/jqvmap/jquery.vmap.min.js') }}"></script>
<script src="{{ asset('plugins/jqvmap/maps/jquery.vmap.usa.js') }}"></script>
<!-- jQuery Knob Chart -->
<script src="{{ asset('plugins/jquery-knob/jquery.knob.min.js') }}"></script>
<!-- daterangepicker -->
<script src="{{ asset('plugins/moment/moment.min.js') }}"></script>
<script src="{{ asset('plugins/daterangepicker/daterangepicker.js') }}"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="{{ asset('plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script>
<!-- Summernote -->
<script src="{{ asset('plugins/summernote/summernote-bs4.min.js') }}"></script>
<!-- overlayScrollbars -->
<script src="{{ asset('plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js') }}"></script>
<!-- AdminLTE App -->
{{-- <script src="dist/js/adminlte.js"></script> --}}
<!-- AdminLTE for demo purposes -->
{{-- <script src="dist/js/demo.js"></script> --}}
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="{{ asset('dist/js/pages/dashboard.js') }}"></script>

<script src="{{ asset('dist/js/pacmis.js') }}"></script>
<script src="{{ asset('dist/js/adminlte.js') }}"></script>
<script>
    $(document).ready(function() {
        $(".menu-item").click(function() {
            $(this).find(".submenu").toggle();
        });
    });
</script>
<script>
    function changeApartment() {
        var selectedApartmentId = $('#apartmentSelect').val();
        window.location.href = window.location.origin + window.location.pathname.replace(/\/\d+/, '/' +
            selectedApartmentId);
    }
</script>
