<?php
$apartmentName= $apartment->name ;
$apartmentId= $apartment->id ;
$pageTitle="ADD USER";
$title=$apartmentName.' - '. $pageTitle;
?>
@extends('layouts.apartment-layout')

@section('content')

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">

      <div class="container-fluid">
                @include('partials._apartment_header')
                <button id="syncButton" class="btn btn-primary">Sync</button>
                <div class="col-sm-4">
                    <div id="alertContainer"></div>
                </div>
                    <table class="table" id="userTable">
                        <thead>
                            <tr>
                                <th>UserID</th>
                                <th>User</th>
                                <th>Phone</th>
                                <th>Room No</th>
                                <th>Role</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($usersWithRooms as $user)

                            <td>{{ $user->id }}</td>
                            <td>{{ optional($user)->name }}</td>
                            <td>{{ $user->phone_number }}</td>
                            <td>
                                @if ($user->rooms->isNotEmpty() && $user->rooms[0]->pivot)
                                    {{ $user->rooms[0]->pivot->rooms_id }}
                                @else
                                    No room assigned
                                @endif
                            </td>
                            <td>
                                @if ($user->apartments->isNotEmpty() && isset($user->apartments[0]->pivot->role))
                                    {{ $user->apartments[0]->pivot->role }}
                                @else
                                    Not listed
                                @endif
                            </td>



                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-secondary dropdown-toggle" type="button" id="userActions" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Actions
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="userActions">
                                                <a class="dropdown-item" href="#">Remove from Room</a>
                                                <a class="dropdown-item" href="#">Assign Role</a>
                                                <!-- Add other action links as needed -->
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

      </div>
    </div>
</div>
{{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" integrity="sha384-rOHRgeIg9R7I5Nig1I8cjPmWPxRnuWQbzXtA5blr8IYsR8j0nmv0Y2q0iRmwLxZi" crossorigin="anonymous"> --}}



@endsection
