@extends('layouts.apartment-layout')

@section('content')
    <style>
           /* Floating button styles */
           #addUserToApartmentButton {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background-color: #007bff;
            color: white;
            border: none;
            font-size: 24px;
            display: flex;
            justify-content: center;
            align-items: center;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            cursor: pointer;
            z-index: 1000;
        }

        /* Modal styles */
        .modal-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
            z-index: 999;
        }

        .modal-content {
            background-color: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            max-width: 500px;
            width: 100%;
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }



        /* USER LIST TABLE */
        .user-list tbody td>img {
            position: relative;
            max-width: 50px;
            float: left;
            margin-right: 15px;
        }

        .user-list tbody td .user-link {
            display: block;
            font-size: 1.25em;
            padding-top: 3px;
            margin-left: 60px;
        }

        .user-list tbody td .user-subhead {
            font-size: 0.875em;
            font-style: italic;
        }

        /* TABLES */
        .table {
            border-collapse: separate;
        }

        .table-hover>tbody>tr:hover>td,
        .table-hover>tbody>tr:hover>th {
            background-color: #eee;
        }

        .table thead>tr>th {
            border-bottom: 1px solid #C2C2C2;
            padding-bottom: 0;
        }

        .table tbody>tr>td {
            font-size: 0.875em;
            background: #f5f5f5;
            border-top: 10px solid #fff;
            vertical-align: middle;
            padding: 12px 8px;
        }

        .table tbody>tr>td:first-child,
        .table thead>tr>th:first-child {
            padding-left: 20px;
        }

        .table thead>tr>th span {
            border-bottom: 2px solid #C2C2C2;
            display: inline-block;
            padding: 0 5px;
            padding-bottom: 5px;
            font-weight: normal;
        }

        .table thead>tr>th>a span {
            color: #344644;
        }

        .table thead>tr>th>a span:after {
            content: "\f0dc";
            font-family: FontAwesome;
            font-style: normal;
            font-weight: normal;
            text-decoration: inherit;
            margin-left: 5px;
            font-size: 0.75em;
        }

        .table thead>tr>th>a.asc span:after {
            content: "\f0dd";
        }

        .table thead>tr>th>a.desc span:after {
            content: "\f0de";
        }

        .table thead>tr>th>a:hover span {
            text-decoration: none;
            color: #2bb6a3;
            border-color: #2bb6a3;
        }

        .table.table-hover tbody>tr>td {
            -webkit-transition: background-color 0.15s ease-in-out 0s;
            transition: background-color 0.15s ease-in-out 0s;
        }

        .table tbody tr td .call-type {
            display: block;
            font-size: 0.75em;
            text-align: center;
        }

        .table tbody tr td .first-line {
            line-height: 1.5;
            font-weight: 400;
            font-size: 1.125em;
        }

        .table tbody tr td .first-line span {
            font-size: 0.875em;
            color: #969696;
            font-weight: 300;
        }

        .table tbody tr td .second-line {
            font-size: 0.875em;
            line-height: 1.2;
        }

        .table a.table-link {
            margin: 0 5px;
            font-size: 1.125em;
        }

        .table a.table-link:hover {
            text-decoration: none;
            color: #2aa493;
        }

        .table a.table-link.danger {
            color: #fe635f;
        }

        .table a.table-link.danger:hover {
            color: #dd504c;
        }

        .table-products tbody>tr>td {
            background: none;
            border: none;
            border-bottom: 1px solid #ebebeb;
            -webkit-transition: background-color 0.15s ease-in-out 0s;
            transition: background-color 0.15s ease-in-out 0s;
            position: relative;
        }

        .table-products tbody>tr:hover>td {
            text-decoration: none;
            background-color: #f6f6f6;
        }

        .table-products .name {
            display: block;
            font-weight: 600;
            padding-bottom: 7px;
        }

        .table-products .price {
            display: block;
            text-decoration: none;
            width: 50%;
            float: left;
            font-size: 0.875em;
        }

        .table-products .price>i {
            color: #8dc859;
        }

        .table-products .warranty {
            display: block;
            text-decoration: none;
            width: 50%;
            float: left;
            font-size: 0.875em;
        }

        .table-products .warranty>i {
            color: #f1c40f;
        }

        .table tbody>tr.table-line-fb>td {
            background-color: #9daccb;
            color: #262525;
        }

        .table tbody>tr.table-line-twitter>td {
            background-color: #9fccff;
            color: #262525;
        }

        .table tbody>tr.table-line-plus>td {
            background-color: #eea59c;
            color: #262525;
        }

        .table-stats .status-social-icon {
            font-size: 1.9em;
            vertical-align: bottom;
        }

        .table-stats .table-line-fb .status-social-icon {
            color: #556484;
        }

        .table-stats .table-line-twitter .status-social-icon {
            color: #5885b8;
        }

        .table-stats .table-line-plus .status-social-icon {
            color: #a75d54;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-sm-6">
                        @include('partials._apartment_dropdown')
                    </div>
                </div>
            </div>
            <div id="apartment-data" data-apartment="{{ $apartment->id }}"></div>
        </div>



        <section>
            <div class="container-fluid">
                <div class="row ">


                    <div class="col-lg-2 col-6">



                        <div class="data-car">
                            <div href="#" class="data-card-link"target="_blank">
                                {{-- <div class="data-card">
                                <h5 class="data-title">Total Users</h5>
                                <p class="data-value"> {{ $totalUsers}}</p>
                                <div class="data-chart">
                                    <!-- Insert your chart or graph here -->
                                </div>
                            </div> --}}
                                <div class="small-box bg-blue">
                                    <div class="inner">
                                        <p>TOTAL USERS</p>
                                        <h4 class="center">{{ $totalUsers }}</h4>
                                    </div>
                                    <div class="icon">
                                        <i class="ion ion-person-add"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-2 col-6">
                        <div class="small-box bg-green">
                            <div class="inner">
                                <p>Active Tenants</p>
                                <h4 class="center">{{ $totalUsers }}</h4>
                            </div>
                            <div class="icon">
                                <i class="ion ion-person-add"></i>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-2 col-6">
                        <div class="small-box bg-blue">
                            <div class="inner">
                                <p>Guests</p>
                                <h4 class="center">{{ $totalUsers }}</h4>
                            </div>
                            <div class="icon">
                                <i class="ion ion-person-add"></i>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-2 col-6">
                        <div class="small-box bg-blue">
                            <div class="inner">
                                <p>With Roles</p>
                                <h4 class="center">{{ $totalUsers }}</h4>
                            </div>
                            <div class="icon">
                                <i class="ion ion-person-add"></i>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-2 col-6">
                        <div class="small-box bg-yellow">
                            <div class="inner">
                                <p>Pending Request</p>
                                <h4 class="center">{{ $totalUsers }}</h4>
                            </div>
                            <div class="icon">
                                <i class="ion ion-person-add"></i>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2 col-6">
                        <div class="small-box bg-red">
                            <div class="inner">
                                <p>Pending Delete</p>
                                <h4 class="center">{{ $totalUsers }}</h4>
                            </div>
                            <div class="icon">
                                <i class="ion ion-person-add"></i>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </section>

        <section>
            <div class="container-fluid content-header text-uppercase">
                <div>
                    <h4>Users in the Apartment</h4>
                </div>
            </div>

            <div class="container-fluid">
                <div class="col-md-12 mb-2 px-2 py-2">
                    <div class="card">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-6 d-flex justify-content-right">
                                    <h3> Apartment Users </h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">

                            <div class="col-lg-12">
                                <div class="main-box clearfix">
                                    <div class="table-responsive">
                                        <table class="table user-list">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Phone</th>
                                                    <th>User Status</th>

                                                    <th>Room No</th>
                                                    <th>Room Price</th>
                                                    <th>Date Joined</th>
                                                    <th>Email</th>


                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($usersInApartment as $user)
                                                    <tr>
                                                        <td>{{ $user->id }}</td>
                                                        <td>
                                                            <img src="{{ asset('storage/' . $user->profile_picture) }}"
                                                                alt="">
                                                            {{-- src="https://bootdey.com/img/Content/avatar/avatar1.png" --}}

                                                            <a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment->id, 'usersInApartment' => $user->id]) }}"
                                                                class="user-link">{{ $user->name }}</a>
                                                            <span class="user-subhead">
                                                                @foreach ($user->roles as $role)
                                                                    @switch($role->name)
                                                                        @case('landlord')
                                                                            <span style="color: purple;">{{ $role->name }}</span>
                                                                        @break

                                                                        @case('caretaker')
                                                                            <span style="color: blue;">{{ $role->name }}</span>
                                                                        @break

                                                                        @case('tenant')
                                                                            <span style="color: black;">{{ $role->name }}</span>
                                                                        @break

                                                                        @case('guest')
                                                                            <span style="color: red;">{{ $role->name }}</span>
                                                                        @break

                                                                        @default
                                                                            {{ $role->name }}
                                                                    @endswitch
                                                                @endforeach

                                                            </span>
                                                        </td>
                                                        <td>{{ $user->phone_number }}</td>
                                                        <td class="text-center">
                                                            <span class="label label-default"><strong>
                                                                    @if ($user->status === 'active')
                                                                        <span style="color: green;">Active</span>
                                                                    @elseif($user->status === 'inactive')
                                                                        <span style="color: red;">Inactive</span>
                                                                    @else
                                                                        <span>Unknown</span>
                                                                    @endif
                                                            </span>
                                                        </td>
                                                        <td>

                                                            @if ($user->rooms->isNotEmpty())
                                                                {{ $user->rooms[0]->pivot->rooms_id }}
                                                            @else
                                                                No room assigned
                                                            @endif
                                                        </td>

                                                        <td>
                                                            price
                                                        </td>
                                                        <td>
                                                            2013/08/08
                                                        </td>

                                                        <td>
                                                            <a href="#">mila@kunis.com</a>
                                                        </td>
                                                        <td style="width: 20%;">
                                                            <a href="#" class="table-link">
                                                                <span class="fa-stack">
                                                                    <i class="fa fa-square fa-stack-2x"></i>
                                                                    <i class="fa fa-search-plus fa-stack-1x fa-inverse"></i>
                                                                </span>
                                                            </a>
                                                            <a href="#" class="table-link">
                                                                <span class="fa-stack">
                                                                    <i class="fa fa-square fa-stack-2x"></i>
                                                                    <i class="fa fa-pencil fa-stack-1x fa-inverse"></i>
                                                                </span>
                                                            </a>
                                                            <a href="#" class="table-link danger">
                                                                <span class="fa-stack">
                                                                    <i class="fa fa-square fa-stack-2x"></i>
                                                                    <i class="fa fa-trash-o fa-stack-1x fa-inverse"></i>
                                                                </span>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>


                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            Add {{ __('$collection->links()') }}
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <button id="addUserToApartmentButton" onclick="openAddUserToApartmentPopup()">+</button>


        <div class="content-wrapper">
            <div id="userFormModal" class="modal-overlay mb-6">
                <div class="modal-content">
                    <span class=" float-right close" onclick="closeAddUserToApartmentPopup()">&times;</span>
                    <!-- Your form content goes here -->
                    <form id="userForm">
                        @csrf
                        <!-- Input fields for id, phone number, and national_id -->
                        <label for="userId">User ID:</label>
                        <input type="text" id="userId" name="userId" required>

                        <label for="phoneNumber">Phone Number:</label>
                        <input type="text" id="phoneNumber" name="phoneNumber" required>

                        <label for="nationalId">National ID:</label>
                        <input type="text" id="nationalId" name="nationalId" required>

                        <!-- Add more fields if needed -->

                        <button type="button" onclick="searchAndAddUserToApartment()">Find User</button>

                        <!-- Loading spinner -->
                        <div id="loadingSpinner" style="display: none;">Loading...</div>

                        <!-- Search results table -->
                        <table id="searchResultsTable" style="display: none;">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone Number</th>
                                    <th>ID Number</th>
                                    <th>Country</th>
                                    <!-- Add more columns if needed -->
                                </tr>
                            </thead>
                            <tbody id="searchResultsBody"></tbody>
                        </table>

                        <!-- Button to add user to apartment (initially hidden) -->
                        <button class="btn button-primary my-button" type="button" id="addUserButton"
                            style="display: none;">Add User to Apartment</button>


                        <!-- Confirmation popup -->
                        <div id="confirmationPopup" style="display: none;">
                            <p>Are you sure you want to add this user to the apartment?</p>
                            <button type="button" onclick="confirmAddUser()">OK</button>
                            <button type="button" onclick="cancelAddUser()">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script>
        function openAddUserToApartmentPopup() {
            document.getElementById('userFormModal').style.display = 'flex';
        }

        function closeAddUserToApartmentPopup() {
            document.getElementById('userFormModal').style.display = 'none';
        }
    </script>
@endsection
