@extends('layouts.apartment-layout')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Register New Tenant/User</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Add User</li>
            </ol>
          </div>
        </div>
        <div class="row">
            @include('partials._message_box')
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <!-- general form elements -->
            <div class="card card-primary">
                <div class="card-header">
                  <h3 class="card-title">Personal information</h3>
                </div>
                <!-- /.card-header -->
                <form method="POST" action="{{ route('landlord.new-user-registration',$apartment->id)}}">
                @csrf
                    <div class="row">
                    <div class="col-md-6">
                <!-- form start -->

                  <div class="card-body">
                    <div class="row">
                        @include('partials._message_box')
                    </div>

                        <div class="form-group">
                            <label for="address1">First Name</label>
                            <input type="text" class="form-control" id="first_name" name="first_name" required>
                        </div>
                        <div class="form-group">
                            <label for="address1">Surname</label>
                            <input type="text" class="form-control" id="surname" name="surname" required>
                        </div>
                        <div class="form-group">
                            <label for="address1">Last Name</label>
                            <input type="text" class="form-control" id="last_name" name="last_name" required>
                        </div>
                        <div class="form-group">
                      <label for="exampleInputEmail1">Email address</label>
                      <input type="email" class="form-control" id="email" name="email" placeholder="Enter email" required>
                        </div>
                    <div class="form-group">
                      <label for="phonenumber">Phone Number</label>
                      <input type="text" class="form-control" id="phone_number" name="phone_number" required>
                    </div>
                    <div class="form-group">
                        <label for="phonenumber">ID Number</label>
                        <input type="text" class="form-control" id="id_number" name="id_number" required>
                      </div>
                    <div class="form-group">
                        <label for="exampleInputPassword1">Password</label>
                        <input type="password" class="form-control" id="password" placeholder="password">
                      </div>

                    <div class="form-group">
                      <label for="exampleInputFile">Profile Image</label>
                      <div class="input-group">
                        <div class="custom-file">
                          <input type="file" class="custom-file-input" id="profileimage">
                          <label class="custom-file-label" for="profileimage">Choose file</label>
                        </div>
                        <div class="input-group-append">
                          <span class="input-group-text">Upload</span>
                        </div>
                      </div>
                    </div>
                    <div class="form-group">
                        <label for="exampleSelectBorder">Marital Status </label>
                        <select class="custom-select form-control-border" id="maritalstatus" name="maritalstatus">
                          <option>Single</option>
                          <option>Married</option>
                          <option>Divorced</option>
                        </select>
                      </div>
                    <div class="form-check">
                      <input type="checkbox" class="form-check-input" id="assignRoom">
                      <label class="form-check-label" for="assignRoom">Assign Room</label>
                    </div>
                  </div>
                    </div>
                  <!-- /.card-body -->


                    <div class="col-md-6">
                        <div class="inner-box">
                            <div class="card-body">

                        <div class="form-group">
                            <label for="address1">Address 1</label>
                            <input type="text" class="form-control" id="address1" name="address1">
                        </div>

                        <div class="form-group">
                            <label for="address2">Address 2 (Optional)</label>
                            <input type="text" class="form-control" id="address2" name="address2">
                        </div>
                        <div class="form-group">
                            <label for="companyName">Company Name (Optional)</label>
                            <input type="text" class="form-control" id="companyName" name="companyName">
                        </div>
                        </div>
                        </div>
                    </div>

                    <div class="row">

                        <div class="card-body">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>How did you find about us</label>
                                    <select class="form-control select2" style="width: 100%;">
                                      <option selected="selected">Friend</option>
                                      <option>Social Media</option>
                                      <option>Friend</option>
                                      <option>Delaware</option>
                                      <option>Tennessee</option>
                                      <option>Texas</option>
                                      <option>Washington</option>
                                    </select>
                                  </div>
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                              <input type="checkbox" class="custom-control-input" id="customSwitch1">
                              <label class="custom-control-label" for="customSwitch1">Toggle this custom switch element</label>
                              <input type="checkbox" name="my-checkbox" checked data-bootstrap-switch>
                            </div>
                          </div>
                          <div class="custom-control custom-checkbox">
                            <input class="custom-control-input" type="checkbox" id="customCheckbox2" disabled>
                            <label for="customCheckbox2" class="custom-control-label">Feature</label>
                            <input type="checkbox" name="my-checkbox" checked data-bootstrap-switch>
                          </div>
                          <div class="custom-control custom-checkbox">
                            <input class="custom-control-input" type="checkbox" id="customCheckbox3" disabled>
                            <label for="customCheckbox3" class="custom-control-label">Enhancement</label>
                          </div>

                          <div class="form-group">
                            <div class="custom-control custom-switch custom-switch-off-danger custom-switch-on-success">
                              <input type="checkbox" class="custom-control-input" id="customSwitch3">
                              <label class="custom-control-label" for="customSwitch3">Toggle this custom switch element with custom colors danger/success</label>
                              <input type="checkbox" name="my-checkbox" checked data-bootstrap-switch>
                            </div>
                          </div>
                          <div class="form-group">
                            <label>Add User Notes</label>
                            <textarea class="form-control" rows="3" placeholder="Enter ..."></textarea>
                          </div>
                        </div>
                        </div>

                    </div>
                </div>

                <div class="card-footer d-flex justify-content-align-center">
                    <button type="submit" class="btn btn-primary">Register Tenant</button>
                  </div>
                    </div>
                </div>
            </form>
              </div>
              <!-- /.card -->
            </div>
        </div>

  @endsection

