@extends('layouts.apartment-layout')

@section('content')

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            Register Tenant
          </div>
          <div class="col-sm-3">

          </div>
          <div class="col-sm-3">
            {{-- <!-- Display user avatar -->
           <img class="rounded-circle fixed" width="150px"

            src="{{ asset('storage/' . $user->profile_picture) }}" alt="Tenant Avatar"><span class="text-black-50">{{$user->phone_number}}</span> --}}
          </div>
        </div>
      </div>



    </div>



    <!-- Content Sections -->
             @include('partials._message_box')

             <div class="row">
                <div class="col-md-12">
                  <div class="card">
                    <div class="card-header">
                      <h5 class="card-title text-center">Personal Information</h5>

                      <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                          <i class="fas fa-minus"></i>
                        </button>
                        <div class="btn-group">
                          <button type="button" class="btn btn-tool dropdown-toggle" data-toggle="dropdown">
                            <i class="fas fa-wrench"></i>
                          </button>
                          <div class="dropdown-menu dropdown-menu-right" role="menu">
                            <a href="#" class="dropdown-item">Action</a>
                            <a href="#" class="dropdown-item">Another action</a>
                            <a href="#" class="dropdown-item">Something else here</a>
                            <a class="dropdown-divider"></a>
                            <a href="#" class="dropdown-item">Separated link</a>
                          </div>
                        </div>
                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                          <i class="fas fa-times"></i>
                        </button>
                      </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                      <div class="row">
                        <div class="col-md-12">
                            <form>
                                <div class="form-group">
                                    <label for="firstName">First Name</label>
                                    <input type="text" class="form-control" id="firstName" name="firstName" required>
                                </div>
                                <div class="form-group">
                                    <label for="address1">Address 1</label>
                                    <input type="text" class="form-control" id="address1" name="address1" required>
                                </div>
                                <div class="form-group">
                                    <label for="lastName">Last Name</label>
                                    <input type="text" class="form-control" id="lastName" name="lastName" required>
                                </div>
                                <div class="form-group">
                                    <label for="address2">Address 2 (Optional)</label>
                                    <input type="text" class="form-control" id="address2" name="address2">
                                </div>
                                <div class="form-group">
                                    <label for="companyName">Company Name (Optional)</label>
                                    <input type="text" class="form-control" id="companyName" name="companyName">
                                </div>
                            </form>

                          </div>
                          <!-- /.chart-responsive -->
                        </div>
                        <!-- /.col -->

                        <!-- /.col -->
                      </div>
                      <!-- /.row -->
                    </div>
                    <!-- ./card-body -->
                    <div class="card-footer">
                      <div class="row">
                        <div class="col-sm-3 col-6">
                          <div class="description-block border-right">
                            <span class="description-percentage text-success"><i class="fas fa-caret-up"></i> 17%</span>
                            <h5 class="description-header">$35,210.43</h5>
                            <span class="description-text">TOTAL REVENUE</span>
                          </div>
                          <!-- /.description-block -->
                        </div>
                        <!-- /.col -->
                        <div class="col-sm-3 col-6">
                          <div class="description-block border-right">
                            <span class="description-percentage text-warning"><i class="fas fa-caret-left"></i> 0%</span>
                            <h5 class="description-header">$10,390.90</h5>
                            <span class="description-text">TOTAL COST</span>
                          </div>
                          <!-- /.description-block -->
                        </div>
                        <!-- /.col -->
                        <div class="col-sm-3 col-6">
                          <div class="description-block border-right">
                            <span class="description-percentage text-success"><i class="fas fa-caret-up"></i> 20%</span>
                            <h5 class="description-header">$24,813.53</h5>
                            <span class="description-text">TOTAL PROFIT</span>
                          </div>
                          <!-- /.description-block -->
                        </div>
                        <!-- /.col -->
                        <div class="col-sm-3 col-6">
                          <div class="description-block">
                            <span class="description-percentage text-danger"><i class="fas fa-caret-down"></i> 18%</span>
                            <h5 class="description-header">1200</h5>
                            <span class="description-text">GOAL COMPLETIONS</span>
                          </div>
                          <!-- /.description-block -->
                        </div>
                      </div>
                      <!-- /.row -->
                    </div>
                    <!-- /.card-footer -->
                  </div>
                  <!-- /.card -->
                </div>
                <!-- /.col -->
              </div>
              <!-- /.row -->
             <div class="row">
                <div class="outer-box">
                    <div class="container mt-5">
                        <!-- First Section -->
                        <div class="row">
                            <div class="col-md-6">
                                <h2>Personal Information</h2>
                                <form>
                                    <div class="form-group">
                                        <label for="firstName">First Name</label>
                                        <input type="text" class="form-control" id="firstName" name="firstName" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="address1">Address 1</label>
                                        <input type="text" class="form-control" id="address1" name="address1" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="lastName">Last Name</label>
                                        <input type="text" class="form-control" id="lastName" name="lastName" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="address2">Address 2 (Optional)</label>
                                        <input type="text" class="form-control" id="address2" name="address2">
                                    </div>
                                    <div class="form-group">
                                        <label for="companyName">Company Name (Optional)</label>
                                        <input type="text" class="form-control" id="companyName" name="companyName">
                                    </div>
                                </form>
                            </div>

                            <div class="col-md-6">
                                <!-- Add additional fields for the first section as needed -->
                            </div>
                        </div>

                        <!-- Second Section -->
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <h2>Contact Information</h2>
                                <form>
                                    <div class="form-group">
                                        <label for="city">City</label>
                                        <input type="text" class="form-control" id="city" name="city" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="email">Email Address</label>
                                        <input type="email" class="form-control" id="email" name="email" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="state">State/Region</label>
                                        <input type="text" class="form-control" id="state" name="state" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="password">Password</label>
                                        <input type="password" class="form-control" id="password" name="password" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="postcode">Postcode</label>
                                        <input type="text" class="form-control" id="postcode" name="postcode" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="country">Country</label>
                                        <select class="form-control" id="country" name="country" required>
                                            <option value="Kenya">Kenya</option>
                                            <!-- Add other countries as needed -->
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="phoneNumber">Phone Number</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">+254</span>
                                            </div>
                                            <input type="text" class="form-control" id="phoneNumber" name="phoneNumber" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="language">Language</label>
                                        <input type="text" class="form-control" id="language" name="language" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="paymentMethod">Payment Method</label>
                                        <select class="form-control" id="paymentMethod" name="paymentMethod" required>
                                            <option value="default">Default</option>
                                            <option value="change">Select to Change Default</option>
                                            <!-- Add other payment methods as needed -->
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="status">Status</label>
                                        <select class="form-control" id="status" name="status" required>
                                            <option value="active">Active</option>
                                            <!-- Add other status options as needed -->
                                        </select>
                                    </div>
                                </form>
                            </div>

                            <div class="col-md-6">
                                <!-- Add additional fields for the second section as needed -->
                            </div>
                        </div>

                        <!-- Third Section -->
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <h2>Additional Information</h2>
                                <form>
                                    <div class="form-group">
                                        <label for="billingContact">Billing Contact</label>
                                        <select class="form-control" id="billingContact" name="billingContact" required>
                                            <option value="default">Default</option>
                                            <!-- Add other billing contact options as needed -->
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="clientGroup">Client Group</label>
                                        <select class="form-control" id="clientGroup" name="clientGroup" required>
                                            <option value="none">None</option>
                                            <!-- Add other client group options as needed -->
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="currency">Currency</label>
                                        <select class="form-control" id="currency" name="currency" required>
                                            <option value="KES">KES</option>
                                            <!-- Add other currency options as needed -->
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="emailNotifications">Email Notifications</label>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="generalEmails" id="generalEmails" name="emailNotifications[]">
                                            <label class="form-check-label" for="generalEmails">General Emails - All account related emails</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="invoiceEmails" id="invoiceEmails" name="emailNotifications[]">
                                            <label class="form-check-label" for="invoiceEmails">Invoice Emails - New Invoices, Reminders, & Overdue Notices</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="supportEmails" id="supportEmails" name="emailNotifications[]">
                                            <label class="form-check-label" for="supportEmails">Support Emails - Receive a copy of all Support Ticket Communications</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="productEmails" id="productEmails" name="emailNotifications[]">
                                            <label class="form-check-label" for="productEmails">Product Emails - Welcome Emails, Suspensions & Other Lifecycle Notifications</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="domainEmails" id="domainEmails" name="emailNotifications[]">
                                            <label class="form-check-label" for="domainEmails">Domain Emails - Registration/Transfer Confirmation & Renewal Notices</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="affiliateEmails" id="affiliateEmails" name="emailNotifications[]">
                                            <label class="form-check-label" for="affiliateEmails">Affiliate Emails - Receive Affiliate Notifications</label>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div class="col-md-6">
                                <!-- Add additional fields for the third section as needed -->
                            </div>
                        </div>

                        <!-- Fourth Section -->
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <h2>Settings</h2>
                                <form>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="lateFees" id="lateFees" name="settings[]">
                                        <label class="form-check-label" for="lateFees">Late Fees</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="overdueNotices" id="overdueNotices" name="settings[]">
                                        <label class="form-check-label" for="overdueNotices">Overdue Notices</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="taxExempt" id="taxExempt" name="settings[]">
                                        <label class="form-check-label" for="taxExempt">Tax Exempt</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="separateInvoices" id="separateInvoices" name="settings[]">
                                        <label class="form-check-label" for="separateInvoices">Separate Invoices</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="disableCCProcessing" id="disableCCProcessing" name="settings[]">
                                        <label class="form-check-label" for="disableCCProcessing">Disable CC Processing</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="marketingEmails" id="marketingEmails" name="settings[]">
                                        <label class="form-check-label" for="marketingEmails">Marketing Emails Opt-in</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="statusUpdate" id="statusUpdate" name="settings[]">
                                        <label class="form-check-label" for="statusUpdate">Status Update Allow Single Sign-On</label>
                                    </div>
                                </form>
                            </div>

                            <div class="col-md-6">
                                <!-- Add additional fields for the fourth section as needed -->
                            </div>
                        </div>

                        <!-- Fifth Section -->
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <h2>Account Options</h2>
                                <form>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="owner" id="owner" name="accountOptions[]">
                                        <label class="form-check-label" for="owner">Create a new user.</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="associate" id="associate" name="accountOptions[]">
                                        <label class="form-check-label" for="associate">Associate with an existing user.</label>
                                    </div>
                                </form>
                            </div>

                            <div class="col-md-6">
                                <!-- Add additional fields for the fifth section as needed -->
                            </div>
                        </div>

                        <!-- Sixth Section -->
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <h2>Admin Notes</h2>
                                <form>
                                    <div class="form-group">
                                        <label for="adminNotes">Admin Notes</label>
                                        <textarea class="form-control" id="adminNotes" name="adminNotes" rows="4"></textarea>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="sendAdminMessage" id="sendAdminMessage" name="sendAdminMessage">
                                        <label class="form-check-label" for="sendAdminMessage">Check to send a New Account Information Message</label>
                                    </div>
                                </form>
                            </div>

                            <div class="col-md-6">
                                <!-- Add additional fields for the sixth section as needed -->
                            </div>
                        </div>
                </div>
            </div>
        </div>



@endsection


