@extends('layouts.apartment-layout')

@section('content')
{{-- <style>
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 0;
        overflow: hidden;
    }

    .widget-container {
        position: absolute;
        top: 10px;
        right: 10px;
        width: 300px;
        height: 400px;
        background-color: #fff;
        border: 1px solid #ddd;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        overflow-y: auto;
    }

    .widget-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 10px;
        background-color: #f3f3f3;
        border-bottom: 1px solid #ddd;
        cursor: move;
    }

    .widget-title {
        margin: 0;
    }

    .widget-content {
        padding: 10px;
    }

    .close-btn {
        cursor: pointer;
    }

    .refresh-btn, .minimize-btn {
        cursor: pointer;
        margin-right: 10px;
    }
</style> --}}
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="row ">
            <div class="col-md-4">

                 <!-- Apartment Selection Dropdown -->
<div class="form-group">
    <label for="apartmentSelect">Select Tenant:</label>
    <select class="form-control" id="apartmentSelect" onchange="changeApartment()">
        @foreach ($apartments as $apartment)
            @if (is_object($apartment))
            <option value="{{ $apartment->id }}">{{ $apartment->name }}</option>
            @endif
        @endforeach
    </select>

</div>
            </div>
            <div class="col-md-4">
                <!-- Middle section left empty -->
                @if (session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif
            </div>

            <div class="col-md-4">
                <h1>Caretaker</h1>
                  <ul>
                    @foreach ($caretakers as $caretaker)
                        <li>{{ $caretaker->name }} ({{ $caretaker->email }})</li>
                    @endforeach
                </ul>

            </div>



            {{-- <div id="assignCaretakerModal" style="display: none;">
                <form action="{{ route('assignCaretaker', ['apartment' => $apartment]) }}" method="post">
                    @csrf
                    <label for="user_id">Select Caretaker:</label>
                    <select name="user_id" id="user_id">
                        @foreach($usersInApartmentWithCaretakerRole as $user)
                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                        @endforeach
                    </select>
                    <button type="submit" class="btn btn-primary">Assign Caretaker Role</button>
                </form>
            </div> --}}




            </div>
        </div>







            <div class="container-fluid">
                <div class="row">


                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <a href="{{ route('landlord.manage.rooms', $apartment->id)}}" style="text-decoration: none; color: inherit;">
                        <div class="small-box bg-blue" >
                            <div class="inner">
                                <p >TOTAL ROOMS</p>
                                <h3 class="center">{{ $apartment->rooms->count() }}</h3>
                            </div>
                            <div class="icon">
                                <i class="ion ion-person-add"></i>
                            </div>
                        </div>
                    </a>
                </div>

                  <!--/Total user -->

                    <!--Total user -->

                    <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <a href="{{ route('landlord.manage.users', $apartment->id)}}" style="text-decoration: none; color: inherit;">
                            <div class="small-box bg-yellow" >
                                <div class="inner">
                                    <p>TOTAL USERS</p>
                                    <h3 class="center">{{ $totalUsersCount }}</h3>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-person-add"></i>
                                </div>
                            </div>
                        </a>
                    </div>

                      <!--/Total user -->

                {{-- <a href="{{ route('landlord.manage.users', $apartment->id) }}" class="data-card-link"target="_blank">
                    <div class="data-card">
                        <h5 class="data-title">Total Users</h5>
                        <p class="data-value"><i class="fas fa-dollar-sign"></i>{{ $totalUsersCount}}</p>
                        <div class="data-chart">
                            <!-- Insert your chart or graph here -->
                        </div>
                    </div>
                </a> --}}

                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <a href="{{ route('landlord-apartment-invoices', $apartment->id)}}" style="text-decoration: none; color: inherit;">
                    <div class="small-box bg-success">
                      <div class="inner">
                        <h3>KSh. {{ $totalPaidThisMonth}}<sup style="font-size: 20px">{{ $percentagePaid}}</sup></h3>

                        <p>Amount Paid (This Month)</p>
                      </div>
                      <div class="icon">
                        <i class="ion ion-stats-bars"></i>
                      </div>

                    </div>
                    </a>
                  </div>
                  <!-- ./col -->
                  <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-danger">
                      <div class="inner">
                        <h3>Ksh.{{ $totalUnpaidThisMonth }}</h3>

                        <p>Areas (This Month)</p>
                      </div>
                      <div class="icon">
                        <i class="ion ion-person-add"></i>
                      </div>

                    </div>
                  </div>


                <div class="data-card">
                    <div class="top-section">
                        <h3 class="data-title">Expenses</h3>
                        <p class="data-value"><i class="fas fa-dollar-sign"></i> 250,000</p>
                        <div class="data-chart">
                            <!-- Insert your chart or graph here -->
                        </div>
                    </div>
                    <div class="bottom-section">
                        <h4 class="section-title">Fixed Monthly Expenses</h4>
                        <ul class="product-list">
                            <li>Caretaker: Ksh.3000</li>
                            <li>Electricity:Ksh.4000</li>
                            <li>Security: </li>
                            <!-- Add more product listings as needed -->
                        </ul>
                    </div>
                </div>

                <a href="#" class="data-card-link"target="_blank">
                    <div class="data-card">
                        <h5 class="data-title">Total Paid This Month</h5>
                        <p class="data-value"><i class="fas fa-dollar-sign"></i> $250,000</p>
                        <div class="data-chart">
                            <!-- Insert your chart or graph here -->
                        </div>
                    </div>
                </a>

                <a href="#" class="data-card-link"target="_blank">
                    <div class="data-card">
                        <h5 class="data-title">Total Sales</h5>
                        <p class="data-value"><i class="fas fa-dollar-sign"></i> $250,000</p>
                        <div class="data-chart">
                            <!-- Insert your chart or graph here -->
                        </div>
                    </div>
                </a>

        </div>

                {{-- <div class="row">
                    <div class="container-fluid">
                        <div class="content-header row mb-2">
                            <div class="col-sm-6">
                                <h2>Your Assigned Apartments</h2>
                            <div class="designated-div">
                                    <div class="widget" id="draggable-widget">
                                        <div class="widget-header">
                                            <p class="widget-title">Recent Payments</p>
                                            <div>
                                                <span class="widget-action" id="minimize-widget">&#8211;</span>
                                                <span class="widget-action" id="refresh-widget">&#x21bb;</span>
                                                <span class="close-btn" onclick="closeWidget()">✕</span>
                                            </div>
                                        </div>
                                        <div class="widget-body">
                                            <div id="recent-payments-container">

                                            </div>
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>

                </div> --}}

                <div class="row">
                    <div class="container-fluid">

                                {{--  Display recent payments in a table --}}
                                <div class="row">
                                <h4>RECENT PAYMENTS</h4></div>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Invoice Number</th>
                                            <th>User Name</th>
                                            <th>Payment Date</th>
                                            <th>Amount Paid</th>
                                            <!-- Add more columns as needed -->
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($recentPayments as $invoice)
                                        <tr>
                                            <td>{{ $invoice->invoice_number }}</td>
                                            <td>{{ $invoice->user->name }}</td>


                                            @if(isset($invoice->payments) && is_iterable($invoice->payments))
                                                    @foreach ($invoice->payments as $payment)


                                                        <td>{{ $payment['payment_date'] }}</td>
                                                        <td>{{ $payment['payment_amount'] }}</td>
                                                        <!-- Add more columns as needed -->

                                                @endforeach
                                                @else
                                                No payments available
                                                @endif

                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                    </div>
                </div>
@endsection
{{-- <!-- JavaScript to handle modal -->
<script>
    const assignCaretakerBtn = document.getElementById('assignCaretakerBtn');
    const assignCaretakerModal = document.getElementById('assignCaretakerModal');

    assignCaretakerBtn.addEventListener('click', function(e) {
        e.preventDefault(); // Prevent the link from navigating

        if (assignCaretakerModal.style.display === 'none') {
            assignCaretakerModal.style.display = 'block';
        } else {
            assignCaretakerModal.style.display = 'none';
        }
    });
</script>
<!-- Add these scripts in your HTML -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
<script>
    let isMinimized = false;

    function refreshWidget() {
        // Add logic to refresh the widget content
        alert('Refreshing widget...');
    }

    function minimizeWidget() {
        const widget = document.querySelector('.widget-container');
        if (!isMinimized) {
            widget.style.height = '50px';
            isMinimized = true;
        } else {
            widget.style.height = '400px';
            isMinimized = false;
        }
    }

    function closeWidget() {
        const widget = document.querySelector('.widget-container');
        widget.style.display = 'none';
    }
    $(function() {
    // Mock JSON data
    var jsonData = '[{"payment_date": "2023-11-01", "payment_amount": "3000", "payment_method": "mpesa", "transaction_id": "kuguiuoih", "transaction_fee": "0"}, {"payment_date": "2023-10-15", "payment_amount": "2500", "payment_method": "credit card", "transaction_id": "abc123", "transaction_fee": "50"}]';

    // Parse JSON data
    var payments = JSON.parse(jsonData);

    // Display recent payments
    displayRecentPayments(payments);

    // Make the widget draggable
    $("#draggable-widget").draggable({
        handle: ".widget-header"
    });

    // Make the widget resizable
    $("#draggable-widget").resizable({
        handles: "se", // Resize handle on the bottom-right corner
        minWidth: 200,  // Set minimum width
        minHeight: 100  // Set minimum height
    });

    // Minimize action
    $("#minimize-widget").click(function() {
        $("#draggable-widget .widget-body").slideToggle();
    });

    // Refresh action
    $("#refresh-widget").click(function() {
        // Add logic to refresh the widget content
        console.log("Refresh clicked");
    });

    // Function to display recent payments in a table
function displayRecentPayments(payments) {
    var tableContainer = $("#recent-payments-container");
    tableContainer.empty(); // Clear previous content

    if (payments.length > 0) {
        // Create table
        var tableHtml = '<table class="payment-table">' +
                            '<thead>' +
                                '<tr>' +
                                    '<th>User</th>' +
                                    '<th>#Invoice</th>' +
                                    '<th>Amount</th>' +
                                    '<th>Payment Method</th>' +
                                    '<th>Date</th>' +
                                '</tr>' +
                            '</thead>' +
                            '<tbody>';

        for (var i = 0; i < payments.length; i++) {
            var payment = payments[i];
            var paymentDate = new Date(payment.payment_date).toLocaleDateString();
            var paymentAmount = parseFloat(payment.payment_amount).toFixed(2);
            var paymentMethod = payment.payment_method;
            var invoiceNumber= invoice.invoice_number;
            var userName = payment.user ? payment.user.name : 'N/A'; // Check if user exists

            // Add a row to the table
            tableHtml += '<tr>' +
                            '<td>' + userName + '</td>' +
                            '<td>' + invoiceNumber + '</td>' +
                            '<td>$' + paymentAmount + '</td>' +
                            '<td>' + paymentMethod + '</td>' +
                            '<td>' + paymentDate + '</td>' +
                         '</tr>';
        }

        // Close the table
        tableHtml += '</tbody></table>';

        tableContainer.append(tableHtml);
    } else {
        tableContainer.html('<p>No recent payments</p>');
    }
}

});

</script> --}}
