@extends('layouts.tenant-profile-layout')
@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            @include('partials._tenant_dropdown')
          </div>
          <div class="col-sm-3">

          </div>
          <div class="col-sm-3">
            {{-- <!-- Display user avatar -->
           <img class="rounded-circle fixed" width="150px"

            src="{{ asset('storage/' . $user->profile_picture) }}" alt="Tenant Avatar"><span class="text-black-50">{{$user->phone_number}}</span> --}}
          </div>
        </div>
      </div>
      <div id="tenantProfile-dashboard">
        {{-- {{ dd($tenant) }} --}}
        {{-- Inside your Blade view --}}
{{-- @dd($transactions) --}}
<!-- Show loading animation if isLoading is true -->
<div v-if="isLoading" class="loading-animation">
    <!-- Your loading animation HTML/CSS here -->
    <div class="spinner"></div>
    <p>Tenant Info Loading...</p>
</div>
<div v-else>
        <landlord-tenant-profile
            :apartment='@json($apartment)'
            :apartment-id='@json($apartmentId)'
            :active-tenant-id='@json($activeTenantId)'
            :apartments='@json($apartments)'
            :user='@json($user)'
            :users-in-apartment='@json($usersInApartment)'
            :total-users='@json($totalUsers)'
            :tenant='@json($tenant)'
            :tenant-invoices='@json($tenantInvoices)'
            :tenant-rooms='@json($tenantRooms)'
            :tenant-services='@json($tenantservices)'
            :transactions='@json($transactions)'
            :tenant-tickets='@json($tenantTickets)'
            :available-statuses='@json($availableStatuses)'
            :compounded-balance='@json($compoundedBalance)'
            :tenant-roles='@json($tenantRoles)'>
        </landlord-tenant-profile>
        {{-- <landlord-tenant-profile>:tenant-data="{{ json_encode($tenant) }}"></landlord-tenant-profile> --}}
    </div>
    </div>
    </div>
</div>
{{-- <script>
    document.addEventListener('DOMContentLoaded', function () {
      const app = new Vue({
        el: '#tenantProfile-dashboard',
      });
    });
  </script> --}}
<script>
    function changeTenant() {
    // Get the selected tenant ID
    var selectedTenantId = document.getElementById('tenantSelect').value;

    // Get the current apartment ID from the data attribute
    var currentApartmentId = document.querySelector('.form-group').getAttribute('data-apartment-id');

    // Redirect to the URL with the new tenant and current apartment IDs
    var newUrl = '/landlord/' + currentApartmentId + '/Tenant/' + selectedTenantId + '/users';
    window.location.href = newUrl;
}

</script>
@endsection
