@extends('layouts.apartment-layout')

@section('content')
<style>
    .card{padding: 1rem;
        background-color: rgb(250, 235, 235);
    }
    .card-sections{
    padding: 1rem;
        background-color: rgb(171, 213, 248);
    }
    .card-header{
        align-items: center;
    }
    .image-section {
        max-width: 100%; /* Maximum width of the image section */
        height: auto; /* Auto height to maintain aspect ratio */
    }

    .image-section img {
        max-width: 100%; /* Maximum width for images */
        height: 30rem; /* Auto height to maintain aspect ratio */
        display: block; /* Ensure images behave as block elements */
        margin: 0 auto; /* Center images horizontally */
    }
</style>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">


        </div>
    </div>

    <div class="row">

        <div class="container-fluid">
            <div class="col-md-12 mb-2 px-2 py-2">
                <div class="card-header">
                    <div class="row">
                    <div class="col-md-6 d-flex justify-content-right">
                        <h3> Room: {{  $room->id}} </h3>
                    </div>
                    <div class="co-md-4">
                        @include('partials._message_box')
                    </div>
                    <div class="col-md-6">
                        <h3> Room: {{  $room->id}} </h3>
                    </div>
                </div>

                </div>
            </div>
            <div class="container-fluid">
                <div class="row justify-content-left">
                    <div class="col-md-8">
                        <div class="card">
                            {{-- <images></images> --}}
                            <div class="card card-section">
                                <div class="card-header">
                                    <h5>Images</h5>
                                </div>
                                <div class="card-body">

                                    <div class="image-section">
                                    @if ($room->images && $room->images->isNotEmpty())
                                        <div id="imageCarousel{{ $room->id }}" class="carousel slide" data-ride="carousel">
                                            <div class="carousel-inner">
                                                @foreach ($room->images as $key => $image)
                                                <div class="carousel-item {{ $key === 0 ? 'active' : '' }}">
                                                    <img class="d-block w-100" src="{{ asset( $image->url) }}" alt="Room Image">


                                                        @if ($image->description)
                                                            <div class="carousel-caption d-none d-md-block">
                                                                <p>{{ $image->description }}</p>
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endforeach
                                            </div>
                                            <a class="carousel-control-prev" href="#imageCarousel{{ $room->id }}" role="button" data-slide="prev">
                                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                                <span class="sr-only">Previous</span>
                                            </a>
                                            <a class="carousel-control-next" href="#imageCarousel{{ $room->id }}" role="button" data-slide="next">
                                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                                <span class="sr-only">Next</span>
                                            </a>
                                        </div>
                                    @else
                                        <div class="alert alert-info" role="alert">
                                            No images available for this room.
                                        </div>
                                    @endif
                                    </div>




                                </div>
                                <div class="card-footer">
                                    <form action="{{ route('room.upload-image', ['room' => $room->id]) }}" method="post" enctype="multipart/form-data">
                                        @csrf
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" id="inputGroupFile04" aria-describedby="inputGroupFileAddon04" name="image">
                                                <label class="custom-file-label" for="inputGroupFile04">Choose file</label>
                                            </div>
                                            <div class="form-group">
                                                <label for="description">Description</label>
                                                <input type="text" class="form-control" id="description" name="description" placeholder="Enter image description" required>
                                            </div>
                                        </div>
                                            <div class="row">
                                            <div class="">
                                                <button class="btn btn-outline-secondary" type="submit" id="inputGroupFileAddon04">Upload</button>
                                            </div>
                                        </div>

                                    </form>
                                </div>
                            </div>


            {{-- Description --}}
            <div class="card card-sections">
                <div class="card-header">
                    <h5> Description </h5>
                </div>
                <div class="card-body">
                    <col-md-8>
                    {{$room->description}}

                    </div>
                    </col-md-8>
                </div>


            {{-- /Description --}}

            {{-- Features --}}
            <div class="card card-sections p-3">
                <div class="card-header">
                    <h5> Features </h5>
                </div>
                <div class="card-body">
                    <col-md-8>
                    {{$room->description}}

                    </div>
                    </col-md-8>
                </div>


            {{-- /Features --}}

            {{-- Short Video --}}
            <div class="card card-sections mb-2">
                <div class="card-header">
                    <h5> Short Video </h5>
                </div>
                <div class="card-body">
                    <col-md-8>
                    {{$room->description}}

                    </div>
                    </col-md-8>
                </div>


            {{-- /Short Video --}}


                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h5>{{__('Room Info')}}</h5>

                            </div>
                            <div class="card-body">

                                    <ul>
                                        <h4>Status: {{ $room->status }}</h4>
                                        <h6>Room Id: {{$room->id}}</h6>
                                        <h6>Electricity Meter No:</h6>
                                        <h6>Water Meter No:</h6>

                                        <h6>Room ID: {{ $room->id }}</h6>


                                        <h6>Type: {{ $room->room_size }}</h6>
                                        <h6>Price: {{ $room->price }}</h6>

                                    </ul>

                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                <h5>{{__('Tenant/Client Information')}}</h5>

                            </div>
                            <div class="card-body">

                                    <ul>
                                        <li>First Name:</li>
                                        <li>First Name:</li>
                                        <li>First Name:</li>
                                        <li>First Name:</li>
                                        <li>First Name:</li>
                                        <li>First Name:</li>

                                    </ul>

                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                <h5>{{__('Clients on Booking List with room order')}}</h5>

                            </div>
                            <div class="card-body">

                                    <ul>
                                        <li>First Name:</li>
                                        <li>First Name:</li>
                                        <li>First Name:</li>
                                        <li>First Name:</li>
                                        <li>First Name:</li>
                                        <li>First Name:</li>

                                    </ul>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

@endsection

