@extends('layouts.apartment-layout')
{{-- <link rel="stylesheet" href="{{ asset('css/invoices.css') }}"> --}}

@section('content')
 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrappers">
    <!-- Content Header (Page header) -->
        <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0"></h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
                <li class="breadcrumb-item active">This Month Reports</li>
                </ol>
            </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
        </div>
    <!-- /.content-header -->

<!-- Main content -->
<body>
  <!-- Search invoices -->

    <div class="container-fluid">
<div>
    @if(session('success'))
<div class="alert alert-success">
{{ session('success') }}
</div>
@endif

<div class="container">
    <h1>Report for {{ $thisMonthReport['month'] }}</h1>

    <table class="table">
        <thead>
            <tr>
                <th>Room Number</th>
                <th>Invoice Number</th>
                <th>Invoice Amount</th>
                <th>Payment Status</th>
                <th>Tenant Name</th>
                <th>Balance</th>
                <th>Amount Paid</th>
                <th>Compounded Balances</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($users as $user)
                @foreach ($userCompoundedBalances[$user->id] as $invoiceData)
                    @php
                        $invoice = $invoiceData['invoice'];
                        $compoundedBalance = $invoiceData['compounded_balance'];
                    @endphp
                    <tr style="{{ $invoice->payment_status === 'Paid' ? 'background-color: #82FF33;' : '' }}">
                        <td>{{ $invoice->room_id }}</td>
                        <td>{{ $invoice->invoice_number }}</td>
                        <td>${{ number_format($invoice->total_amount, 2) }}</td>
                        <td>{{ $invoice->payment_status }}</td>
                        <td>{{ $user->name }}</td>
                        <td>${{ number_format($invoice->balance, 2) }}</td>
                        <td>${{ number_format($invoice->amount_paid, 2) }}</td>
                        <td><strong>${{ number_format($compoundedBalance, 2) }}</strong></td>
                    </tr>
                @endforeach
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <th colspan="2">Total</th>
                <th>${{ number_format($totalInvoiceAmount, 2) }}</th>
                <th></th>
                <th></th>
                <th>${{ number_format($totalBalance, 2) }}</th>
                <th>${{ number_format($totalAmountPaid, 2) }}</th>
                <th>${{ number_format($totalAmountUnpaid, 2) }}</th>

            </tr>
        </tfoot>
    </table>

</div>
</div>
    </div>
</section>
</body>
 </div>



@endsection
