@extends('layouts.apartment-layout')

@section('content')
<div id="app">
    <invoices-section
        :tenant-invoices="{{ json_encode($tenantInvoices) }}"
        :apartment="{{ json_encode($apartment) }}"
        :user="{{ json_encode($user) }}"
        :compounded-balance="{{ $compoundedBalance }}"
        :routes="{{ json_encode([
            'invoices_edit' => route('invoices.edit', ['apartment' => $apartment->id, 'invoice' => '__invoiceId__'])
        ]) }}">
    </invoices-section>
</div>
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                    <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1 class="m-0">Invoice #{{$invoice->invoice_number}}</h1>
                                    @if (session('success'))
                                        <div class="alert alert-success">
                                            {{ session('success') }}
                                        </div>
                                    @endif
                                    @if ($errors->any())
                                        <div class="alert alert-danger">
                                            <ul>
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif

                        </div><!-- /.col -->
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Invoices</li>
                            </ol>
                        </div><!-- /.col -->
                        </div><!-- /.row -->
                        <div class="row">
                            This is a Draft Invoice. The client is not able to see or access this invoice until it is published.
                        </div>
                    </div><!-- /.container-fluid -->
                    </div>
                <!-- /.content-header -->
                <!-- invoice-header -->
                    <div class="container-fluid">
                                <!-- Button to open the Add Payment modal -->
                            <div class="outer-box-button">
                                @if (session('success'))
                                <div class="alert alert-success">
                                    {{ session('success') }}
                                </div>
                            @endif
                            @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif


                            </div>
                        <div class="outer-box">
                            <Button>Publish</Button>
                            <Button>Publish and Email</Button>
                        <div class="inner-box">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="col box">
                                        <!-- Left Item -->



                                            <div class="name-date-ox">
                                                <div class="form-group ">
                                                <span class="label">Client Name:</span>

                                                <span class="content"><a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment->id, 'usersInApartment' => $user->id]) }}">{{ $user->surname . $user->last_name }}</a> <a>(View Invoices)</a></span>
                                                </div>
                                                <!-- Add a line break to separate Name and Date -->
                                                <div class="form-group ">
                                                <span class="label "> Invoice Date:</span>
                                                <span class="content ">{{ $invoice->created_at}}</span>
                                                </div>
                                                <div class="form-group ">
                                                <span class="label "> Due Date:</span>
                                                <span class="content ">{{ $invoice->due_date}}</span>
                                                </div>
                                                <div class="form-group ">
                                                <span class="label ">Total Amount:</span>
                                                <span class="content ">{{$apartment->currency}} {{ number_format($invoice->total_amount,2) }}</span>
                                                </div>
                                                <div class="form-group ">
                                                <span class="label ">Amount Paid:</span>
                                                <span class="content ">{{$apartment->currency}} {{ number_format($invoice->amount_paid,2) }}</span>
                                                </div>
                                                <div class="form-group ">
                                                <span class="label ">Date:</span>
                                                <span class="content  ">September 15, 2023</span>
                                                </div>
                                                <div class="form-group ">
                                                <span class="label ">Balance:</span>
                                                <span class="content  ">{{$apartment->currency}} {{  $invoice->total_amount - $invoice->amount_paid}}</span>
                                                </div>




                                            </div>
                                        </div>
                                </div>
                                <div class="col-md-6">
                                    <!-- Right Item -->
                        <div class="col box">
                            <div class="item-box box">
                                <div class="name-date-box">
                                    <span class="label inline"></span>
                                    <span class="content inline text-uppercase {{ $invoice->status}}"><strong><h2>{{ $invoice->status}}</h2></span></strong>
                                    <span class="label inline">Payment Method:</span>
                                    <span class="center"> @include('partials._invoice_email_dropdown')</span>
                                    <!-- Add a line break to separate Name and Date -->
                                    <span class="label inline">Date:</span>
                                    <span class="content inline">{{ $invoice->updated_at}}</span><br>
                                    <span class="label inline">Payment Method:</span>
                                    <span class="content inline">{{ $invoice->payment_method}}</span><br>
                                    <!-- Buttons for marking invoices -->
                                    <form action="{{ route('invoice.markStatus', ['invoice' => $invoice->id]) }}" method="POST">
                                        @csrf

                                        <!-- Mark as Paid Button -->
                                        <button type="submit" name="status" value="paid" class="btn btn-success">Mark as Paid</button>

                                        <!-- Mark as Unpaid Button -->
                                        <button type="submit" name="status" value="unpaid" class="btn btn-warning">Mark as Unpaid</button>

                                        <!-- Cancel Invoice Button -->
                                        <button type="submit" name="status" value="canceled" class="btn btn-danger">Cancel Invoice</button>
                                        <button type="submit" name="status" value="Partial">Mark as Partial</button>
                                    </form>
                                </div>
                            </div>


                        </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



            <!--Invoice items-->
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <h2>Invoice Items</h2>

                        <form method="POST" action="{{ route('invoices.update', $invoice->id) }}">
                            @csrf
                            @method('PATCH')
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th style="width: 2rem;"><input type="checkbox" class="form-check-input invoiceCheckbox" data-invoice-id="{{ $invoice->id }}" data-invoice-id="{{ $invoice->id }}"></th>
                                        <th>Invoice Item</th>
                                        <th>Total Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $formattedItems = [];
                                        $decodedItems = json_decode($invoice->invoice_items, true);

                                        // Define the desired order of items
                                        $itemOrder = ['Apartment Name', 'Room Number', 'Month'];

                                        // Check if json_decode was successful and it's an array
                                        if (is_array($decodedItems)) {
                                            // Iterate through the desired order
                                            foreach ($itemOrder as $desiredItem) {
                                                // Check if the item exists in the decoded data
                                                $matchingItem = collect($decodedItems)->first(function ($item) use ($desiredItem) {
                                                    return is_array($item) && isset($item['item'], $item['value']) && $item['item'] === $desiredItem;
                                                });

                                                // If a matching item is found, add its value to the formatted items
                                                if ($matchingItem) {
                                                    switch ($desiredItem) {
                                                        case 'Room Number':
                                                            $formattedItems[] = 'Room Number: ' . $matchingItem['value'];
                                                            break;
                                                        default:
                                                            $formattedItems[] = $matchingItem['value'];
                                                    }
                                                }
                                            }
                                        }
                                    @endphp
                                    <tr>
                                        <td></td>
                                        <td>
                                            <div class="form-group">
                                                <textarea name="invoice_items" class="form-control" rows="2" cols="50">{{ implode(' - ', $formattedItems) }}</textarea>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="total_amount" class="form-control" value="{{ $invoice->total_amount }}" />
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Add a row with a blank textarea for adding another field data -->
                                    <tr>
                                        <td></td>
                                        <td>
                                            <div class="form-group">
                                                <textarea name="new_invoice_item" class="form-control" rows="2" cols="50"></textarea>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="new_total_amount" class="form-control" value="" />
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>



                                </table>
                                <button type="submit">Save Changes</button>
                                <button type="button" class="btn btn-secondary" id="cancelChanges">Cancel Changes</button>
                            </form>

                        @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>


            <!--/Invoice items--->
            <!-- Transactions items -->
<!-- Transactions items -->
<!-- Transactions items -->
<div class="container-fluid">
    <div class="row">
        <div class="col">
            <h2>Transactions</h2>

            @if (!empty($invoice->payments) && is_array(json_decode($invoice->payments, true)))
                <table class="table">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Payment Method</th>
                            <th>Transaction ID</th>
                            <th>Amount</th>
                            <th>Transaction Fee</th>
                            <th><input type="checkbox" id="selectAll" onchange="toggleCheckboxes()"></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach (json_decode($invoice->payments, true) as $transaction)
                        <tr>
                            <td>{{ $transaction['payment_date'] }}</td>
                            <td>{{ $transaction['payment_method'] }}</td>
                            <td>{{ $transaction['transaction_id'] }}</td>
                            <td>{{ $transaction['payment_amount'] }}</td>
                            <td>{{ $transaction['transaction_fee'] }}</td>
                            <td><input type="checkbox" class="transaction-checkbox" data-transaction-index="{{ $loop->index }}"></td>

                        </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p>No transactions available.</p>
            @endif
        </div>
    </div>
    <button onclick="performAction()">Perform Action on Selected Items</button>
    <button onclick="deleteSelected()">Delete Selected Items</button>
</div>


            <!--/Transaction items--->
    </div><!--/Content Wrapper--->



<!-- Add Payment Modal -->
<div class="modal fade" id="addPaymentModal" tabindex="-1" role="dialog" aria-labelledby="addPaymentModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addPaymentModalLabel">Add Payment</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div id="paymentResponseMessage"></div> <!-- Response message container -->
            <div class="modal-body">
                <form action="{{ route('invoice.addPayment', $invoice->id) }}" method="POST">
                    @csrf
                    <!-- Payment Date -->
                    <div class="form-group">
                        <label for="payment_date">Payment Date</label>
                        <input type="date" class="form-control" id="payment_date" name="payment_date">
                    </div>
                    <!-- Payment Method -->
                    <div class="form-group">
                        <label for="payment_method">Payment Method</label>
                        <input type="text" class="form-control" id="payment_method" name="payment_method">
                    </div>
                    <!-- Transaction ID -->
                    <div class="form-group">
                        <label for="transaction_id">Transaction ID</label>
                        <input type="text" class="form-control" id="transaction_id" name="transaction_id">
                    </div>
                    <!-- Amount -->
                    <div class="form-group">
                        <label for="amount">Amount</label>
                        <input type="text" class="form-control" id="payment_amount" name="payment_amount">
                    </div>
                    <!-- Transaction Fee -->
                    <div class="form-group">
                        <label for="transaction_fee">Transaction Fee</label>
                        <input type="text" class="form-control" id="transaction_fee" name="transaction_fee">
                    </div>
                    <button type="submit" class="btn btn-primary">Add Payment</button>
                </form>
            </div>
        </div>
    </div>
</div>





@endsection
