
@extends('layouts.apartment-settings-layout')
<!-- Include this style block in your blade/view file -->
@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="row ">
                <div class="col-md-4">
                    <h4>Services Settings</h4>
                </div>

                <div class="col-md-4">
                    <!-- Middle section left empty -->
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                </div>
                <div class="col-md-4">
                    <!-- Apartment Selection Dropdown -->
                </div>
            </div>
        </div>

        <div id="container">
            <div id="buttons" class="button-container">
                <button class="my-button" onclick="showGeneralSection()">General</button>
                <button class="my-button" onclick="showFixedSection()">Fixed</button>
                <button class="my-button" onclick="showVaryingSection()">Varying</button>
                <button class="my-button" onclick="showNotificationsSection()">Notifications</button>
                <!-- Add buttons for other sections -->
            </div>
 <!-- Display success message if any -->
 @if(session('success'))
 <div class="alert alert-success">
     {{ session('success') }}
 </div>
@endif
            <div class="outer-box">
                <div id="content">
                    <!-- Content will be dynamically populated here based on section clicks -->
                </div>
            </div>
        </div>


        <script>
            // Default section to show on page load
            showGeneralSection();

            function showGeneralSection() {
                document.getElementById("content").innerHTML = `
                <form method="post" action="{{ route('apartment.services-settings-update', $apartment->id) }}">
    @csrf
    @method('put')

    @foreach($allServices as $service)
        <label for="{{ $service->id }}-bandwidth">Bandwidth for {{ $service->name }}:</label>
        <input type="text" name="services[{{ $service->id }}][bandwidth]" value="{{ old('services.'.$service->id.'.bandwidth', $service->bandwidth) }}">

        <label for="{{ $service->id }}-billing_cycle">Billing Cycle for {{ $service->name }}:</label>
        <select name="services[{{ $service->id }}][billing_cycle]">
            <option value="monthly" {{ old('services.'.$service->id.'.billing_cycle', $service->billing_cycle) === 'monthly' ? 'selected' : '' }}>Monthly</option>
            <option value="quarterly" {{ old('services.'.$service->id.'.billing_cycle', $service->billing_cycle) === 'quarterly' ? 'selected' : '' }}>Quarterly</option>
            <option value="annually" {{ old('services.'.$$service->id.'.billing_cycle', $service->billing_cycle) === 'annually' ? 'selected' : '' }}>Annually</option>
        </select>
    @endforeach

    <button type="submit">Save</button>
</form>

                `;
            }

            function showFixedSection() {
                document.getElementById("content").innerHTML = `

                `;
            }

            function showVaryingSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">Varying Expenses Section</div>
                    <!-- Add content for Varying Expenses Section -->
                    <div id="save-success-message" style="display: none; color: green;">
                        Save successful!
                    </div>
                    <div id="buttons" class="centered">
                        <button onclick="saveChanges()">Save Changes</button>
                        <button onclick="cancelChanges()">Cancel Changes</button>
                    </div>
                `;
            }
            function showNotificationsSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">Expenses Notification </div>
                    <!-- Add content for Varying Expenses Section -->
                    <div id="save-success-message" style="display: none; color: green;">
                        Save successful!
                    </div>
                    <div id="buttons" class="centered">
                        <button onclick="saveChanges()">Save Changes</button>
                        <button onclick="cancelChanges()">Cancel Changes</button>
                    </div>
                `;
            }


            // Add similar functions for other sections


            function saveChanges() {
                // Logic to save changes
                // This is a placeholder, you'll need to implement your save logic using AJAX or form submission
                document.getElementById("save-success-message").style.display = "block";
            }

            function cancelChanges() {
                // Logic to cancel changes
                // This is a placeholder, you may want to reset the form or navigate away
                alert('Changes cancelled!');
            }
        </script>
</body>
    </div>
</html>

@endsection
