
@extends('layouts.apartment-settings-layout')
<!-- Include this style block in your blade/view file -->
@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="row ">
                <div class="col-md-4">
                    <h4>Payment Gateway Settings</h4>
                </div>

                <div class="col-md-4">
                    <!-- Middle section left empty -->
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                </div>
                <div class="col-md-4">
                    <!-- Apartment Selection Dropdown -->
                </div>
            </div>
        </div>

        <div id="container">
            <div id="buttons" class="button-container">
                <button class="my-button" onclick="showGeneralSection()">Featured</button>
                <button class="my-button" onclick="showFixedSection()">All Payment Gateways</button>
                <button class="my-button" onclick="showVaryingSection()">Active Gateways</button>

                <!-- Add buttons for other sections -->
            </div>
 <!-- Display success message if any -->
 @if(session('success'))
 <div class="alert alert-success">
     {{ session('success') }}
 </div>
@endif
            <div class="outer-box">
                <div id="content">
                    <!-- Content will be dynamically populated here based on section clicks -->
                </div>
            </div>
        </div>


        <script>
            // Default section to show on page load
            showGeneralSection();

            function showGeneralSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">General Section</div>
                    <div class="row">
    <label class="switch">
        Show Fixed Expenses:
        <input type="checkbox" id="showFixedExpenses" onchange="updateSettings('show_fixed_expenses')">
        <span class="slider"></span>
    </label>
</div>

<div class="row">
    <label class="switch">
        Show Varying Expenses:
        <input type="checkbox" id="showVaryingExpenses" onchange="updateSettings('show_varying_expenses')">
        <span class="slider"></span>
    </label>
</div>


                    <form id="general-form">
                        <div class="form-group">
                            <label for="name">Name:</label>
                            <input type="text" id="name" name="name" value="{{$apartment->name}}">
                        </div>

                        <div class="form-group">
                            <label for="location">Location:</label>
                            <input type="text" id="location" name="location" value="{{$apartment->location}}">
                        </div>

                        <div class="form-group">
                            <label for="capacity">Capacity:</label>
                            <input type="text" id="capacity" name="capacity" value="{{$apartment->capacity}}">
                        </div>
                        <!-- Add other form fields as needed -->
                    </form>
                    <div id="save-success-message" style="display: none; color: green;">
                        Save successful!
                    </div>
                    <div id="buttons" class="centered">
                        <button onclick="saveChanges()">Save Changes</button>
                        <button onclick="cancelChanges()">Cancel Changes</button>
                    </div>
                `;
            }

            function showFixedSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">Fixed Expenses</div>
                    <div class="container mt-4">
                    <form action="{{ route('apartment-expenses.store', $apartment->id) }}" method="post">

        @csrf



            <div class="form-row">
                <!-- Expense Type Field -->
                <div class="form-group col-md-6">
                    <label for="type">Expense Type:</label>
                    <select class="form-control" name="type" id="type" required>
                        <option value="fixed">Fixed Expense</option>
                        <option value="varying">Varying Expense</option>
                    </select>
                </div>

                <!-- Common Expense Fields -->
                <div class="form-group col-md-6">
                    <label for="amount">Amount:</label>
                    <input type="text" class="form-control" name="amount" id="amount" required>
                </div>

                <div class="form-group col-md-6">
                    <label for="description">Description:</label>
                    <input type="text" class="form-control" name="description" id="description" required>
                </div>

                <!-- Fixed Expense Fields -->
                <div id="fixedFields" class="form-group col-md-6">
                    <label for="frequency">Frequency:</label>
                    <select class="form-control" name="frequency" id="frequency">
                        <option value="monthly">Monthly</option>
                        <option value="yearly">Yearly</option>
                        <option value="daily">Daily</option>
                    </select>
                </div>

                <!-- Varying Expense Fields -->
                <div id="varyingFields" class="form-group col-md-6" style="display: none;">
                    <label for="expense_date">Expense Date:</label>
                    <input type="date" class="form-control" name="expense_date" id="expense_date">
                </div>

                <!-- Add Expense Button -->
                <div class="form-group col-md-12">
                    <button type="submit" class="btn btn-primary">Add Expense</button>
                </div>
            </div>
        </form>
    </div>
                    <div id="save-success-message" style="display: none; color: green;">
                        Save successful!
                    </div>
                    <div id="buttons" class="centered">
                        <button onclick="saveChanges()">Save Changes</button>
                        <button onclick="cancelChanges()">Cancel Changes</button>
                    </div>
                `;
            }

            function showVaryingSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">Varying Expenses Section</div>
                    <!-- Add content for Varying Expenses Section -->
                    <div id="save-success-message" style="display: none; color: green;">
                        Save successful!
                    </div>
                    <div id="buttons" class="centered">
                        <button onclick="saveChanges()">Save Changes</button>
                        <button onclick="cancelChanges()">Cancel Changes</button>
                    </div>
                `;
            }
            function showNotificationsSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">Expenses Notification </div>
                    <!-- Add content for Varying Expenses Section -->
                    <div id="save-success-message" style="display: none; color: green;">
                        Save successful!
                    </div>
                    <div id="buttons" class="centered">
                        <button onclick="saveChanges()">Save Changes</button>
                        <button onclick="cancelChanges()">Cancel Changes</button>
                    </div>
                `;
            }


            // Add similar functions for other sections


            function saveChanges() {
                // Logic to save changes
                // This is a placeholder, you'll need to implement your save logic using AJAX or form submission
                document.getElementById("save-success-message").style.display = "block";
            }

            function cancelChanges() {
                // Logic to cancel changes
                // This is a placeholder, you may want to reset the form or navigate away
                alert('Changes cancelled!');
            }
        </script>
</body>
    </div>
</html>

@endsection
