@extends('layouts.apartment-settings-layout')

@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="row ">
                <div class="col-md-4">
                    <h4>General Settings</h4>
                </div>

                <div class="col-md-4">
                    <!-- Middle section left empty -->
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                </div>
                <div class="col-md-4">
                    <!-- Apartment Selection Dropdown -->
                </div>
            </div>
        </div>

        <div id="container">
            <div id="buttons" class="button-container">
                <button class="my-button" onclick="showGeneralSection()">General</button>
                <button class="my-button" onclick="showDashboardSection()">Dashboard</button>
                <button class="my-button" onclick="showLocalisationSection()">Localisation</button>
                <button class="my-button" onclick="showOrderingSection()">Ordering</button>
                <button class="my-button" onclick="showEmailsSection()">Emails</button>
                <button class="my-button" onclick="showRoomsSection()">Rooms</button>
                <button class="my-button" onclick="showSupportSection()">Support</button>
                <button class="my-button" onclick="showInvoicesSection()">Invoices</button>
                <button class="my-button" onclick="showSMSSection()">SMS</button>
                <button class="my-button" onclick="showSecuritySection()">Security</button>
                <button class="my-button" onclick="showSocialSection()">Social</button>
                <!-- Add buttons for other sections -->
            </div>

            <div class="outer-box">
                <div id="content">
                    <!-- Notification container -->
                    <div id="notification" class="toast" role="alert" aria-live="assertive" aria-atomic="true" data-autohide="true" data-delay="5000">
                        <div class="toast-header">
                            <strong class="mr-auto">Notification</strong>
                            <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="toast-body" id="notification-message"></div>
                    </div>


                    <!-- Content will be dynamically populated here based on section clicks -->
                </div>

                <div id="save-success-message" style="display: none; color: green;">
                    Save successful!
                </div>

                {{-- <div id="buttons" class="centered">
                    <button onclick="saveChanges()">Save Changes</button>
                    <button onclick="cancelChanges()">Cancel Changes</button>
                </div> --}}
            </div>
        </div>


        <script>
            // Default section to show on page load
            showGeneralSection();

            function showGeneralSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">General Section</div>
                    <div class="container mt-5">
                            <form>
                                <div class="form-group">
                                    <label for="companyName">Company Name</label>
                                    <input type="text" class="form-control" id="companyName" value="Chuoni Technologies" readonly>
                                    <small class="form-text text-muted">Your Company Name as you want it to appear throughout the system</small>
                                </div>

                                <div class="form-group">
                                    <label for="email">Email Address</label>
                                    <input type="email" class="form-control" id="email" value="sales@chuoni.co.ke" readonly>
                                    <small class="form-text text-muted">The default sender address used for emails sent by WHMCS</small>
                                </div>

                                <div class="form-group">
                                    <label for="domain">Domain</label>
                                    <input type="url" class="form-control" id="domain" value="https://www.chuoni.co.ke/" readonly>
                                    <small class="form-text text-muted">The URL to your website homepage</small>
                                </div>

                                <div class="form-group">
                                    <label for="logo">Logo URL</label>
                                    <input type="url" class="form-control" id="logo" value="https://chuoni.co.ke/wp-content/uploads/2023/08/cropped-chuoni1-custom-logo2-1.png" readonly>
                                    <small class="form-text text-muted">Enter your logo URL to display in email messages or leave blank for none</small>
                                </div>

                                <!-- ... (other form fields) -->

                                <div class="form-group">
                                    <label for="maintenanceModeMessage">Maintenance Mode Message</label>
                                    <textarea class="form-control" id="maintenanceModeMessage" rows="4"></textarea>
                                    <small class="form-text text-muted">We are currently performing maintenance and will be back shortly.</small>
                                </div>

                                <div class="form-group">
                                    <label for="maintenanceModeRedirectUrl">Maintenance Mode Redirect URL</label>
                                    <input type="url" class="form-control" id="maintenanceModeRedirectUrl">
                                    <small class="form-text text-muted">If specified, redirects client area visitors to this URL when Maintenance Mode is enabled</small>
                                </div>

                                <button type="submit" class="btn btn-primary">Save Settings</button>
                            </form>
                        </div>

                                        <form id="general-form">
                                            <label for="name">Name:</label>
                                            <input type="text" id="name" name="name" value="{{$apartment->name}}">

                                            <label for="location">Location:</label>
                                            <input type="text" id="location" name="location" value="{{$apartment->location}}">

                                            <label for="capacity">Capacity:</label>
                                            <input type="text" id="capacity" name="capacity" value="{{$apartment->capacity}}">
                                            <!-- Add other form fields as needed -->

                                        </form>
                                    `;
            }
            function showDashboardSection() {
                document.getElementById("content").innerHTML = `
                <h2>Show/Hide Balances</h2>

<label>Show Monthly Paid Balance</label>
<input type="text" value="{{ $showMonthlyPaidBalance }}" readonly>
<button onclick="toggleSetting('{{ $apartment->id }}', 'general', 'dashboard', 'show_monthly_paid_balance')">Toggle</button>
<br>

<label>Show Monthly Unpaid Balance</label>
<input type="text" value="{{ $showMonthlyUnpaidBalance }}" readonly>
<button onclick="toggleSetting('{{ $apartment->id }}', 'general', 'dashboard', 'show_monthly_unpaid_balance')">Toggle</button>
<br>

                    <div class="section-title">General Section</div>
                    <div class="container mt-5">
                            <form>
                                <div class="form-group">
                                    <label for="companyName">Company Name</label>
                                    <input type="text" class="form-control" id="companyName" value="Chuoni Technologies" readonly>
                                    <small class="form-text text-muted">Your Company Name as you want it to appear throughout the system</small>
                                </div>

                                <div class="form-group">
                                    <label for="email">Email Address</label>
                                    <input type="email" class="form-control" id="email" value="sales@chuoni.co.ke" readonly>
                                    <small class="form-text text-muted">The default sender address used for emails sent by WHMCS</small>
                                </div>

                                <div class="form-group">
                                    <label for="domain">Domain</label>
                                    <input type="url" class="form-control" id="domain" value="https://www.chuoni.co.ke/" readonly>
                                    <small class="form-text text-muted">The URL to your website homepage</small>
                                </div>

                                <div class="form-group">
                                    <label for="logo">Logo URL</label>
                                    <input type="url" class="form-control" id="logo" value="https://chuoni.co.ke/wp-content/uploads/2023/08/cropped-chuoni1-custom-logo2-1.png" readonly>
                                    <small class="form-text text-muted">Enter your logo URL to display in email messages or leave blank for none</small>
                                </div>

                                <!-- ... (other form fields) -->

                                <div class="form-group">
                                    <label for="maintenanceModeMessage">Maintenance Mode Message</label>
                                    <textarea class="form-control" id="maintenanceModeMessage" rows="4"></textarea>
                                    <small class="form-text text-muted">We are currently performing maintenance and will be back shortly.</small>
                                </div>

                                <div class="form-group">
                                    <label for="maintenanceModeRedirectUrl">Maintenance Mode Redirect URL</label>
                                    <input type="url" class="form-control" id="maintenanceModeRedirectUrl">
                                    <small class="form-text text-muted">If specified, redirects client area visitors to this URL when Maintenance Mode is enabled</small>
                                </div>

                                <button type="submit" class="btn btn-primary">Save Settings</button>
                            </form>
                        </div>

                                        <form id="general-form">
                                            <label for="name">Name:</label>
                                            <input type="text" id="name" name="name" value="{{$apartment->name}}">

                                            <label for="location">Location:</label>
                                            <input type="text" id="location" name="location" value="{{$apartment->location}}">

                                            <label for="capacity">Capacity:</label>
                                            <input type="text" id="capacity" name="capacity" value="{{$apartment->capacity}}">
                                            <!-- Add other form fields as needed -->

                                        </form>
                                    `;
            }

            function showLocalisationSection() {
                document.getElementById("content").innerHTML = `
                <div class="container mt-5">
        <form>
            <div class="form-group">
                <label for="systemCharset">System Charset</label>
                <select class="form-control" id="systemCharset">
                    <option value="utf-8" selected>utf-8</option>
                    <!-- Add other charset options if needed -->
                </select>
                <small class="form-text text-muted">Default: utf-8</small>
            </div>

            <div class="form-group">
                <label for="globalDateFormat">Global Date Format</label>
                <select class="form-control" id="globalDateFormat">
                    <option value="DD/MM/YYYY" selected>DD/MM/YYYY</option>
                    <!-- Add other date format options if needed -->
                </select>
                <small class="form-text text-muted">Choose numeric display format</small>
            </div>

            <div class="form-group">
                <label for="clientDateFormat">Client Date Format</label>
                <select class="form-control" id="clientDateFormat">
                    <option value="Monday, January 1st, 2000" selected>Monday, January 1st, 2000</option>
                    <!-- Add other date format options if needed -->
                </select>
                <small class="form-text text-muted">Choose display style for clients (can be text-based)</small>
            </div>

            <div class="form-group">
                <label for="defaultCountry">Default Country</label>
                <select class="form-control" id="defaultCountry">
                    <option value="Kenya" selected>Kenya</option>
                    <!-- Add other country options if needed -->
                </select>
            </div>

            <div class="form-group">
                <label for="defaultLanguage">Default Language</label>
                <select class="form-control" id="defaultLanguage">
                    <option value="English" selected>English</option>
                    <!-- Add other language options if needed -->
                </select>
            </div>

            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="enableLanguageMenu">
                <label class="form-check-label" for="enableLanguageMenu">Enable Language Menu</label>
            </div>

            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="dynamicFieldTranslations">
                <label class="form-check-label" for="dynamicFieldTranslations">Dynamic Field Translations</label>
            </div>

            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="removeExtendedCharacters">
                <label class="form-check-label" for="removeExtendedCharacters">Remove Extended UTF-8 Characters</label>
            </div>

            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="enablePhoneNumbers">
                <label class="form-check-label" for="enablePhoneNumbers">Phone Numbers</label>
                <small class="form-text text-muted">Tick to enable international phone number input interface and automatic formatting</small>
            </div>

            <button type="submit" class="btn btn-primary">Save Settings</button>
        </form>
    </div>
                <div class="row">
                        <div class="col-6">
                            <div class="section-title">
                                Localisation Settings
                            </div>
                        </div>

                        <div class="col-6">
                            <div id="notification" class="toast" role="alert" aria-live="assertive" aria-atomic="true" data-autohide="true" data-delay="5000">
                                <div class="toast-header">
                                    <strong class="mr-auto">Notification</strong>
                                    <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="toast-body" id="notification-message"></div>
                            </div>
                        </div>
                </div>


                    <!-- Add content for Localisation Section -->
<div class="inner-box">
<form id="localisation-form">
    <div class="row mb-3">
        <label for="language" class="col-sm-2 col-form-label">Language:</label>
        <div class="col-sm-4">
            <select class="form-select" id="language" name="language">
                <!-- Add options dynamically from your database or a predefined list -->
                <option value="english">English</option>
                <option value="spanish">Spanish</option>
                <!-- Add more languages as needed -->
            </select>
        </div>
    </div>

    <div class="row mb-3">
        <label for="timezone" class="col-sm-2 col-form-label">Time Zone:</label>
        <div class="col-sm-4">
            <select class="form-select" id="timezone" name="timezone">
                <!-- Populate with all world time zones -->
                <?php
                $timezones = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
                foreach ($timezones as $timezone) {
                    echo "<option value=\"$timezone\">$timezone</option>";
                }
                ?>
            </select>
        </div>
    </div>

    <div class="row mb-3">
        <label for="currency" class="col-sm-2 col-form-label">Currency:</label>
        <div class="col-sm-4">
            <select class="form-select" id="currency" name="currency">
                <!-- Populate with all world currencies -->
                <?php
                $currencies = [
                    'USD' => 'US Dollar',
                    'EUR' => 'Euro',
                    'JPY' => 'Japanese Yen',
                    // Add more currencies as needed
                ];
                foreach ($currencies as $code => $name) {
                    echo "<option value=\"$code\">$code - $name</option>";
                }
                ?>
            </select>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-sm-2"></div> <!-- Empty column for spacing -->

    </div>
</form>
</div>
<div id="buttons" class="centered">
                    <button onclick="saveLocalisationSettings()">Save Changes</button>
                    <button onclick="cancelChanges()">Cancel Changes</button>
                </div>
                `;
            }

            function showOrderingSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">Ordering Section</div>
                    <!-- Add content for Ordering Section -->
                `;
            }

            // Add similar functions for other sections

            function showEmailsSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">Emails Settings</div>
                    <!-- Add content for Emails Section -->
                    <div class="container mt-5">
        <form>
            <!-- Dropdown for Mail Type -->
            <div class="form-group">
                <label for="mailType">Mail Type</label>
                <select class="form-control" id="mailType">
                    <option value="phpMail" selected>PHP Mail()</option>
                    <!-- Add other mail type options if needed -->
                </select>
            </div>

            <!-- Text input for Mail Encoding -->
            <div class="form-group">
                <label for="mailEncoding">Mail Encoding</label>
                <input type="text" class="form-control" id="mailEncoding" value="8bit">
            </div>

            <!-- Text input for SMTP Port -->
            <div class="form-group">
                <label for="smtpPort">SMTP Port</label>
                <input type="number" class="form-control" id="smtpPort" value="25">
                <small class="form-text text-muted">The port your mail server uses</small>
            </div>

            <!-- Text inputs for SMTP Host, Username, Password -->
            <div class="form-group">
                <label for="smtpHost">SMTP Host</label>
                <input type="text" class="form-control" id="smtpHost">
            </div>

            <div class="form-group">
                <label for="smtpUsername">SMTP Username</label>
                <input type="text" class="form-control" id="smtpUsername">
            </div>

            <div class="form-group">
                <label for="smtpPassword">SMTP Password</label>
                <input type="password" class="form-control" id="smtpPassword">
            </div>

            <!-- Dropdown for SMTP SSL Type -->
            <div class="form-group">
                <label for="smtpSslType">SMTP SSL Type</label>
                <select class="form-control" id="smtpSslType">
                    <option value="none" selected>None</option>
                    <option value="ssl">SSL</option>
                    <option value="tls">TLS</option>
                    <!-- Add other SSL type options if needed -->
                </select>
            </div>

            <!-- Textarea for Global Email Signature -->
            <div class="form-group">
                <label for="globalEmailSignature">Global Email Signature</label>
                <textarea class="form-control" id="globalEmailSignature" rows="4">---</textarea>
            </div>

            <!-- Textarea for Global Email CSS Styling -->
            <div class="form-group">
                <label for="globalEmailCssStyling">Global Email CSS Styling</label>
                <textarea class="form-control" id="globalEmailCssStyling" rows="10">
.ExternalClass,.ExternalClass div,.ExternalClass font,.ExternalClass p,.ExternalClass span,.ExternalClass td,h1,img{line-height:100%}h1,h2{display:block;font-family:Helvetica;font-style:normal;font-weight:700}#outlook a{padding:0}.ExternalClass,.ReadMsgBody{width:100%}a,blockquote,body,li,p,table,td{-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{mso-table-lspace:0;mso-table-rspace:0}img{-ms-interpolation-mode:bicubic;border:0;height:auto;outline:0;text-decoration:none}table{border-collapse:collapse!important}#bodyCell,#bodyTable,body{height:100%!important;margin:0;padding:0;width:100%!important}#bodyCell{padding:20px;}#templateContainer{width:600px;border:1px solid #ddd;background-color:#fff}#bodyTable,body{background-color:#FAFAFA}h1{color:#202020!important;font-size:26px;letter-spacing:normal;text-align:left;margin:0 0 10px}h2{color:#404040!important;font-size:20px;line-height:100%;letter-spacing:normal;text-align:left;margin:0 0 10px}h3,h4{display:block;font-style:italic;font-weight:400;letter-spacing:normal;text-align:left;margin:0 0 10px;font-family:Helvetica;line-height:100%}h3{color:#606060!important;font-size:16px}h4{color:grey!important;font-size:14px}.headerContent{background-color:#f8f8f8;border-bottom:1px solid #ddd;color:#505050;font-family:Helvetica;font-size:20px;font-weight:700;line-height:100%;text-align:left;vertical-align:middle;padding:0}.bodyContent,.footerContent{font-family:Helvetica;line-height:150%;text-align:left;}.footerContent{text-align:center}.bodyContent pre{padding:15px;background-color:#444;color:#f8f8f8;border:0}.bodyContent pre code{white-space:pre;word-break:normal;word-wrap:normal}.bodyContent table{margin:10px 0;background-color:#fff;border:1px solid #ddd}.bodyContent table th{padding:4px 10px;background-color:#f8f8f8;border:1px solid #ddd;font-weight:700;text-align:center}.bodyContent table td{padding:3px 8px;border:1px solid #ddd}.table-responsive{border:0}.bodyContent a{word-break:break-all}.headerContent a .yshortcuts,.headerContent a:link,.headerContent a:visited{color:#1f5d8c;font-weight:400;text-decoration:underline}#headerImage{height:auto;max-width:600px;padding:20px}#templateBody{background-color:#fff}.bodyContent{color:#505050;font-size:14px;padding:20px}.bodyContent a .yshortcuts,.bodyContent a:link,.bodyContent a:visited{color:#1f5d8c;font-weight:400;text-decoration:underline}.bodyContent a:hover{text-decoration:none}.bodyContent img{display:inline;height:auto;max-width:560px}.footerContent{color:grey;font-size:12px;padding:20px}.footerContent a .yshortcuts,.footerContent a span,.footerContent a:link,.footerContent a:visited{color:#606060;font-weight:400;text-decoration:underline}@media only screen and (max-width:640px){h1,h2,h3,h4{line-height:100%!important}#templateContainer{max-width:600px!important;width:100%!important}#templateContainer,body{width:100%!important}a,blockquote,body,li,p,table,td{-webkit-text-size-adjust:none!important}body{min-width:100%!important}#bodyCell{padding:10px!important}h1{font-size:24px!important}h2{font-size:20px!important}h3{font-size:18px!important}h4{font-size:16px!important}#templatePreheader{display:none!important}.headerContent{font-size:20px!important;line-height:125%!important}.footerContent{font-size:14px!important;line-height:115%!important}.footerContent a{display:block!important}.hide-mobile{display:none;}}
                </textarea>
            </div>

            <!-- Textarea for Client Email Header Content -->
            <div class="form-group">
                <label for="clientEmailHeaderContent">Client Email Header Content</label>
                <textarea class="form-control" id="clientEmailHeaderContent" rows="10">
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset={$charset}" />
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
        <style type="text/css">
            [EmailCSS]
        </style>
    </head>
    <body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0">
        <center>
            <table align="center" border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" id="bodyTable">
                <tr>
                    <td align="center" valign="top" id="bodyCell">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%" id="templateContainer">
                            <tr>
                                <td align="center" valign="top">
                                    <table border="0" cellpadding="0" cellspacing="0" width="100%" id="templateHeader">
                                        <tr>
                                            <td valign="top" class="headerContent">
                                                <a href="{$company_domain}">
                                                    <img src="{$company_logo_url}" style="max-width:600px;padding:20px 20px 0 20px" id="headerImage" alt="{$company_name}" />
                                                </a>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td align="center" valign="top">
                                    <table border="0" cellpadding="0" cellspacing="0" width="100%" id="templateBody">
                                        <tr>
                                            <td valign="top" class="bodyContent">
                                                Any text you enter here will be prefixed to the top of all client email templates sent out by the system. HTML is accepted.
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td align="center" valign="top">
                                    <table border="0" cellpadding="0" cellspacing="0" width="100%" id="templateFooter">
                                        <tr>
                                            <td valign="top" class="footerContent">
                                                <a href="{$company_domain}">visit our website</a>
                                                <span class="hide-mobile"> | </span>
                                                <a href="{$whmcs_url}">log in to your account</a>
                                                <span class="hide-mobile"> | </span>
                                                <a href="{$whmcs_url}submitticket.php">get support</a> <br />
                                                Copyright © {$company_name}, All rights reserved.
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </center>
    </body>
</html>
                </textarea>
            </div>

            <!-- Textarea for Client Email Footer Content -->
            <div class="form-group">
                <label for="clientEmailFooterContent">Client Email Footer Content</label>
                <textarea class="form-control" id="clientEmailFooterContent" rows="4">
Any text you enter here will be added to the bottom of all client email templates sent out by the system. HTML is accepted.
                </textarea>
            </div>

            <!-- Text input for System Emails From Name -->
            <div class="form-group">
                <label for="systemEmailsFromName">System Emails From Name</label>
                <input type="text" class="form-control" id="systemEmailsFromName" value="Chuoni Technologies">
            </div>

            <!-- Text input for System Emails From Email -->
            <div class="form-group">
                <label for="systemEmailsFromEmail">System Emails From Email</label>
                <input type="email" class="form-control" id="systemEmailsFromEmail" value="sales@chuoni.co.ke">
            </div>

            <!-- Text input for BCC Messages -->
            <div class="form-group">
                <label for="bccMessages">BCC Messages</label>
                <input type="text" class="form-control" id="bccMessages">
                <small class="form-text text-muted">If you want copies of all emails sent by the system sent to an address of yours enter the address here. You may enter multiple addresses separated by a comma (,)</small>
            </div>

            <!-- Radio buttons for Presales Form Destination -->
            <div class="form-group">
                <label>Presales Form Destination</label>
                <div class="form-check">
                    <input type="radio" class="form-check-input" id="presalesFormDept" name="presalesFormDestination" checked>
                    <label class="form-check-label" for="presalesFormDept">Choose a Department</label>
                </div>
                <div class="form-check">
                    <input type="radio" class="form-check-input" id="presalesFormEmail" name="presalesFormDestination">
                    <label class="form-check-label" for="presalesFormEmail">Send to email address below</label>
                </div>
            </div>

            <!-- Text input for Presales Contact Form Email -->
            <div class="form-group">
                <label for="presalesContactFormEmail">Presales Contact Form Email</label>
                <input type="email" class="form-control" id="presalesContactFormEmail">
            </div>

            <button type="submit" class="btn btn-primary">Save Settings</button>
        </form>
    </div>

                    <form action="/submit-email-settings" method="post">
        <label for="enableSmtp">Enable SMTP</label>
        <input type="checkbox" id="enableSmtp" name="enableSmtp">

        <label for="smtpHost">SMTP Host</label>
        <input type="text" id="smtpHost" name="smtpHost" placeholder="smtp.example.com">

        <label for="encryptionType">Type of Encryption</label>
        <select id="encryptionType" name="encryptionType">
            <option value="none">None</option>
            <option value="ssl">SSL</option>
            <option value="tls">TLS</option>
        </select>

        <label for="smtpPort">SMTP Port</label>
        <input type="text" id="smtpPort" name="smtpPort" placeholder="465">

        <label for="smtpAuthentication">SMTP Authentication</label>
        <input type="checkbox" id="smtpAuthentication" name="smtpAuthentication" checked>

        <label for="smtpUsername">SMTP Username</label>
        <input type="text" id="smtpUsername" name="smtpUsername" placeholder="Sitepad">

        <label for="smtpPassword">SMTP Password</label>
        <input type="password" id="smtpPassword" name="smtpPassword" placeholder="Enter your password">

        <label for="disableSslVerification">Disable SSL Certificate Verification</label>
        <input type="checkbox" id="disableSslVerification" name="disableSslVerification">

        <button type="submit">Save Settings</button>
    </form>
                `;
            }

            function showRoomsSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">Rooms Section</div>
                    <!-- Add content for Rooms Section -->
                `;
            }

            function showSupportSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">Support Section</div>
                    <!-- Add content for Support Section -->
                    <div class="container mt-5">
        <form>
            <!-- Dropdown for Support Module -->
            <div class="form-group">
                <label for="supportModule">Support Module</label>
                <select class="form-control" id="supportModule">
                    <option value="whmcsBuiltIn" selected>WHMCS Built-in System</option>
                    <!-- Add other support module options if needed -->
                </select>
            </div>

            <!-- Text input for Support Ticket Mask Format -->
            <div class="form-group">
                <label for="ticketMaskFormat">Support Ticket Mask Format</label>
                <input type="text" class="form-control" id="ticketMaskFormat" value="%n%n%n%n%n%n">
                <small class="form-text text-muted">Key: %A - Uppercase letter | %a - Lowercase letter | %n - Number | %y - Year | %m - Month | %d - Day | %i - Ticket ID</small>
            </div>

            <!-- Dropdown for Ticket Reply List Order -->
            <div class="form-group">
                <label for="replyListOrder">Ticket Reply List Order</label>
                <select class="form-control" id="replyListOrder">
                    <option value="ascending" selected>Ascending (Oldest to Newest)</option>
                    <!-- Add other order options if needed -->
                </select>
            </div>

            <!-- Text input for Ticket Reply Email Limit -->
            <div class="form-group">
                <label for="replyEmailLimit">Ticket Reply Email Limit</label>
                <input type="number" class="form-control" id="replyEmailLimit" value="10">
                <small class="form-text text-muted">Email sending limit per 15 minutes</small>
            </div>

            <!-- Checkbox for Show Client Only Departments -->
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="showClientDepartments">
                <label class="form-check-label" for="showClientDepartments">Tick to show client only departments to guests (not logged in visitors)</label>
            </div>

            <!-- Checkbox for Client Tickets Require Login -->
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="clientTicketsRequireLogin">
                <label class="form-check-label" for="clientTicketsRequireLogin">Require login by the owning client for viewing tickets assigned to a client</label>
            </div>

            <!-- Checkbox for Knowledgebase Suggestions -->
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="knowledgebaseSuggestions">
                <label class="form-check-label" for="knowledgebaseSuggestions">Show suggested KB articles to a user as they enter a support ticket message</label>
            </div>

            <!-- Checkbox for Attachment Thumbnail Previews -->
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="attachmentThumbnailPreviews">
                <label class="form-check-label" for="attachmentThumbnailPreviews">Tick to enable thumbnail previews of image attachments (requires GD)</label>
            </div>

            <!-- Checkbox for Support Ticket Rating -->
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="supportTicketRating">
                <label class="form-check-label" for="supportTicketRating">Allow users to rate support ticket replies from staff</label>
            </div>

            <!-- Checkbox for Auto Add Carbon Copy Recipients -->
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="autoAddCarbonCopy">
                <label class="form-check-label" for="autoAddCarbonCopy">Read and add carbon copy recipients from incoming emails for tickets opened via email</label>
            </div>

            <!-- Checkbox for Prevent Email Reopening -->
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="preventEmailReopening">
                <label class="form-check-label" for="preventEmailReopening">Tick to prevent email replies from re-opening closed tickets and to send an email advising to open a new ticket or update the existing ticket for clients</label>
            </div>

            <!-- Radio buttons for Update Last Reply Timestamp -->
            <div class="form-group">
                <label>Update Last Reply Timestamp</label>
                <div class="form-check">
                    <input type="radio" class="form-check-input" id="updateTimestampDefault" name="updateTimestamp" checked>
                    <label class="form-check-label" for="updateTimestampDefault">Every time a reply is made (Default)</label>
                </div>
                <div class="form-check">
                    <input type="radio" class="form-check-input" id="updateTimestampStaff" name="updateTimestamp">
                    <label class="form-check-label" for="updateTimestampStaff">Every time for staff replies, only on a change of status for clients</label>
                </div>
            </div>

            <!-- Checkbox for Disable Reply Email Logging -->
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="disableReplyEmailLogging">
                <label class="form-check-label" for="disableReplyEmailLogging">Do not create email log entry for ticket replies (text is already logged in the ticket so saves disk space)</label>
            </div>

            <!-- Text input for Allowed File Attachment Types -->
            <div class="form-group">
                <label for="allowedAttachmentTypes">Allowed File Attachment Types</label>
                <input type="text" class="form-control" id="allowedAttachmentTypes" value=".jpg,.gif,.jpeg,.png,.txt,.pdf">
                <small class="form-text text-muted">Separate multiple extensions with a comma</small>
            </div>

            <!-- Checkbox for Service Status Require Login -->
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="serviceStatusRequireLogin">
                <label class="form-check-label" for="serviceStatusRequireLogin">Require a login to view the server status & network issues pages</label>
            </div>

            <!-- Checkbox for Include Product Downloads -->
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="includeProductDownloads">
                <label class="form-check-label" for="includeProductDownloads">Tick to include Product Associated Downloads in the Downloads Directory</label>
            </div>

            <button type="submit" class="btn btn-primary">Save Settings</button>
        </form>
                `;
            }

            function showInvoicesSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">Invoices Section</div>
                    <!-- Add content for Invoices Section -->
                    <div class="container mt-5">
        <form>
            <!-- Checkbox for Continuous Invoice Generation -->
            <div class="form-group">
                <label for="continuousInvoiceGeneration">Continuous Invoice Generation</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="continuousInvoiceGeneration">
                    <label class="form-check-label" for="continuousInvoiceGeneration">If enabled, invoices will be generated for each cycle even if the previous invoice remains unpaid</label>
                </div>
            </div>

            <!-- Checkbox for Enable PDF Invoices -->
            <div class="form-group">
                <label for="enablePdfInvoices">Enable PDF Invoices</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="enablePdfInvoices">
                    <label class="form-check-label" for="enablePdfInvoices">Tick to send PDF versions of invoices along with invoice emails</label>
                </div>
            </div>

            <!-- Dropdown for PDF Paper Size -->
            <div class="form-group">
                <label for="pdfPaperSize">PDF Paper Size</label>
                <select class="form-control" id="pdfPaperSize">
                    <option value="A4" selected>A4</option>
                    <!-- Add other paper size options if needed -->
                </select>
            </div>

            <!-- Checkbox for PDF Font Family -->
            <div class="form-group">
                <label for="pdfFontFamily">PDF Font Family</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="pdfFontFamily">
                    <label class="form-check-label" for="pdfFontFamily">Courier Freesans Helvetica Times Dejavusans Custom</label>
                </div>
            </div>

            <!-- Checkbox for Store Client Data Snapshot -->
            <div class="form-group">
                <label for="storeClientDataSnapshot">Store Client Data Snapshot</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="storeClientDataSnapshot">
                    <label class="form-check-label" for="storeClientDataSnapshot">Preserve client details upon invoice generation to prevent profile changes for existing invoices</label>
                </div>
            </div>

            <!-- Checkbox for Enable Mass Payment -->
            <div class="form-group">
                <label for="enableMassPayment">Enable Mass Payment</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="enableMassPayment">
                    <label class="form-check-label" for="enableMassPayment">Tick to enable the multiple invoice payment options on the client area homepage</label>
                </div>
            </div>

            <!-- Checkbox for Clients Choose Gateway -->
            <div class="form-group">
                <label for="clientsChooseGateway">Clients Choose Gateway</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="clientsChooseGateway">
                    <label class="form-check-label" for="clientsChooseGateway">Tick to allow clients to choose the gateway they pay with</label>
                </div>
            </div>

            <!-- Checkbox for Group Similar Line Items -->
            <div class="form-group">
                <label for="groupSimilarLineItems">Group Similar Line Items</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="groupSimilarLineItems">
                    <label class="form-check-label" for="groupSimilarLineItems">Tick to enable automatically grouping identical line items into a quantity x description format</label>
                </div>
            </div>

            <!-- Checkbox for Cancellation Request Handling -->
            <div class="form-group">
                <label for="cancellationRequestHandling">Cancellation Request Handling</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="cancellationRequestHandling">
                    <label class="form-check-label" for="cancellationRequestHandling">Tick to automatically cancel outstanding unpaid invoices when a cancellation request is submitted</label>
                </div>
            </div>

            <!-- Checkbox for Automatic Subscription Management -->
            <div class="form-group">
                <label for="automaticSubscriptionManagement">Automatic Subscription Management</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="automaticSubscriptionManagement">
                    <label class="form-check-label" for="automaticSubscriptionManagement">Tick to auto-cancel existing subscription agreements (eg. PayPal Subscriptions) on Upgrade or Cancellation.</label>
                </div>
            </div>

            <!-- Checkbox for Enable Proforma Invoicing -->
            <div class="form-group">
                <label for="enableProformaInvoicing">Enable Proforma Invoicing</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="enableProformaInvoicing">
                    <label class="form-check-label" for="enableProformaInvoicing">Tick to enable proforma invoicing for unpaid invoices</label>
                </div>
            </div>

            <!-- Checkbox for Sequential Paid Invoice Numbering -->
            <div class="form-group">
                <label for="sequentialPaidInvoiceNumbering">Sequential Paid Invoice Numbering</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="sequentialPaidInvoiceNumbering">
                    <label class="form-check-label" for="sequentialPaidInvoiceNumbering">Tick this box to enable automatic sequential numbering of paid invoices</label>
                </div>
            </div>

            <!-- Text input for Sequential Invoice Number Format -->
            <div class="form-group">
                <label for="sequentialInvoiceNumberFormat">Sequential Invoice Number Format</label>
                <input type="text" class="form-control" id="sequentialInvoiceNumberFormat" value="{YEAR}{NUMBER}">
                <small class="form-text text-muted">Available auto-insert tags are: {YEAR} {MONTH} {DAY} {NUMBER}</small>
            </div>

            <!-- Text input for Next Paid Invoice Number -->
            <div class="form-group">
                <label for="nextPaidInvoiceNumber">Next Paid Invoice Number</label>
                <input type="number" class="form-control" id="nextPaidInvoiceNumber" value="10081">
            </div>

            <!-- Dropdown for Late Fee Type -->
            <div class="form-group">
                <label for="lateFeeType">Late Fee Type</label>
                <select class="form-control" id="lateFeeType">
                    <option value="percentage" selected>Percentage</option>
                    <option value="fixedAmount">Fixed Amount</option>
                </select>
            </div>

            <!-- Text input for Late Fee Amount -->
            <div class="form-group">
                <label for="lateFeeAmount">Late Fee Amount</label>
                <input type="number" step="0.01" class="form-control" id="lateFeeAmount" value="0.00">
                <small class="form-text text-muted">Enter the amount (percentage or monetary value) to apply to late invoices (set to 0 to disable)</small>
            </div>

            <!-- Text input for Late Fee Minimum -->
            <div class="form-group">
                <label for="lateFeeMinimum">Late Fee Minimum</label>
                <input type="number" step="0.01" class="form-control" id="lateFeeMinimum" value="0.00">
                <small class="form-text text-muted">Enter the minimum amount to charge in cases where the calculated late fee falls below this figure</small>
            </div>

            <!-- Checkbox for Accepted Credit Card Types -->
            <div class="form-group">
                <label for="acceptedCreditCardTypes">Accepted Credit Card Types</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="acceptedCreditCardTypes">
                    <label class="form-check-label" for="acceptedCreditCardTypes">VisaMasterCardDiscoverAmerican ExpressJCBDiners ClubMaestroDankortForbrugsforeningenUnionPay
                        Use Ctrl+Click to select Multiple Card Types</label>
                </div>
            </div>

            <!-- Checkbox for Issue Number/Start Date -->
            <div class="form-group">
                <label for="issueNumberStartDate">Issue Number/Start Date</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="issueNumberStartDate">
                    <label class="form-check-label" for="issueNumberStartDate">Tick to show these fields for credit card payments</label>
                </div>
            </div>

            <!-- Text input for Invoice # Incrementation -->
            <div class="form-group">
                <label for="invoiceIncrementation">Invoice # Incrementation</label>
                <input type="number" class="form-control" id="invoiceIncrementation" value="1">
                <small class="form-text text-muted">Enter the difference you want between invoice numbers generated by the system (Default: 1)</small>
            </div>

            <!-- Text input for Invoice Starting # -->
            <div class="form-group">
                <label for="invoiceStartingNumber">Invoice Starting #</label>
                <input type="number" class="form-control" id="invoiceStartingNumber">
                <small class="form-text text-muted">Enter to set the next invoice number, must be greater than last #31724 (Blank for no change)</small>
            </div>

            <button type="submit" class="btn btn-primary">Save Settings</button>
        </form>
    </div>
                `;
            }

            function showSMSSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">SMS Section</div>
                    <!-- Add content for SMS Section -->
                `;
            }

            function showSecuritySection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">Security Section</div>
                    <!-- Add content for Security Section -->
                    <div class="container mt-5">
        <form>
            <!-- Checkbox for Email Verification -->
            <div class="form-group">
                <label for="emailVerification">Email Verification</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="emailVerification">
                    <label class="form-check-label" for="emailVerification">Request users to confirm their email address on signup or change of email address</label>
                </div>
            </div>

            <!-- Dropdown for Captcha Form Protection -->
            <div class="form-group">
                <label for="captchaProtection">Captcha Form Protection</label>
                <select class="form-control" id="captchaProtection">
                    <option value="alwaysOn" selected>Always On (code shown to ensure human submission)</option>
                    <option value="offWhenLoggedIn">Off when logged in</option>
                    <option value="alwaysOff">Always Off</option>
                </select>
            </div>

            <!-- Dropdown for Captcha Type -->
            <div class="form-group">
                <label for="captchaType">Captcha Type</label>
                <select class="form-control" id="captchaType">
                    <option value="default" selected>Default (5 Character Verification Code)</option>
                    <option value="recaptchaV2">reCAPTCHA v2 (Google's reCAPTCHA system)</option>
                    <option value="invisibleRecaptcha">Invisible reCAPTCHA</option>
                </select>
            </div>

            <!-- Checkbox for Captcha on Select Forms -->
            <div class="form-group">
                <label for="captchaForForms">Captcha for Select Forms</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="captchaForForms">
                    <label class="form-check-label" for="captchaForForms">Shopping Cart Checkout, Domain Checker, Client Registration, Contact Form, Ticket Submission, Login Forms</label>
                </div>
            </div>

            <!-- Text input for reCAPTCHA Site Key -->
            <div class="form-group">
                <label for="recaptchaSiteKey">reCAPTCHA Site Key</label>
                <input type="text" class="form-control" id="recaptchaSiteKey">
                <small class="form-text text-muted">You need to register for reCAPTCHA @ https://www.google.com/recaptcha/admin</small>
            </div>

            <!-- Text input for reCAPTCHA Secret Key -->
            <div class="form-group">
                <label for="recaptchaSecretKey">reCAPTCHA Secret Key</label>
                <input type="text" class="form-control" id="recaptchaSecretKey">
            </div>

            <!-- Dropdown for Auto Generated Password Format -->
            <div class="form-group">
                <label for="passwordFormat">Auto Generated Password Format</label>
                <select class="form-control" id="passwordFormat">
                    <option value="default" selected>Generate passwords containing a combination of letters, numbers and special characters (Default)</option>
                    <option value="lettersAndNumbers">Generate passwords containing a combination of letters and numbers only</option>
                </select>
            </div>

            <!-- Text input for Minimum User Password Strength -->
            <div class="form-group">
                <label for="minPasswordStrength">Minimum User Password Strength</label>
                <input type="number" class="form-control" id="minPasswordStrength" value="5">
                <small class="form-text text-muted">Enter a value between 1 and 100, or 0 to disable</small>
            </div>

            <!-- Text input for Failed Admin Login Ban Time -->
            <div class="form-group">
                <label for="adminLoginBanTime">Failed Admin Login Ban Time</label>
                <input type="number" class="form-control" id="adminLoginBanTime" value="15">
                <small class="form-text text-muted">Enter the time to ban an IP in minutes after 3 failed login attempts - Enter 0 to Disable</small>
            </div>

            <!-- Text input for Whitelisted IPs -->
            <div class="form-group">
                <label for="whitelistedIPs">Whitelisted IPs</label>
                <input type="text" class="form-control" id="whitelistedIPs" placeholder="Add IP">
                <small class="form-text text-muted">IP Addresses exempt from being banned for invalid login attempts</small>
                <!-- Add functionality for adding/removing IPs if needed -->
            </div>

            <!-- Checkbox for Whitelisted IP Login Failure Notices -->
            <div class="form-group">
                <label for="whitelistedIPNotices">Whitelisted IP Login Failure Notices</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="whitelistedIPNotices">
                    <label class="form-check-label" for="whitelistedIPNotices">Tick to send login failure notices for Whitelisted IP addresses</label>
                </div>
            </div>

            <!-- Checkbox for Disable Admin Password Reset -->
            <div class="form-group">
                <label for="disableAdminPasswordReset">Disable Admin Password Reset</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="disableAdminPasswordReset">
                    <label class="form-check-label" for="disableAdminPasswordReset">Tick this box to disable the forgotten password feature on the admin login page</label>
                </div>
            </div>

            <!-- Checkbox for Delete Encrypted Credit Card Data -->
            <div class="form-group">
                <label for="deleteCreditCardData">Delete Encrypted Credit Card Data</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="deleteCreditCardData">
                    <label class="form-check-label" for="deleteCreditCardData">Allow Client CC Removal - Tick this box to allow customers to delete the credit card details stored on their account</label>
                </div>
            </div>

            <!-- Checkbox for Disable Session IP Check -->
            <div class="form-group">
                <label for="disableSessionIPCheck">Disable Session IP Check</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="disableSessionIPCheck">
                    <label class="form-check-label" for="disableSessionIPCheck">This is used to protect against cookie/session hijacking but can cause problems for users with dynamic IPs</label>
                </div>
            </div>

            <!-- Checkbox for Allow Smarty PHP Tags -->
            <div class="form-group">
                <label for="allowSmartyPHPTags">Allow Smarty PHP Tags</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="allowSmartyPHPTags">
                    <label class="form-check-label" for="allowSmartyPHPTags">Tick to allow use of the Smarty {php} tag in templates. This is considered a security risk.</label>
                </div>
            </div>

            <!-- Checkbox for Enabled CSRF Tokens: General -->
            <div class="form-group">
                <label for="csrfTokensGeneral">CSRF Tokens: General</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="csrfTokensGeneral">
                    <label class="form-check-label" for="csrfTokensGeneral">Tick to enable general use of CSRF tokens for all public and clientarea forms (Highly Recommended)</label>
                </div>
            </div>

            <!-- Checkbox for Enabled CSRF Tokens: Domain Checker -->
            <div class="form-group">
                <label for="csrfTokensDomainChecker">CSRF Tokens: Domain Checker</label>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="csrfTokensDomainChecker">
                    <label class="form-check-label" for="csrfTokensDomainChecker">Tick to enable use of CSRF tokens for the Domain Checker form</label>
                </div>
            </div>

            <button type="submit" class="btn btn-primary">Save Settings</button>
        </form>
    </div>
                `;
            }

            function showSocialSection() {
                document.getElementById("content").innerHTML = `
                    <div class="section-title">Social Section</div>
                    <!-- Add content for Social Section -->
                `;
            }




            function saveChanges() {
                // Logic to save changes
                // This is a placeholder, you'll need to implement your save logic using AJAX or form submission
                document.getElementById("save-success-message").style.display = "block";
            }

            function cancelChanges() {
                // Logic to cancel changes
                // This is a placeholder, you may want to reset the form or navigate away
                alert('Changes cancelled!');
            }
            function showNotification(message, isError = false) {
    // Wait for the document to be ready before executing the code
    $(document).ready(function () {
        // Get the notification element
        var notification = $('#notification');
        var notificationMessage = $('#notification-message');

        // Check if the elements are found
        console.log(notification, notificationMessage);

        // Check if both elements are found before proceeding
        if (notification.length > 0 && notificationMessage.length > 0) {
            // Set the message and style based on the error status
            notification.removeClass('bg-success bg-danger');
            if (isError) {
                notification.addClass('bg-danger');
            } else {
                notification.addClass('bg-success');
            }

            // Set the message content
            notificationMessage.text(message);

            // Show the notification
            var toast = new bootstrap.Toast(notification[0]);
            toast.show();
        } else {
            console.error("Notification elements not found.");
        }
    });
}

            //localization Section
            function saveLocalisationSettings() {
        var language = document.getElementById("language").value;
        var timezone = document.getElementById("timezone").value;
        var currency = document.getElementById("currency").value;

        // Perform AJAX request to save data to the server

        jQuery.ajax({
            type: "POST",
            url: "{{ route('save-localisation-settings', ['apartmentId' => $apartment->id]) }}",

            data: {
                _token: '{{ csrf_token() }}', // CSRF token for Laravel security
                language: language,
                timezone: timezone,
                currency: currency,
                // Add more data if needed
            },
            success: function (response) {
                // Handle success response
                showNotification('Settings saved successfully');
                console.log("Settings saved successfully");

            },
            error: function (error) {
                // Handle error response
                console.error("Error saving settings:", error);
                showNotification('Error saving settings', true);
            }
        });
    }
        </script>
</body>
    </div>
</html>

@endsection
