@extends('layouts.apartment-layout')

@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="row ">
                <div class="col-md-4">
                    <h4>RECENT PAYMENTS</h4>
                </div>

                <div class="col-md-4">
                    @include('partials._message_box')
                </div>
                <div class="col-md-4">

                    <!-- Apartment Selection Dropdown -->
                    @include('partials._apartment_dropdown')
                </div>

            </div>
        </div>


        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-12 col-md-10 col-lg-8">
                    <div class="card p-3 mb-3">
                        <div class="card-header">
                            <h4>Recent Payments</h4>
                        </div>
                        @include('partials._apartment_recent_payments')
                    </div>
                </div>
            </div>
        </div>


            <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-12 col-md-10 col-lg-8">
                    <div class="card p-3 mb-3">
                        <div class="card-header">
                            <h4>Manage Payments</h4>
                        </div>
                        @include('partials._apartment_all_payments')
                    </div>
                </div>
            </div>
            </div>

            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-12 col-md-10 col-lg-8">
                        <div class="card p-3 mb-3">
                            <div class="card-header">
                                <h4>Recent Payments</h4>
                            </div>

                            <table class="table table-responsive">
                                <thead>
                                    <tr>
                                        <th>Invoice Number</th>
                                        <th>User Name</th>
                                        <th>Payment Date</th>
                                        <th>Amount Paid</th>
                                        <!-- Add more columns as needed -->
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($apartmentRecentPayments as $invoice)
                                        <tr>
                                            <td>{{ $invoice->invoice_number }}</td>
                                            <td>{{ $invoice->user->name }}</td>


                                            @if (isset($invoice->payments) && is_iterable($invoice->payments))
                                                @foreach ($invoice->payments as $payment)
                                                    <td>{{ $payment['payment_date'] }}</td>
                                                    <td>{{ $payment['payment_amount'] }}</td>
                                                    <!-- Add more columns as needed -->
                                                @endforeach
                                            @else
                                                No payments available
                                            @endif

                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
