@extends('layouts.apartment-layout')

@section('content')
<!-- Add jQuery library -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

<style>
    .widget-row {
        display: flex;
        flex-wrap: wrap;
    }

    .col-md-4 {
        flex: 0 0 33.33%;
        max-width: 33.33%;
    }

    .widget {
        border: 1px solid #ccc;
        margin: 10px;
        overflow: hidden;
        width: 100%;
        box-sizing: border-box;
        position: relative;
    }

    .widget-header {
        background-color: #f4f4f4;
        padding: 5px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        cursor: move;
        border-bottom: 1px solid #ccc;
    }

    .widget-icons {
        display: flex;
        gap: 5px;
    }

    .widget-icons i {
        padding: 5px;
        cursor: pointer;
        border-radius: 3px;
    }

    .widget-icons i:hover {
        background-color: #ddd;
    }

    .resize-handle {
        width: 10px;
        height: 100%;
        position: absolute;
        right: 0;
        top: 0;
        cursor: ew-resize;
    }

    .widget-content {
        padding: 10px;
        max-height: 300px;
        overflow-y: auto;
    }

    .expense-buttons {
        display: flex;
        align-items: center;
    }

    .expense-buttons button {
        flex: 1;
        padding: 10px;
    }

    .separator {
        border-right: 1px solid #ccc;
        height: 20px;
        margin: 0 10px;
    }

    .red-row {
        background-color: #ffcccc;
        /* Light red */
    }

    .green-row {
        background-color: #ccffcc;
        /* Light green */
    }

    .thumbs-up {
        color: green;
    }

    .thumbs-down {
        color: red;
    }
</style>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="row ">
            <div class="col-md-4">

                <!-- Apartment Selection Dropdown -->
                @include('partials._apartment_dropdown')
            </div>

            <div class="col-md-4">
                <!-- Middle section left empty -->
                @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
                @endif
            </div>

            <div class="col-md-4">
                <h6>CARETAKER</h6>
                <ul>
                    @foreach ($caretakers as $caretaker)
                    <li>{{ $caretaker->name }} - ({{ $caretaker->phone_number }})</li>
                    @endforeach
                </ul>

            </div>



            {{-- <div id="assignCaretakerModal" style="display: none;">
                <form action="{{ route('assignCaretaker', ['apartment' => $apartment]) }}" method="post">
                    @csrf
                    <label for="user_id">Select Caretaker:</label>
                    <select name="user_id" id="user_id">
                        @foreach($usersInApartmentWithCaretakerRole as $user)
                        <option value="{{ $user->id }}">{{ $user->name }}</option>
                        @endforeach
                    </select>
                    <button type="submit" class="btn btn-primary">Assign Caretaker Role</button>
                </form>
            </div> --}}




        </div>
    </div>







    <div class="container-fluid">
        <div class="row">


            <div class="col-lg-3 col-6">
                <!-- small box -->
                <a href="{{ route('landlord.manage.rooms', $apartment->id)}}"
                    style="text-decoration: none; color: inherit;">
                    <div class="small-box bg-blue">
                        <div class="inner">
                            <p>TOTAL ROOMS</p>
                            <h4 class="center bold">{{ $apartment->rooms->count() }}</h4>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                    </div>
                </a>
            </div>

            <!--/Total user -->

            <!--Total user -->

            <div class="col-lg-3 col-6">
                <!-- small box -->
                <a href="{{ route('landlord.manage.users', $apartment->id)}}"
                    style="text-decoration: none; color: inherit;">
                    <div class="small-box bg-yellow">
                        <div class="inner">
                            <p>TOTAL USERS</p>
                            <h4 class="center">{{ $totalUsersCount }}</h4>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                    </div>
                </a>
            </div>

            <!--/Total user -->

            {{-- <a href="{{ route('landlord.manage.users', $apartment->id) }}" class="data-card-link" target="_blank">
                <div class="data-card">
                    <h5 class="data-title">Total Users</h5>
                    <p class="data-value"><i class="fas fa-dollar-sign"></i>{{ $totalUsersCount}}</p>
                    <div class="data-chart">
                        <!-- Insert your chart or graph here -->
                    </div>
                </div>
            </a> --}}

            <div class="col-lg-3 col-6">
                <!-- small box -->

                <div class="small-box bg-success">
                    <div class="inner">
                        <a href="{{ route('landlord.apartment-this-month-invoices', $apartment->id)}}"
                            style="text-decoration: none; color: inherit;">
                            <div id="amountpaidthismonth" style="display:none">
                                <h3>{{$apartment->currency}}

                                    {{ number_format($totalPaidThisMonth, 2)}}<sup style="font-size: 20px">{{
                                        $percentagePaid}}</sup>
                        </a>
                    </div>
                    </h3>

                    <p>Amount Paid (This Month) <i class="fas fa-eye eye-icon-paid"></i></p>
                </div>
                <div class="icon">
                    <i class="ion ion-stats-bars"></i>
                </div>
                {{--
                <script>
                    $(document).ready(function () {
                        // Toggle visibility of the amount paid this month on eye icon click
                        $(".eye-icon-paid").click(function () {
                            $("#amountpaidthismonth").toggle();
                        });

                        // Show/hide share script on hover
                        $(".eye-icon-paid").hover(function () {
                            // Add your share script logic here for the first eye icon
                        }, function () {
                            // Add your hide script logic here for the first eye icon
                        });

                        // Toggle visibility of the amount unpaid this month on eye icon click
                        $(".eye-icon-unpaid").click(function () {
                            $("#amountunpaidthismonth").toggle();
                        });

                        // Show/hide share script on hover
                        $(".eye-icon-unpaid").hover(function () {
                            // Add your share script logic here for the second eye icon
                        }, function () {
                            // Add your hide script logic here for the second eye icon
                        });
                    });
                </script> --}}

                <script>
                    $(document).ready(function () {
                        // Assume these variables are set based on your settings page
                        var showPaidBalanceSetting = true;  // Change this based on your setting
                        var showUnpaidBalanceSetting = true;  // Change this based on your setting

                        // Toggle visibility of the amount paid this month on eye icon click
                        $(".eye-icon-paid").click(function () {
                            if (showPaidBalanceSetting) {
                                $("#amountpaidthismonth").toggle();
                            }
                        });

                        // Show/hide share script on hover
                        $(".eye-icon-paid").hover(function () {
                            if (showPaidBalanceSetting) {
                                // Add your share script logic here for the first eye icon
                            }
                        }, function () {
                            if (showPaidBalanceSetting) {
                                // Add your hide script logic here for the first eye icon
                            }
                        });

                        // Toggle visibility of the amount unpaid this month on eye icon click
                        $(".eye-icon-unpaid").click(function () {
                            if (showUnpaidBalanceSetting) {
                                $("#amountunpaidthismonth").toggle();
                            }
                        });

                        // Show/hide share script on hover
                        $(".eye-icon-unpaid").hover(function () {
                            if (showUnpaidBalanceSetting) {
                                // Add your share script logic here for the second eye icon
                            }
                        }, function () {
                            if (showUnpaidBalanceSetting) {
                                // Add your hide script logic here for the second eye icon
                            }
                        });
                    });
                </script>


            </div>

        </div>
        <!-- ./col -->
        <div class="col-lg-3 col-6">
            <!-- small box -->

            <div class="small-box bg-danger">
                <div class="inner">
                    <a href="{{ route('landlord.apartment-this-month-invoices', $apartment->id)}}"
                        style="text-decoration: none; color: inherit;">
                        <div id="amountunpaidthismonth" style="display:none">
                            <h3>{{$apartment->currency}}{{ number_format($totalUnpaidThisMonth,2) }}
                        </div>
                        </h3>
                    </a>

                    <p>Areas (This Month) <i class="fas fa-eye eye-icon-unpaid"></i></p>
                </div>
                <div class="icon">
                    <i class="ion ion-person-add"></i>
                </div>

            </div>
            </a>
        </div>


        {{--
        <div class="draggable-box" id="widget2">
            <div class="box-header" onmousedown="startDrag(event, this)">
                <span>Widget 2</span>
                <div>
                    <button onclick="minimizeBox(this)">-</button>
                    <button onclick="refreshBox(this)">↻</button>
                    <button onclick="cancelBox(this)">✖</button>
                </div>
            </div>
            <div class="box-content">
                <p>This is the content of Widget 2.</p>
            </div>
        </div>
    </div> --}}
    {{-- Expenses --}}
    <div class="col-md-4">
        <div class="widget">
            <div class="widget-header">
                <div class="widget-title">Expenses</div>
                <div class="widget-icons">
                    <i class="fas fa-window-minimize minimize-icon" onclick="minimizeWidget()"></i>
                    <i class="fas fa-sync refresh-icon" onclick="refreshBox(this)"></i>
                    <i class="fas fa-times cancel-icon" onclick="cancelWidget()"></i>
                </div>
            </div>
            <div class="resize-handle" onmousedown="startResizing()"></div>
            <div class="widget-content" id="widget-content">
                <!-- Adjusted structure with horizontal buttons and initially hidden sections -->
                <div class="expense-buttons">
                    <button onclick="showSection('fixed-expenses')">Fixed Expenses</button>
                    <div class="separator"></div>
                    <button onclick="showSection('varying-expenses')">Varying Expenses</button>
                </div>

                <div id="fixed-expenses" class="content-section">
                    <div class="inner-box">
                        <table class="expense-table">
                            <thead>
                                <tr>
                                    <th>Expense ID</th>
                                    <th>Expense</th>
                                    <th>Amount</th>
                                    <th>Balance</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1</td>
                                    <td>Caretaker</td>
                                    <td>Ksh.3000</td>
                                    <td>Ksh.4000</td>
                                    <td>
                                        <button onclick="changeStatus('thumbs-up')">👍</button>

                                    </td>
                                    <td>
                                        <button onclick="openPopup('fixed')">+</button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>2</td>
                                    <td>Electricity</td>
                                    <td>Ksh.4000</td>
                                    <td>Ksh.4000</td>
                                    <td>

                                        <button onclick="changeStatus('thumbs-down')">👎</button>
                                    </td>
                                    <td>
                                        <button onclick="openPopup('fixed')">+</button>
                                    </td>
                                </tr>
                                <!-- Add more fixed expense rows as needed -->
                            </tbody>
                        </table>
                    </div>
                </div>

                <div id="varying-expenses" class="content-section" style="display: none;">
                    <table class="expense-table">
                        <thead>
                            <tr>
                                <th>Expense</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Add varying expense rows as needed -->
                        </tbody>
                    </table>
                </div>

                <div class="widget-footer">
                    <a href="{{ route('apartment-expenses', ['apartment' => $apartment->id])}}">Show More</a>
                    <button onclick="openPopup('fixed')">+</button>
                </div>
            </div>
        </div>
    </div>

    <style>
        .expense-buttons {
            display: flex;
            align-items: center;
        }

        .expense-buttons button {
            flex: 1;
            padding: 10px;
        }

        .separator {
            border-right: 1px solid #ccc;
            height: 20px;
            margin: 0 10px;
        }

        .widget {
            position: relative;
            border: 1px solid #ccc;
            border-radius: 5px;
            overflow: hidden;
        }

        .widget-content {
            padding: 10px;
        }

        .widget-header {
            background-color: #f5f5f5;
            padding: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .resize-handle {
            width: 10px;
            height: 100%;
            position: absolute;
            top: 0;
            right: 0;
            cursor: col-resize;
            background: #ddd;
        }

        .expense-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        .expense-table th,
        .expense-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        .expense-table th {
            background-color: #f5f5f5;
        }

        .widget-footer {
            margin-top: 10px;
            text-align: center;
        }

        .widget-buttons {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 10px;
            /* Adjust as needed */
        }

        .widget-buttons button {
            padding: 8px 12px;
            cursor: pointer;
            float: left;
        }

        .separator {
            margin: 0 10px;
        }
    </style>
    <script>
        function showSection(sectionId) {
            // Hide all sections
            document.getElementById('fixed-expenses').style.display = 'none';
            document.getElementById('varying-expenses').style.display = 'none';

            // Show the selected section
            document.getElementById(sectionId).style.display = 'block';

            // Activate the corresponding button
            document.querySelectorAll('.expense-buttons button').forEach(button => {
                button.classList.remove('active');
            });
            document.querySelector(`.expense-buttons button[data-section="${sectionId}"]`).classList.add('active');
        }

        // Show the default section on page load
        document.addEventListener('DOMContentLoaded', function () {
            showSection('fixed-expenses');
        });




        function changeStatus(status) {
            // Implement logic to change the status (thumbs up or down)
            console.log('Status changed:', status);
        }

        function openPopup(expenseType) {
            // Implement logic to open a popup for adding more expenses
            console.log(`Open popup for adding ${expenseType} expense`);
        }

        function minimizeWidget() {
            const widgetContent = document.getElementById('widget-content');
            widgetContent.style.display = widgetContent.style.display === 'none' ? 'block' : 'none';
        }

        function refreshWidget() {
            // Implement logic to refresh the widget content
            console.log('Widget refreshed');
        }

        function cancelWidget() {
            // Implement logic to cancel or close the widget
            console.log('Widget canceled');
        }

        function startResizing() {
            document.addEventListener('mousemove', handleResizing);
            document.addEventListener('mouseup', stopResizing);
        }

        function handleResizing(event) {
            const widget = document.querySelector('.widget');
            const widgetContent = document.getElementById('widget-content');
            const newWidth = event.clientX - widget.offsetLeft;
            widgetContent.style.width = `${newWidth}px`;
        }

        function stopResizing() {
            document.removeEventListener('mousemove', handleResizing);
            document.removeEventListener('mouseup', stopResizing);
        }

    </script>

    {{-- Recent Payments --}}
    <div class="col-md-4">
        <div class="widget">
            <div class="widget-header">
                <div class="widget-title">Recent Payments</div>
                <div class="widget-icons">
                    <i class="fas fa-window-minimize minimize-icon"></i>
                    <i class="fas fa-sync refresh-icon"></i>
                    <i class="fas fa-times cancel-icon"></i>
                </div>
            </div>
            <div class="resize-handle"></div>
            <div class="widget-content">
                <table class="table m-0">
                    <thead>
                        <tr>
                            <th>Invoice Number</th>
                            <th>User Name</th>
                            <th>Payment Date</th>
                            <th>Amount Paid</th>
                            <!-- Add more columns as needed -->
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($recentPayments as $invoice)
                        @if(isset($invoice->payments) && is_iterable($invoice->payments))
                        @foreach ($invoice->payments as $index => $payment)
                        <tr>
                            @if($index === 0) <!-- Check if it's the first payment to display invoice number -->
                            <td rowspan="{{ count($invoice->payments) }}">{{ $invoice->invoice_number }}</td>
                            <td rowspan="{{ count($invoice->payments) }}">{{ $invoice->user->name }}</td>
                            @endif
                            <td>{{ $payment['payment_date'] }}</td>
                            <td>{{ $payment['payment_amount'] }}</td>
                            <!-- Add more columns as needed -->
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td>{{ $invoice->invoice_number }}</td>
                            <td>{{ $invoice->user->name }}</td>
                            <td colspan="2">No payments available</td> <!-- colspan to span across columns -->
                            <!-- Add more columns as needed -->
                        </tr>
                        @endif
                        @endforeach
                    </tbody>
                </table>

            </div>
            <div class="widget-footer">
                <a href="{{ route('landlord.apartment-payments', ['apartment' => $apartment->id])}}">Show More</a>
                <button onclick="openPopup('fixed')">+</button>
            </div>
        </div>
    </div>

    {{-- Monitoring --}}
    <div class="col-md-4">
        <div class="widget">
            <div class="widget-header">
                <div class="widget-title">Monitoring</div>
                <div class="widget-icons">
                    <i class="fas fa-window-minimize minimize-icon" onclick="minimizeWidget()"></i>
                    <i class="fas fa-sync refresh-icon" onclick="refreshBox(this)"></i>
                    <i class="fas fa-times cancel-icon" onclick="cancelWidget()"></i>
                </div>
            </div>
            <div class="resize-handle"></div>


            <!-- My Assigned Section -->
            <div class="widget-content" id="">

                <table id="statusTable">
                    <thead>
                        <tr>
                            <th>No</th>
                    </thead>
                    <tbody>
                        <tr>
                            <td>1</td>
                            <td>Settings</td>
                            <td>80%</td>

                            <td>
                                <button class="thumbs-up">👍</button>

                            </td>

                        </tr>
                        <tr>
                            <td>2</td>
                            <td>Terms and Conditions</td>
                            <td>Present</td>

                            <td>
                                <button class="thumbs-up">👍</button>

                            </td>

                        </tr>
                        <tr>
                            <td>3</td>
                            <td>Emails</td>
                            <td>Not Set</td>

                            <td>
                                <button class="thumbs-up">👍</button>

                            </td>

                        </tr>
                        <tr>
                            <td>4</td>
                            <td>SMS</td>
                            <td>Not Set</td>

                            <td>
                                <button class="thumbs-up">👍</button>

                            </td>

                        </tr>
                        <tr>
                            <td>5</td>
                            <td>Payment Method</td>
                            <td>M-pesa</td>

                            <td>
                                <button class="thumbs-up">👍</button>

                            </td>

                        </tr>
                        <tr>
                            <td>6</td>
                            <td>Caretaker</td>
                            <td>Not Set</td>

                            <td>
                                <button class="thumbs-up" onclick="changeStatus(this)">👍</button>

                            </td>

                        </tr>
                        <tr>
                            <td>7</td>
                            <td>Caretaker</td>
                            <td>Not Set</td>

                            <td>
                                <button class="thumbs-up" onclick="changeStatus(this)">👍</button>

                            </td>

                        </tr>

                        <tr>
                            <td>8</td>
                            <td>Caretaker</td>
                            <td>Not Set</td>

                            <td>
                                <button class="thumbs-down" onclick="changeStatus(this)">👎</button>

                            </td>

                        </tr>
                        <tr>
                            <td>9</td>
                            <td>Electricity</td>
                            <td>Not Set</td>

                            <td>

                                <button class="thumbs-down" onclick="changeStatus(this)">👎</button>
                            </td>

                        </tr>
                        <!-- Add more fixed expense rows as needed -->

                    </tbody>
                </table>

            </div>





            <!-- Due Projects Section -->
            <div class="widget-content" id="dueProjects-section" style="display: none;">
                <h3>Due Projects</h3>
                <table>
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Due Date</th>
                            <th>Days Left</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Your loop for Due Projects goes here -->
                    </tbody>
                </table>
            </div>

            <!-- Recent Activity Section -->
            <div class="widget-content" id="recentActivity-section" style="display: none;">
                <h3>Recent Activity</h3>
                <table>
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Due Date</th>
                            <th>Days Left</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Your loop for Recent Activity goes here -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Project Management --}}
    <div class="col-md-4 project-management-widget">
        <div class="widget">
            <div class="widget-header">
                <div class="widget-title">Project Management</div>
                <div class="widget-icons">
                    <i class="fas fa-window-minimize minimize-icon" onclick="minimizeWidget()"></i>
                    <i class="fas fa-sync refresh-icon" onclick="refreshBox(this)"></i>
                    <i class="fas fa-times cancel-icon" onclick="cancelWidget()"></i>
                </div>
            </div>
            <div class="resize-handle"></div>
            <div class="widget-buttons project-management-buttons">
                <button data-section="myAssignedProjects-section">My Assigned</button>
                <div class="separator"></div>
                <button data-section="dueProjects-section">Due Projects</button>
                <div class="separator"></div>
                <button data-section="recentActivity-section">Recent Activity</button>
            </div>

            <!-- My Assigned Section -->
            <div class="widget-content" id="myAssignedProjects-section">
                <h3>My Assigned Projects</h3>
                <table>
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Due Date</th>
                            <th>Days Left</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Your loop for My Assigned Projects goes here -->
                    </tbody>
                </table>
            </div>

            <!-- Due Projects Section -->
            <div class="widget-content" id="dueProjects-section" style="display: none;">
                <h3>Due Projects</h3>
                <table>
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Due Date</th>
                            <th>Days Left</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Your loop for Due Projects goes here -->
                    </tbody>
                </table>
            </div>

            <!-- Recent Activity Section -->
            <div class="widget-content" id="recentActivity-section" style="display: none;">
                <h3>Recent Activity</h3>
                <table>
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Due Date</th>
                            <th>Days Left</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Your loop for Recent Activity goes here -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    {{-- To-Do-List --}}
    <div class="col-md-4">
        <div class="widget">
            <div class="widget-header">
                <div class="widget-title">To-Do List</div>
                <div class="widget-icons">
                    <i class="fas fa-window-minimize minimize-icon"></i>
                    <i class="fas fa-sync refresh-icon"></i>
                    <i class="fas fa-times cancel-icon"></i>
                </div>
            </div>
            <div class="resize-handle"></div>
            <div class="widget-content">
                <p>This is the content of Widget 1.</p>
            </div>
        </div>
    </div>

    {{-- Support --}}
    <div class="col-md-4">
        <div class="widget">
            <div class="widget-header">
                <div class="widget-title">Support</div>
                <div class="widget-icons">
                    <i class="fas fa-window-minimize minimize-icon"></i>
                    <i class="fas fa-sync refresh-icon"></i>
                    <i class="fas fa-times cancel-icon"></i>
                </div>
            </div>
            <div class="resize-handle"></div>
            <div class="widget-content">
                <p>LAndlord.apartment.Ticket 1</p>
                <p>LAndlord.apartment.Ticket 1</p>
                <p>LAndlord.apartment.Ticket 1</p>
                <p>LAndlord.apartment.Ticket 1</p>
            </div>
        </div>
    </div>
    <!-- Recent Orders -->
    <div class="col-md-4">
        <div class="widget">
            <div class="widget-header">
                <div class="widget-title">Recent Orders</div>
                <div class="widget-icons">
                    <i class="fas fa-window-minimize minimize-icon"></i>
                    <i class="fas fa-sync refresh-icon"></i>
                    <i class="fas fa-times cancel-icon"></i>
                </div>
            </div>
            <div class="resize-handle"></div>
            <div class="widget-content">
                <p>LAndlord.apartment.Ticket 1</p>
                <p>LAndlord.apartment.Ticket 1</p>
                <p>LAndlord.apartment.Ticket 1</p>
                <p>LAndlord.apartment.Ticket 1</p>
            </div>
        </div>
    </div>

    {{-- Outstanding balances --}}
    <div class="col-md-4 outstanding-balances-widget">
        <div class="widget">
            <div class="widget-header">
                <div class="widget-title">Outstanding Balances</div>
                <div class="widget-icons">
                    <i class="fas fa-window-minimize minimize-icon"></i>
                    <i class="fas fa-sync refresh-icon"></i>
                    <i class="fas fa-times cancel-icon"></i>
                </div>
            </div>
            <div class="resize-handle"></div>
            <div class="widget-buttons">
                <button onclick="showSection('thisMonthOutstanding-section')">This Month</button>
                <div class="separator"></div>
                <button onclick="showSection('overallOutstanding-section')">Overall</button>
            </div>

            <!-- This Month Section -->
            <div class="widget-content" id="thisMonthOutstanding-section">

                <table>
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Phone</th>
                            <th>Room</th>
                            <th>Balance</th>
                            <th>View</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Your loop for This Month's Balances goes here -->
                        @foreach($thisMonthOutstandingBalances as $balance)
                        <tr>
                            <td>{{ $balance->user->name }}</td>
                            <td>{{ $balance->user->phone_number }}</td>
                            <td>{{ $balance->rooms->room_number }}</td>
                            <td>{{ $balance->balance }}</td>
                            <td>View</td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="3"></td>
                            <td>Total: {{ $totalUnpaidThisMonth }}</td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <!-- Overall Section -->
            <div class="widget-content" id="overallOutstanding-section" style="display: none;">
                <h3>Overall Outstanding Balances</h3>
                <table>
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Phone</th>
                            <th>Room</th>
                            <th>Balance</th>
                            <th>View</th>
                        </tr>

                    </thead>
                    <tbody>
                        @foreach($overallOutstandingBalances as $balance)
                        <tr>
                            <td>{{ $balance->user->name }}</td>
                            <td>{{ $balance->user->phone_number }}</td>
                            <td>{{ $balance->rooms->room_number }}</td>
                            <td>{{ $balance->balance }}</td>
                            <td>View</td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="3"></td>
                            <td>Total: {{ $overallTotalBalance }}</td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>


        </div>
    </div>

    <<script>
        document.addEventListener("DOMContentLoaded", function () {
        // Function to show or hide sections based on the selected button
        function showSection(widgetContainer, sectionId) {
        // Hide all sections within the widget
        widgetContainer.querySelectorAll('.widget-content').forEach(function (section) {
        section.style.display = 'none';
        });

        // Show the selected section
        widgetContainer.querySelector(`#${sectionId}`).style.display = 'block';
        }

        // Button event listeners for each outstanding balances widget
        document.querySelectorAll('.outstanding-balances-widget').forEach(function (widgetContainer) {
        const buttons = widgetContainer.querySelectorAll('.widget-buttons button');

        buttons.forEach(button => {
        button.addEventListener("click", function () {
        const sectionId = button.getAttribute('data-section');
        showSection(widgetContainer, sectionId);
        });
        });
        });
        });
        </script>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
                var thumbsUpButtons = document.querySelectorAll(".thumbs-up");
                var thumbsDownButtons = document.querySelectorAll(".thumbs-down");

                thumbsUpButtons.forEach(function (button) {
                    button.addEventListener("click", function () {
                        toggleButton(button, "thumbs-up");
                    });
                });

                thumbsDownButtons.forEach(function (button) {
                    button.addEventListener("click", function () {
                        toggleButton(button, "thumbs-down");
                    });
                });

                function toggleButton(button, voteType) {
                    var siblingButton = button.parentElement.nextElementSibling.querySelector("button");
                    button.classList.add("thumbs-up");
                    button.classList.remove("thumbs-down");
                    siblingButton.classList.remove("thumbs-up");
                    siblingButton.classList.add("thumbs-down");
                }

                var rows = document.querySelectorAll("#statusTable tbody tr");
                rows.forEach(function (row) {
                    var valueCell = row.cells[2];
                    var statusCell = row.cells[3];
                    var statusButton = statusCell.querySelector("button");
                    var value = valueCell.textContent.trim();
                    if (value === "Not Set") {
                        statusButton.textContent = "👎";
                        statusButton.classList.add("thumbs-down");
                        row.classList.add("red-row");
                    } else {
                        statusButton.textContent = "👍";
                        statusButton.classList.add("thumbs-up");
                        row.classList.add("green-row");
                    }
                });
            });
        </script>



        <script>
            document.addEventListener("DOMContentLoaded", function () {
                // Get all widgets on the page
                const widgets = document.querySelectorAll(".your-widget-class");

                // Function to show or hide sections based on the selected button
                function showSection(widget, sectionId) {
                    // Hide all sections within the widget
                    widget.querySelectorAll('.widget-content').forEach(function (section) {
                        section.style.display = 'none';
                    });

                    // Show the selected section
                    widget.querySelector(`#${sectionId}`).style.display = 'block';
                }

                // Button event listeners for each widget
                widgets.forEach(function (widget) {
                    const buttons = widget.querySelectorAll('.widget-buttons button');

                    buttons.forEach(button => {
                        button.addEventListener("click", function () {
                            const sectionId = button.getAttribute('data-section');
                            showSection(widget, sectionId);
                        });
                    });
                });
            });

        </script>



        {{-- <Expiring-lease></Expiring-lease> --}}
        <div class="col-md-4">
            <div class="widget">
                <div class="widget-header">
                    <div class="widget-title">Expiring Leases</div>
                    <div class="widget-icons">
                        <i class="fas fa-window-minimize minimize-icon"></i>
                        <i class="fas fa-sync refresh-icon"></i>
                        <i class="fas fa-times cancel-icon"></i>
                    </div>
                </div>
                <div class="resize-handle"></div>
                <div class="widget-content">
                    <!-- Your widget content goes here -->
                    <ul class="product-list">
                        <li>Caretaker: Ksh.3000</li>
                        <li>Electricity:Ksh.4000</li>
                        <li>Security: </li>
                        <!-- Add more product listings as needed -->
                    </ul>
                </div>
            </div>
        </div>
        {{-- Overdue Tasks --}}
        <div class="col-md-4">
            <div class="widget">
                <div class="widget-header">
                    <div class="widget-title">Overdue Tasks</div>
                    <div class="widget-icons">
                        <i class="fas fa-window-minimize minimize-icon"></i>
                        <i class="fas fa-sync refresh-icon"></i>
                        <i class="fas fa-times cancel-icon"></i>
                    </div>
                </div>
                <div class="resize-handle"></div>
                <div class="widget-content">
                    <!-- Your widget content goes here -->
                    <ul class="product-list">
                        <li>Caretaker: Ksh.3000</li>
                        <li>Electricity:Ksh.4000</li>
                        <li>Security: </li>
                        <!-- Add more product listings as needed -->
                    </ul>
                </div>
            </div>
        </div>


        <script>
            document.addEventListener("DOMContentLoaded", function () {
                // Get all project management widgets on the page
                const projectManagementWidgets = document.querySelectorAll(".project-management-widget");

                // Function to show or hide sections based on the selected button
                function showSection(widgetContainer, sectionId) {
                    // Hide all sections within the widget
                    widgetContainer.querySelectorAll('.widget-content').forEach(function (section) {
                        section.style.display = 'none';
                    });

                    // Show the selected section
                    widgetContainer.querySelector(`#${sectionId}`).style.display = 'block';
                }

                // Button event listeners for each project management widget
                projectManagementWidgets.forEach(function (widgetContainer) {
                    const buttons = widgetContainer.querySelectorAll('.project-management-buttons button');

                    buttons.forEach(button => {
                        button.addEventListener("click", function () {
                            const sectionId = button.getAttribute('data-section');
                            showSection(widgetContainer, sectionId);
                        });
                    });
                });
            });

        </script>

        {{-- Admins Online --}}
        <div class="col-md-4">
            <div class="widget">
                <div class="widget-header">
                    <div class="widget-title">Admins Online</div>
                    <div class="widget-icons">
                        <i class="fas fa-window-minimize minimize-icon"></i>
                        <i class="fas fa-sync refresh-icon"></i>
                        <i class="fas fa-times cancel-icon"></i>
                    </div>
                </div>
                <div class="resize-handle"></div>
                <div class="widget-content">
                    <!-- Your widget content goes here -->
                    <ul class="product-list">
                        <li>vin</li>
                        <li>Electricity:Ksh.4000</li>
                        <li>Security: </li>
                        <!-- Add more product listings as needed -->
                    </ul>
                </div>
            </div>
        </div>
</div>
</div>


</div>
</div>
</div>
@endsection
