@extends('layouts.apartment-layout')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
                        @include('partials._apartment_dropdown')

                        </div>
                        <div class="col-sm-6">
                            @include('partials._message_box')
                        </div>
                    </div>


        </div>
    </div>

    <section>
        <div class="container-fluid">
            <div class="row ">


                <div class="col-lg-2 col-6">



                    <div class="data-car">
                        <div href="#" class="data-card-link"target="_blank">
                            {{-- <div class="data-card">
                                <h5 class="data-title">Total Users</h5>
                                <p class="data-value"> {{ $totalUsers}}</p>
                                <div class="data-chart">
                                    <!-- Insert your chart or graph here -->
                                </div>
                            </div> --}}
                            <div class="small-box bg-blue" >
                                <div class="inner">
                                    <p >TOTAL ROOMS</p>
                                    <h4 class="center">{{ $roomCount }}</h4>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-person-add"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2 col-6">
                    <div class="small-box bg-green" >
                        <div class="inner">
                            <p >Occupied</p>
                            <h4 class="center">{{ $apartment->rooms->where('status', 'Occupied')->count() }}
                            </h4>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2 col-6">
                    <div class="small-box bg-blue" >
                        <div class="inner">
                            <p >unoccupied</p>
                            <h4 class="center">{{ $apartment->rooms->where('status', 'Available')->count() }}
                            </h4>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                    </div>
                    </div>

                <div class="col-lg-2 col-6">
                    <div class="small-box bg-blue" >
                        <div class="inner">
                            <p >With Roles</p>
                            <h4 class="center">{{ $apartment->rooms->where('status', 'Booked')->count() }}
                            </h4>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2 col-6">
                    <div class="small-box bg-yellow" >
                        <div class="inner">
                            <p >Pending Request</p>
                            <h4 class="center">{{ $apartment->rooms->where('status', 'Inactive')->count() }}
                            </h4>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-6">
                    <div class="small-box bg-red" >
                        <div class="inner">
                            <p >Pending Delete</p>
                            <h4 class="center">{{ $apartment->rooms->where('status', 'Pending')->count() }}
                            </h4>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person-add"></i>
                        </div>
                    </div>
                </div>

        </div>
        </div>

    </section>
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-md-12">
                        <div class="card">
                            <section id="WidgetRooms">
                                <div class="row">
                                    <div class="container-fluid">
                                        <div class="card-header row mb-2">
                                            <div class="col-sm-6">
                                                <h2>Rooms in Grid</h2>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row content-header" id="roomWidgetsContainer">
                                    <!-- Room widgets will be dynamically added here -->
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button class="btn btn-primary">Add Room</button>
                                </div>
                        </div>
                    </div>
                </div>
            </div>


    </section>
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card">

                <section id="ListRooms">
                <div class="row card-header">
                    <div class="container-fluid">
                        <div class="content-header row mb-2">
                            <div class="col-sm-6">
                        <h2>Rooms in Table Format</h2>
                </div>
                        </div></div>
            </div>
                <div class="card-body">


                        <table>
                            <thead>
                                <tr>
                                    <th>Room ID</th>
                                    <th>Room Number</th>
                                    <th>Room Type</th>
                                    <th>Price</th>
                                    <th>Status</th>
                                    <th>Occupant</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($apartment->rooms as $room)
                                    <tr>
                                        <td>{{ $room->id }}</td>
                                        <td>{{ $room->room_number }}</td>
                                        <td>{{ $room->room_size }}</td>
                                        <td>{{$apartment->currency}} {{ number_format($room->price , 2) }}</td>
                                        <td>{{ $room->status }}</td>
                                        <td>
                                            @if ($room->status === 'Occupied')
                                                @foreach ($room->users as $user)
                                                    {{ $user->name }}
                                                @endforeach
                                            @elseif ($room->status === 'Booked')
                                            {{ $user->name }}
                                            @else
                                                No occupant
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                </div>
                <div class="card-footer">
                    <button class="btn btn-primary">Add Room</button>
                </div>
                </section>
                </div>
            </div>
        </div>
    </div>
</div>


<style>
    .card{
        background-color: rgba(235, 243, 235, 0.973);
    }
/* Style for the room widgets */
.room-widget {
    position: relative; /* Add this line to position details relative to room-widget */
    width: 150px;
    height: 100px;
    border: 1px solid #000;
    margin: 5px;
    display: inline-block;
    cursor: pointer;
    text-align: center;
    line-height: 100px; /* Center content vertically */
    font-weight: bold;
    background-color: rgb(143, 145, 143);
}

/* Different background colors based on room status */
.room-widget.occupied {
    background-color: rgb(81, 233, 81);
}

.room-widget.booked {
    background-color: yellow;
}

.room-widget.empty {
    background-color: grey;
}

/* Style for the details on hover */
.details {
    display: none;
    position: absolute; /* Change from relative to absolute */
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(255, 255, 255, 0.9);
    padding: 10px;
    box-sizing: border-box;
    text-align: left;
}

/* Style for the link in the details */
.details a {
    display: block;
    margin-top: 10px;
}



</style>
<script>
  document.addEventListener("DOMContentLoaded", function () {
    // Get the container for room widgets
    const roomWidgetsContainer = document.getElementById("roomWidgetsContainer");

    // Loop through the rooms and create widgets
    @foreach($apartment->rooms as $room)
        // Use a unique variable name for each iteration
        (function() {
            // Initialize roomWidget inside the IIFE
            let currentRoomWidget = document.createElement("div");
            currentRoomWidget.classList.add("room-widget");
            currentRoomWidget.classList.add('{{ strtolower($room->status) }}');
            currentRoomWidget.innerText = '{{ $room->room_number }}';

            // Initialize details inside the IIFE
            let currentDetails = document.createElement("div");
            currentDetails.classList.add("details");
            currentDetails.innerHTML = `
                <p>Room Number: {{ $room->room_number }}</p>
                <p>Room Type: {{ $room->room_size }}</p>
                <p>Price: {{$apartment->currency}} {{ number_format($room->price , 2) }}</p>
                <p>Status: {{ $room->status }}</p>
                <p>Occupant: @if ($room->status === 'Occupied') @foreach ($room->users as $user) {{ $user->name }} @endforeach @elseif ($room->status === 'Booked') {{ $user->name }} @else No occupant @endif</p>
                <a href="{{ route('landlord.room-details', ['apartmentId' => $apartment->id, 'roomId' => $room->id]) }}" target="_blank">View Details</a>


            `;

            // Append the details to the room widget
            currentRoomWidget.appendChild(currentDetails);

            // Append the room widget to the container
            roomWidgetsContainer.appendChild(currentRoomWidget);

            // Hover event to toggle details visibility
            currentRoomWidget.addEventListener("mouseover", function () {
                currentDetails.style.display = "block";
            });

            currentRoomWidget.addEventListener("mouseout", function () {
                currentDetails.style.display = "none";
            });

            // Click event to open a new tab with more room settings
           // Click event to open a new tab with more room settings
           currentRoomWidget.addEventListener("click", function () {
            window.open("{{ route('landlord.room-details', ['apartmentId' => $apartment->id, 'roomId' => $room->id]) }}", '_blank');

});

        })();
    @endforeach
});


</script>
@endsection

