<?php
$apartmentName= $apartment->name ;
$pageTitle="ALL INVOICES";
$title=$apartmentName.' - '. $pageTitle;
?>

@extends('layouts.apartment-layout')


@section('content')

<div class="content-wrapper">
                    <!-- Content Header (Page header) -->
                    <div class="content-header">
                        <div class="container-fluid">
                            @include('partials._apartment_header')
                        </div>
                    </div>



                                <div class="container-fluid">
                                    <div class="row justify-content-left">
                                        <div class="col-md-12">
                                            {{-- <div class="card"> --}}
                                                {{-- <images></images> --}}
                                                <div class="card card-section">
                                                    <div class="card-header">

                                <div class="custom-navbar">
                                    <button class="nav-btn" data-section="sectionSearchApartmentInvoices" onclick="showSection('sectionSearchApartmentInvoices')">Search</button>
                                    <button class="nav-btn" data-section="sectionGenerateApartmentInvoices" onclick="showSection('sectionGenerateApartmentInvoices')">Generate</button>
                                    <button class="nav-btn" data-section="sectionLinkstoInvoiceAparmentSettings" onclick="showSection('sectionLinkstoInvoiceAparmentSettings')">Invoice Settings</button>
                                </div>
                                <div class="row">
                              @include('partials._message_box')
                                </div>

                                <div class="content-section" id="sectionSearchApartmentInvoices">
                                    <div class="outer-box">
                                        <div class="inner-box">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="firstNadme" class="col-sm-4 col-form-label text-right">Client Name:</label>
                                                    <div class="col-sm-8">
                                                        <input class="content" type="text" id="firstName" name="firstName" value="" required class="form-control">
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label for="firstNadme" class="col-sm-4 col-form-label text-right">Invoice#:</label>
                                                    <div class="col-sm-8">
                                                        <input class="content" type="text" id="firsdtName" name="firstdName" value="" required class="form-control">
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label for="firstNadme" class="col-sm-4 col-form-label text-right">Invoice Items:</label>
                                                    <div class="col-sm-8">
                                                        <input class="content" type="text" id="firsdtName" name="firstdName" value="" required class="form-control">
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label for="firstNadme" class="col-sm-4 col-form-label text-right">Payment Method:</label>
                                                    <div class="col-sm-8">
                                                        <input class="content" type="text" id="firsdtName" name="firstdName" value="" required class="form-control">
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label for="firstNadme" class="col-sm-4 col-form-label text-right">Status:</label>
                                                    <div class="col-sm-8">
                                                        <input class="content" type="text" id="firsdtName" name="firstdName" value="" required class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <p>This is the content of Section 1.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="btn button-primary" type="button" >Search</button>


                                </div>
                                </div>

                                <div class="content-section" id="sectionGenerateApartmentInvoices">
                                    <h2>Generate ApartmentInvoices</h2>
                                    <div class="row">
                                        <div class="col-md-6">
                                        <form id="generateForm" action="{{ route('generate-invoices', ['apartment' => $apartment->id]) }}" method="post">
                                            @csrf
                                            <button class="btn button-secondary" type="button" onclick="confirmInvoiceGeneration()">Generate Invoices</button>
                                        </form>
                                    </div>
                                    <div class="col-md-6">
                                        <form id="revertForm" action="{{ route('revert-invoices', ['apartment' => $apartment->id]) }}" method="post">
                                            @csrf
                                            <button class="btn button-danger" type="button" onclick="confirmRevertGeneration()">Revert Recent Generation</button>
                                        </form>
                                    </div>
                                    </div>
                                </div>

                                <div class="content-section" id="sectionLinkstoInvoiceAparmentSettings">
                                    <h2>Delete</h2>
                                    <form id="deleteForm" action="{{ route('invoices.delete', ['apartment' => $apartment->id]) }}" method="POST">
                                        @csrf
                                        <input type="datetime-local" name="date_and_time" required>
                                        <button type="button" onclick="confirmInvoiceDateDelete()">Delete Invoices</button>
                                    </form>

                                    <script>
                                        function confirmInvoiceDateDelete() {
                                            if (confirm('Are you sure you want to delete the invoices?')) {
                                                document.getElementById('deleteForm').submit();
                                            }
                                        }
                                    </script>


                                </div>
                                                    </div>
                                                    <div class="card-header">
                                                        Downlaod
                                                        <div class="card-tools">
                                                            Download
                                                        </div>
                                                    </div>
                    <div class="card-body">

                    <table class="table">
                        <thead>
                            <tr>
                                <th>Select</th>
                                <th>Invoice #</th>
                                <th>Client Name</th>
                                <th>Invoice Date</th>
                                <th>Due Date</th>
                                <th>Total</th>
                                <th>Payment Method</th>
                                <th><form action="{{ route('apartment-all-invoices', ['apartment'=>$apartment->id]) }}" method="GET">
                                    <select name="status" onchange="this.form.submit()">
                                        <option value="all" {{ $paymentStatus === 'all' ? 'selected' : '' }}>All</option>
                                        <option value="Paid" {{ $paymentStatus === 'Paid' ? 'selected' : '' }}>Paid</option>
                                        <option value="Unpaid" {{ $paymentStatus === 'Unpaid' ? 'selected' : '' }}>Unpaid</option>
                                    </select>
                                </form></th>
                                <th>Edit</th>
                                <th>Del</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($apartmentInvoices as $invoice)
                                <tr>
                                    <td><input type="checkbox" class="invoice-checkbox" data-invoice-id="{{ $invoice->id }}"></td>
                                    <td>
                                        <a href="{{ route('landlord-edit-invoice', ['apartment'=>$apartment->id, 'invoice' => $invoice->id]) }}">
                                            {{ $invoice->invoice_number }}
                                        </a>
                                    </td>
                                    <td><a href="{{ route('landlord-view-tenant-profile', ['apartment' => $apartment->id, 'usersInApartment' => $user->id]) }}" class="user-link">{{ $invoice->user->name }}</a></td>
                                    <td>{{ $invoice->created_at }}</td>
                                    <td>{{ $invoice->due_date }}</td>
                                    <td>{{ $invoice->total_amount }}</td>
                                    <td>Mpesa</td>
                                    <td class="{{ $invoice->payment_status}}">{{ $invoice->payment_status }}</td>
                                    <td>Edit</td>
                                    <td>Del</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8">No invoices found</td>
                                </tr>
                            @endforelse

                        </tbody>

                    </table>
                    </div>
                    <div class="card-footer">

                    <div class="button-row">

                        <button class="btn button-danger" type="button" id="delete-selected-invoices" onclick="deleteSelectedInvoices()">Delete Selected</button>
                        <!-- Display pagination links -->
    <ul class="pagination justify-content-end"> <!-- Align pagination links to the right -->
       <!-- Display pagination links -->
    <ul class="pagination justify-content-end"> <!-- Align pagination links to the right -->
        {{-- Previous Page Link --}}
        @if ($apartmentInvoices->onFirstPage())
            <li class="page-item disabled" aria-disabled="true" aria-label="@lang('pagination.previous')">
                <span class="page-link" aria-hidden="true">&lsaquo;</span>
            </li>
        @else
            <li class="page-item">
                <a class="page-link" href="{{ $apartmentInvoices->previousPageUrl() }}" rel="prev" aria-label="@lang('pagination.previous')">&lsaquo;</a>
            </li>
        @endif

        {{-- Page Number Box --}}
        <li class="page-item disabled" aria-disabled="true">
            <span class="page-link">{{ $apartmentInvoices->currentPage() }}</span>
        </li>

        {{-- Next Page Link --}}
        @if ($apartmentInvoices->hasMorePages())
            <li class="page-item">
                <a class="page-link" href="{{ $apartmentInvoices->nextPageUrl() }}" rel="next" aria-label="@lang('pagination.next')">&rsaquo;</a>
            </li>
        @else
            <li class="page-item disabled" aria-disabled="true" aria-label="@lang('pagination.next')">
                <span class="page-link" aria-hidden="true">&rsaquo;</span>
            </li>
        @endif
    </ul>
                        <div style="clear: both;"></div>
                    </div>
                </div>

                </div>
    </div>
</div>
</div>

</body>
</div>
</html>

@endsection

