@extends('layouts.landlord-layout')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-2">
          </div>
          <div class="col-sm-4">
            <h6>@include('partials._message_box')</h6>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Licenses</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <div class="form-group mb-0">
                            <p class="mb-0">{{ __('My Licenses') }}</p>
                        </div>
                        <div class="form-group mb-0">
                            <form method="get" action="{{ route('licenses.purchase-page') }}">
                                @csrf
                                <button type="submit" class="btn btn-primary">Purchase Another License</button>
                            </form>
                        </div>
                    </div>

                    <div class="card-body">
                        <div class="row">
                            <div class="row">
                            <p>Enter Key to Add License</p>
                            <br>
                            </div>
                            <div class="row">
                            <form method="post" action="{{ route('licenses.install-key') }}">
                                @csrf
                                <input type="text" name="upgrade_plan" placeholder="Upgrade Plan">
                                <button type="submit" class="btn btn-primary">Install Key</button>
                            </form>
                            </div>
                        </div>
                        <div class="mt-3">
                            @forelse ($user->licensePurchases as $index => $licensePurchase)
                                <div class="card mb-3" style="background-color: rgba(0, 0, 0, {{ ($index + 1) * 0.1 }});">
                                    <div class="card-header"><p><strong>License:</strong> {{ $licensePurchase->license_key }}</p></div>
                                    <div class="card-body">
                                        <p><strong>License Type:</strong> {{ $licensePurchase->license_type }}</p>
                                        <p><strong>License Key:</strong> {{ $licensePurchase->license_key }}</p>
                                        <p><strong>Expiry Date:</strong> {{ $licensePurchase->expiry_date }}</p>
                                        <p><strong>Purchase Date:</strong> {{ $licensePurchase->purchase_date }}</p>
                                        <!-- Add more license details as needed -->
                                        <div class="mt-3">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <form method="post" action="{{ route('licenses.reissue') }}">
                                                        @csrf
                                                        <button type="submit" class="btn btn-primary">Request Reissue</button>
                                                    </form>
                                                </div>
                                                <div class="col-md-3">
                                                </div>
                                                <div class="col-md-3">
                                                    <!-- Add button to show renewal form -->
                                                    @if ($licensePurchase->license_type !== 'demo')
                                                        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#renewModal">
                                                            Renew License
                                                        </button>
                                                    @endif
                                                </div>
                                                <div class="col-md-3">
                                                    <!-- Input form for possible upgrade -->
                                                    <form method="get" action="{{ route('licenses.upgrade-page') }}">
                                                        @csrf
                                                        <button type="submit" class="btn btn-success">Upgrade</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <p>You don't have a license. Purchase one to start managing your property and access premium features.</p>
                                <form method="get" action="{{ route('licenses.purchase-page') }}">
                                    @csrf
                                    <button type="submit" class="btn btn-success">Purchase License</button>
                                </form>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<!-- Renewal Modal -->
<div class="modal fade" id="renewModal" tabindex="-1" role="dialog" aria-labelledby="renewModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="renewModalLabel">Renew License</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Include a form to collect renewal details (e.g., number of months or weeks) -->
                <form id="renewForm">
                    <!-- Add form fields for renewal details -->
                    <div class="form-group">
                        <label for="renewalPeriod">Renewal Period (months or weeks):</label>
                        <input type="number" class="form-control" id="renewalPeriod" name="renewalPeriod" required>
                    </div>

                    <!-- Add more fields or customization based on your needs -->

                    <button type="button" class="btn btn-primary" onclick="calculateRenewalPrice()">Calculate Price</button>
                </form>

                <!-- Display calculated price -->
                <div id="calculatedPrice"></div>
            </div>
            <div class="modal-footer">
                <!-- Add buttons for renewing and upgrading -->
                <button type="button" class="btn btn-success" onclick="renewLicense()">Renew</button>
                <button type="button" class="btn btn-warning" onclick="upgradeLicense()">Upgrade License</button>
            </div>
        </div>
    </div>
</div>
 </div>



<script>
    function calculateRenewalPrice() {
        // Implement JavaScript logic to calculate the renewal price based on form input
        // Display the calculated price in the "calculatedPrice" div
    }

    function renewLicense() {
        // Implement JavaScript logic to initiate the renewal process (e.g., submit the form via AJAX)
        // Close the modal after renewal
        $('#renewModal').modal('hide');
    }

    function upgradeLicense() {
        // Implement JavaScript logic to redirect to the upgrade page
        // Close the modal
        $('#renewModal').modal('hide');
    }
</script>

@endsection

