@extends('layouts.landlord-layout')

@section('content')
@section('content')
    <div class="container">
        <h2>Payment Success</h2>
        <p>Your payment was successful. Thank you!</p>
        You can proceed to add apartment or go back to dashboard

        <!-- Add additional details or instructions as needed -->
        <p>You don't have a license. Purchase one to start managing your property and access premium features.</p>
                            <form method="get" action="{{ route('licenses.purchase-page') }}">
                                @csrf
                                <button type="submit" class="btn btn-success">Purchase License</button>
                            </form>
    </div>
<div class="content-wrapper">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">{{ __('License Information') }}</div>

                    <div class="card-body">
                        @forelse ($user->licensePurchases as $licensePurchase)
                            <p><strong>License Type:</strong> {{ $licensePurchase->license_type }}</p>
                            <p><strong>Expiry Date:</strong> {{ $licensePurchase->expiry_date }}</p>
                            <p><strong>Purchase Date:</strong> {{ $licensePurchase->purchase_date }}</p>
                            <!-- Add more license details as needed -->

                            <div class="mt-3">
                                <!-- Add buttons for various actions -->
                                <form method="post" action="{{ route('licenses.reissue') }}">
                                    @csrf
                                    <button type="submit" class="btn btn-primary">Request Reissue</button>
                                </form>

                                <form method="post" action="{{ route('licenses.install-key') }}">
                                    @csrf
                                    <button type="submit" class="btn btn-primary">Install Key</button>
                                </form>
                            </div>

                        @empty
                            <p>You don't have a license. Purchase one to start managing your property and access premium features.</p>
                            <form method="get" action="{{ route('licenses.purchase-page') }}">
                                @csrf
                                <button type="submit" class="btn btn-success">Purchase License</button>
                            </form>

                        @endforelse

                        @if ($user->hasUpgradableLicense())
                            <form method="get" action="{{ route('licenses.upgrade-page') }}">
                                @csrf
                                <button type="submit" class="btn btn-warning mt-3">Upgrade License</button>
                            </form>
                        @endif
                         <!-- Add button to renew license -->
                         <div class="mt-3">
                            <!-- Add button to show renewal form -->
                            @if ($licensePurchase->license_type !== 'demo')
                                <button type="button" class="btn btn-success" data-toggle="modal" data-target="#renewModal">
                                    Renew License
                                </button>
                            @endif
                        </div>

                        <!-- Renewal Modal -->
                        <div class="modal fade" id="renewModal" tabindex="-1" role="dialog" aria-labelledby="renewModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="renewModalLabel">Renew License</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <!-- Include a form to collect renewal details (e.g., number of months or weeks) -->
                                        <form id="renewForm">
                                            <!-- Add form fields for renewal details -->
                                            <div class="form-group">
                                                <label for="renewalPeriod">Renewal Period (months or weeks):</label>
                                                <input type="number" class="form-control" id="renewalPeriod" name="renewalPeriod" required>
                                            </div>

                                            <!-- Add more fields or customization based on your needs -->

                                            <button type="button" class="btn btn-primary" onclick="calculateRenewalPrice()">Calculate Price</button>
                                        </form>

                                        <!-- Display calculated price -->
                                        <div id="calculatedPrice"></div>
                                    </div>
                                    <div class="modal-footer">
                                        <!-- Add buttons for renewing and upgrading -->
                                        <button type="button" class="btn btn-success" onclick="renewLicense()">Renew</button>
                                        <button type="button" class="btn btn-warning" onclick="upgradeLicense()">Upgrade License</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <script>
                            function calculateRenewalPrice() {
                                // Implement JavaScript logic to calculate the renewal price based on form input
                                // Display the calculated price in the "calculatedPrice" div
                            }

                            function renewLicense() {
                                // Implement JavaScript logic to initiate the renewal process (e.g., submit the form via AJAX)
                                // Close the modal after renewal
                                $('#renewModal').modal('hide');
                            }

                            function upgradeLicense() {
                                // Implement JavaScript logic to redirect to the upgrade page
                                // Close the modal
                                $('#renewModal').modal('hide');
                            }
                        </script>

                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection

