@extends('layouts.landlord-layout')

@section('content')
<style>
    /* Add the following CSS to your styles file or in the head of your HTML */

.container {
    text-align: center;
}

.license-card {
    margin-bottom: 20px;
    background-color: #b6cce2; /* Set your default background color */
    transition: background-color 0.3s ease; /* Add a smooth transition effect */
}

.license-card:hover {
    background-color: #d6d8db; /* Set the background color on hover */
}

.card-header {
    background-color: #22303f; /* Set your header background color */
    color: #fff;
    text-align: center;
}

.card-body {
    text-align: left;
}

.btn-primary {
    margin-top: 10px;
}

/* Add more styling as needed */

</style>
 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-2">
          </div>
          <div class="col-sm-4">
            <h6>@include('partials._message_box')</h6>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Licenses</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

{{-- <div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Purchase License') }}</div>

                <div class="card-body">
                    <form method="post" action="{{ route('licenses.purchase-order') }}">
                        @csrf

                        <!-- Add your license type selection, payment details, etc. fields here -->

                        <div class="form-group">
                            <label for="license_type">License Type</label>
                            <select name="license_type" id="license_type" class="form-control">
                                <!-- Add options for license types -->
                                <option value="demo">Demo License</option>
                                <option value="basic">Basic License</option>
                                <!-- Add other license types as needed -->
                            </select>
                        </div>

                        <!-- Add more form fields as needed -->

                        <button type="submit" class="btn btn-primary">Purchase License</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div> --}}
<div class="container">
    <div class="row">
        @foreach ($licenses as $license)
            <div class="col-md-4 mb-4">
                <div class="card license-card">
                    <div class="card-header justify-content-center">
                        <div class="row">
                        {{ $license->type }} License
                        </div>
                        <div class="row">
                            <h4> ${{ $license->price }}</h4>
                            <p>/month</p>
                        </div>


                    </div>
                    <div class="card-body">
                        <p>{{ $license->description }}</p>

                        <p><span class="fa fa-check"></span>  Valid for: {{ $license->expiration_cycle }} months</p>
                        <p><span class="fa fa-check"></span>  Support Apartments: {{ $license->max_apartments }}</p>
                        <p><span class="fa fa-check"></span>  Rooms Supported: {{ $license->max_rooms }}</p>
                        <p><span class="fa fa-check"></span>  Users Supported: {{ $license->max_users }}</p>
                        <p><span class="fa fa-check"></span>  Agents or Landlords Supported: {{ $license->max_landlords }}</p>
                        <!-- Add more license details as needed -->

<span class="fa fa-star checked"></span>
<span class="fa fa-star checked"></span>
<span class="fa fa-star checked"></span>
<span class="fa fa-star"></span>
<span class="fa fa-star"></span>
                        <form method="post" action="{{ route('licenses.purchase-checkout') }}">
                            @csrf
                            <input type="hidden" name="license_type" value="{{ $license->type }}">
                            <!-- Add more hidden fields as needed -->
                            <div class="card-footer">
                            <button type="submit" class="btn btn-primary">Get License</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
 </div>


@endsection

