@extends('layouts.landlord-layout')

@section('content')
<div class="content-wrapper">
    <div class="row justify-content-center">
        @include('partials._message_box')
    </div>


<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-10 py-4">
            <div class="card py-4">
                <div class="card-header">{{ __('Manage Licenses') }}
                <div class="card-tools float-right">
                    <div class="form-group mb-0">
                        <form method="get" action="{{ route('licenses.purchase-page') }}">
                            @csrf
                            <button type="submit" class="btn btn-success">Purchase Another License</button>
                        </form>
                    </div>

                </div>
                </div>

                <div class="card-head py-4">
                    <div class="row justify-content-center">
                        <div class="col-md-10">
                            <p>Do you wish to have your license key activated?</p>
                        </div>
                        <div class="row">
                            <div class="">
                            <form method="post" action="{{ route('licenses.install-key') }}">
                                @csrf
                                <div class="input-group">
                                    <input type="text" class="form-control" name="upgrade_plan" placeholder="Enter Key">
                                    <div class="input-group-append">
                                        <button type="submit" class="btn btn-primary">Install Key</button>
                                    </div>
                                </div>
                            </form>
                            </div>
                        </div>

                    </div>
                </div>
<div class="card-header"></div>
                <div class="card-body">
                    <h5>My Licenses</h5>
                    @forelse ($user->licensePurchases as $licensePurchase)
                        <div class="card mb-3">
                            <div class="card-body">
                                <p><strong>License Type:</strong> {{ $licensePurchase->license_type }}</p>
                                <p><strong>License Key:</strong> {{ $licensePurchase->license_key }}</p>
                                <p><strong>Status:</strong> {{ $licensePurchase->status }}</p>
                                <p><strong>Expiry Date:</strong> {{ $licensePurchase->expiry_date }}</p>
                                <p><strong>Purchase Date:</strong> {{ $licensePurchase->purchase_date }}</p>

                                <div class="mt-3">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <form method="post" action="{{ route('licenses.reissue') }}">
                                                @csrf
                                                <button type="submit" class="btn btn-secondary">Request Reissue</button>
                                            </form>
                                        </div>
                                        <div class="col-md-4">
                                             <!-- Add button to show renewal form -->
    @if ($licensePurchase->license_type !== 'demo')
    <button type="button" class="btn btn-secondary" data-toggle="modal" data-target="#renewModal">
        Renew License
    </button>
@endif
                                        </div>
                                        <div class="col-md-4">
                                            <!-- Input form for possible upgrade -->
                                            <form method="get" action="{{ route('licenses.upgrade-page') }}">
                                                @csrf
                                                <button type="submit" class="btn btn-secondary">Upgrade</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <p>You don't have a license. Purchase one to start managing your property and access premium features.</p>
                        <form method="get" action="{{ route('licenses.purchase-page') }}">
                            @csrf
                            <button type="submit" class="btn btn-success">Purchase License</button>
                        </form>
                    @endforelse
                </div>
                <div class="col-md-12">
                    <form method="get" action="{{ route('licenses.purchase-page') }}">
                        @csrf
                        <div class="card-footer">
                        <button type="submit" class="btn btn-primary center">Purchase Another License</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- <div class="container">
    <div class="row">
        @foreach ($user->licensePurchases as $license)
            <div class="col-md-4 mb-4">
                <div class="card">
                    <div class="card-header">{{ $license->type }} License</div>
                    <div class="card-body">
                        <p>{{ $license->description }}</p>
                        <p>Price: ${{ $license->price }}</p>
                        <p>Valid for: {{ $license->validity_period }} months</p>
                        <!-- Add more license details as needed -->

                        <form method="post" action="{{ route('licenses.purchase-page') }}">
                            @csrf
                            <input type="hidden" name="license_type" value="{{ $license->type }}">
                            <!-- Add more hidden fields as needed -->

                            <button type="submit" class="btn btn-primary">Get License</button>
                        </form>
                    </div>
                </div>
            </div>
        @endforeach
        <form method="post" action="{{ route('licenses.purchase-page') }}">
            @csrf

            <!-- Add your license type selection, payment details, etc. fields here -->

            <div class="form-group">
                <label for="license_type">License Type</label>
                <select name="license_type" id="license_type" class="form-control">
                    <!-- Add options for license types -->
                    <option value="demo">Demo License</option>
                    <option value="basic">Basic License</option>
                    <!-- Add other license types as needed -->
                </select>
            </div>

            <!-- Add more form fields as needed -->
            <!-- Buttons for various actions -->



        </form>
    </div>
</div>
<div class="mt-3">
    <!-- Add button to show renewal form -->
    @if ($licensePurchase->license_type !== 'demo')
        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#renewModal">
            Renew License
        </button>
    @endif
</div> --}}

{{-- <!-- Renewal Modal -->
<div class="modal fade" id="renewModal" tabindex="-1" role="dialog" aria-labelledby="renewModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="renewModalLabel">Renew License</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Include a form to collect renewal details (e.g., number of months or weeks) -->
                <form id="renewForm">
                    <!-- Add form fields for renewal details -->
                    <div class="form-group">
                        <label for="renewalPeriod">Renewal Period (months or weeks):</label>
                        <input type="number" class="form-control" id="renewalPeriod" name="renewalPeriod" required>
                    </div>

                    <!-- Add more fields or customization based on your needs -->

                    <button type="button" class="btn btn-primary" onclick="calculateRenewalPrice()">Calculate Price</button>
                </form>

                <!-- Display calculated price -->
                <div id="calculatedPrice"></div>
            </div>
            <div class="modal-footer">
                <!-- Add buttons for renewing and upgrading -->
                <button type="button" class="btn btn-success" onclick="renewLicense()">Renew</button>
                <button type="button" class="btn btn-warning" onclick="upgradeLicense()">Upgrade License</button>
            </div>
        </div>
    </div>
</div>

<script>
    function calculateRenewalPrice() {
        // Implement JavaScript logic to calculate the renewal price based on form input
        // Display the calculated price in the "calculatedPrice" div
    }

    function renewLicense() {
        // Implement JavaScript logic to initiate the renewal process (e.g., submit the form via AJAX)
        // Close the modal after renewal
        $('#renewModal').modal('hide');
    }

    function upgradeLicense() {
        // Implement JavaScript logic to redirect to the upgrade page
        // Close the modal
        $('#renewModal').modal('hide');
    } --}}
{{-- </script> --}}
</div>

@endsection

