@extends('admin.layouts.admin-layout')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Support Tickets</h1>
            <h3 class="m-0 p-3">#{{ $ticket->id }}-{{ $ticket->subject }} <div class="btn-group">
                <button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    {{ $ticket->status }} <!-- Display current status here -->
                </button>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="#" data-status="open">Open</a>
                    <a class="dropdown-item" href="#" data-status="in-progress">In Progress</a>
                    <a class="dropdown-item" href="#" data-status="closed">Closed</a>
                    <!-- Add more status options as needed -->
                </div>
            </div>
            {{ $ticket->status }}</h3>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
              <li class="breadcrumb-item active">Dashboard v1</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <div class="container">
        <div id="sweet-alert-container"></div>
        <h3>Reply</h3>
    <form method="POST" action="{{ route('tickets.reply', $ticket) }}">
        @csrf
        <div class="form-group">
            <label for="message">Your Reply:</label>
            <textarea name="message" id="message" class="form-control" rows="3"></textarea>
        </div>
        <button type="submit" class="btn btn-primary">Submit Reply</button>
    </form>
    <h3>Conversation Thread</h3>
    <div class="ticket">
        <strong>{{ $ticket->user->name }}:</strong> {{ $ticket->description }}
        <br>
        <small>{{ $ticket->created_at->diffForHumans() }}</small>
    </div>

    <!-- Display the replies -->
    <h6 p-5>Conversation Thread</h6>
    <ul>
        @foreach ($ticket->responses as $response)
            <li>
                <strong>{{ $response->user->name }}:</strong> {{ $response->message }}
                <br>
                <small>{{ $response->created_at->diffForHumans() }}</small>
            </li>
        @endforeach
    </ul>

    <ul>
        @if ($ticket->responses->count() > 0)
            @foreach ($ticket->responses as $response)
                <li>
                    <strong>{{ $response->user->name }}:</strong> {{ $response->message }}
                    <br>
                    <small>{{ $response->created_at->diffForHumans() }}</small>
                </li>
            @endforeach
        @else
            <li>No replies yet.</li>
        @endif
    </ul>
</div>
    </div>

@endsection
<script>
    <script>
    $(document).ready(function () {
        $('.dropdown-item').on('click', function (e) {
            e.preventDefault();
            var newStatus = $(this).data('status');
            var ticketId = {{ $ticket->id }}; // Replace with the actual way you get the ticket ID
            var button = $(this).closest('.btn-group').find('.btn');

            // Send an AJAX request to update the ticket status
            $.ajax({
                type: 'POST',
                url: '/tickets/update-status/' + ticketId,
                data: { status: newStatus },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function (data) {
                    // Update the button text to reflect the new status
                    button.text(newStatus);
                    // You can also show a success message here
                },
                error: function (error) {
                    // Handle errors if the status update fails
                }
            });
        });
    });
</script>
    Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: 'Your reply has been sent.',
    target: '#sweet-alert-container', // Specify the target element
});
</script>
