@extends('admin.layouts.admin-layout')

@section('content')

    <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                    <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1 class="m-0">ROOM OCCUPIED</h1>
                        </div><!-- /.col -->
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard v1</li>
                            </ol>
                        </div><!-- /.col -->
                        </div><!-- /.row -->
                    </div><!-- /.container-fluid -->
                    </div>
                <!-- /.content-header -->

            <!-- Main content -->

                <section class="content">
                <div class="container-fluid">
                <!-- Small boxes (Stat box) -->
                    <div class="row">
                        <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-info">
                            <div class="inner">
                            <h3>{{$totalrooms}}</h3>

                            <p>Total Rooms</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-bag"></i>
                            </div>
                            <a href="{{ route('roomsoccupied') }}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                        </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-success">
                        <div class="inner">
                        <h3>KSh. 10,500<sup style="font-size: 20px">%</sup></h3>

                        <p>Amount Paid</p>
                        </div>
                        <div class="icon">
                        <i class="ion ion-stats-bars"></i>
                        </div>
                        <a href="admin/pages/thismonth.php" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-warning">
                        <div class="inner">
                        <h3>10,000</h3>

                        <p>Last Month Areas</p>
                        </div>
                        <div class="icon">
                        <i class="ion ion-person-add"></i>
                        </div>
                        <a href="#" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-danger">
                        <div class="inner">
                        <h3>KSh. 30,000</h3>

                        <p>Amount Unpaid(This month)</p>
                        </div>
                        <div class="icon">
                        <i class="ion ion-pie-graph"></i>
                        </div>
                        <a href="admin/pages/thismonth.php" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                    </div>
                    <!-- ./col -->
                </div>
                <!-- /.row -->
                <!-- Main row -->
                <!-- Assign Room to Apartment--->
                <section>
                    <div class="container bg-primary">
                        <div class="row">
                            <h5>{{ __('ASSIGN ROOM TO APARTMENT') }}</h5>
                        </div>
                        <div class="row">
                            <table>
                                <thead>
                                    <tr>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <td></td>
                                    <td></td>
                                </tbody>


                            </table>
                        </div>
                    </div>
                </section>
                <!--/Assign Room to Apartment--->

                <div class="row">
                    <h3>{{ __('ROOM LIST') }}</h3>
                </div>


                <!--Table--->
                <div>

                    <table class="table">

                        <thead>
                            <tr>
                                <th>Room ID:</th>
                                <th>No:</th>
                                <th>price </th>
                                <th>Apartment </th>
                                <th>Room size </th>
                                <th>Room Status</th>
                                <th>Room Occuppant</th>
                                <th>Room Balance</th>
                                <th>Action</th>

                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($rooms as $room)
                            <tr>
                                <td>{{ $room->id }}</td>
                                <td>{{ $room->room_number }}</td>
                                <td>{{ $room->price }}</td>
                                <td>{{ $room->apartment }}</td>
                                <td>{{ $room->room_size }}</td>
                                <td>{{ $room->room_occupant }}</td>

                                <td>occupied               </td>
                                <td>balance</td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Actions
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            @if($room->tenant)
                                                <a class="dropdown-item" href="{{ route('rooms.removeTenant', $room->id) }}">Remove Tenant</a>
                                            @else
                                                <a class="dropdown-item" href="{{ route('rooms.assignTenant', $room->id) }}">Assign Tenant</a>
                                            @endif
                                            {{-- <a class="dropdown-item" href="{{ route('rooms.assignApartment', $room->id) }}">Assign Apartment</a> --}}
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                        @endforeach
                    </table>

                </div>
                 <!--End Table---include link for description on room db-->

                  <!--Rooms Listing--->
                 <div class="row">
                            @foreach ($rooms as $room)
                            <div class="col-lg-3 col-6">
                            <!-- small box -->
                            <div class="small-box bg-info">
                                <div class="inner">
                                <h3>ROOM .{{ $room->room_number }}</h3>
                                    <li>
                                        <ul>
                                            <p>Occupant:{{ $room->room_occupant }} </p>
                                            <p>Size: {{ $room->room_size }}</p>
                                            <p>Price: {{ $room->price }}</p>
                                            <p>Payment Status: {{ $room->price }}</p>
                                        </ul>
                                    </li>
                                </div>

                                <div class="icon">
                                <i class="ion ion-bag"></i>
                                </div>
                                <a href="{{ route('roomsoccupied') }}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                            </div>
                        </div>

                    @endforeach
                </div>
                </div>
                </section>
        </div>
@endsection
@section('scripts')

<!-- Admin-specific scripts here -->
@endsection
