
@extends('admin.layouts.admin-layout')

@section('content')

    <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                    <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1 class="m-0">LANDLORDS</h1>
                        </div><!-- /.col -->
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard v1</li>
                            </ol>
                        </div><!-- /.col -->
                        </div><!-- /.row -->
                    </div><!-- /.container-fluid -->
                    </div>
                <!-- /.content-header -->

            <!-- Main content -->

                <section class="content">
                <div class="container-fluid">
                <!-- Small boxes (Stat box) -->
                    <div class="row">
                        <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-info">
                            <div class="inner">
                            <h3>fsds</h3>

                            <p>Totals Users</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-bag"></i>
                            </div>
                            <a href="{{ route('roomsoccupied') }}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                        </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-success">
                        <div class="inner">
                        <h3>50<sup style="font-size: 20px">%</sup></h3>

                        <p>Pending</p>
                        </div>
                        <div class="icon">
                        <i class="ion ion-stats-bars"></i>
                        </div>
                        <a href="admin/pages/thismonth.php" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-warning">
                        <div class="inner">
                        <h3>1400</h3>

                        <p>Active</p>
                        </div>
                        <div class="icon">
                        <i class="ion ion-person-add"></i>
                        </div>
                        <a href="#" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-danger">
                        <div class="inner">
                        <h3>120</h3>

                        <p>Disabled</p>
                        </div>
                        <div class="icon">
                        <i class="ion ion-pie-graph"></i>
                        </div>
                        <a href="admin/pages/thismonth.php" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                    </div>
                    <!-- ./col -->
                </div>
                <!-- /.row -->
                <!-- Main row -->

                <!-- ASSIGN USERS -->
                <div class="container bg-orange">
                    <div class="row " style="overflow:hidden;">
                        <h3>{{ __('Assign Landlord and caretakers') }}</h3>
                                <!--
                                -->
                                {{-- <form action="{{ route('assign.role') }}" method="post">
                                    @csrf
                                    <div class="form-group">
                                        <label for="user_id">Select User:</label>
                                        <select name="user_id" class="form-control">
                                            @foreach($users as $user)
                                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group">

                                        <label for="role">Assign Role:</label>
                                        <select name="role" class="form-control">
                                            <option value="caretaker">Caretaker</option>
                                            <option value="landlord">Landlord</option>
                                        </select>
                                    </div>
                                    <button type="submit" class="btn btn-primary">Assign Role</button>
                                </form> --}}
                                @if (session('success'))
                                <div class="alert alert-success">
                                    {{ session('success') }}
                                </div>
                                @endif

                                    @if (session('error'))
                                    <div class="alert alert-danger">
                                        {{ session('error') }}
                                    @endif
                                    </div>


                    </div>
                    <div class="row">
                        <form method="POST" action="{{ route('assign.landlord.role') }}">
                            @csrf

                            <label for="user_id">Select User:</label>
                            <select name="user_id" id="user_id" class="form-control">
                                @foreach ($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>

                            <label for="role">Select Role:</label>
                            <select name="role" id="role" class="form-control">
                                @foreach ($roles as $role)
                                    <option value="{{ $role->name }}">{{ $role->name }}</option>
                                @endforeach
                            </select>

                            <button type="submit" class="btn btn-primary">Assign Role</button>
                        </form>

                    </div>



                <div class="container">
                <div class="row">

                        <h1>List of Landlords</h1>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Created at</th>
                                    <th>apartment</th>
                                    <th>Assigned On</th>
                                    <!-- Add more table headers as needed -->
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($landlords as $landlord)
                                    <tr>
                                        <td>{{ $landlord->id }}</td>
                                        <td>{{ $landlord->name }}</td>
                                        <td>{{ $landlord->email }}</td>
                                        <!-- Add more table data cells for additional user details -->
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                </section>
        </div>
@endsection
@section('scripts')

<!-- Admin-specific scripts here -->
@endsection
