<!-- resources/views/email-templates/create.blade.php -->
@extends('admin.layouts.admin-layout')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Edit Email Template</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
              <li class="breadcrumb-item active">Dashboard v1</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    @if (session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">


        <form action="{{ route('email-templates.update', $emailTemplate) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="form-group">
                <label for="name">Name:</label>
                <input type="text" name="name" id="name" class="form-control" value="{{ $emailTemplate->name }}" required>
            </div>
            <div class="form-group">
                <label for="subject">Subject:</label>
                <input type="text" name="subject" id="subject" class="form-control" value="{{ $emailTemplate->subject }}" required>
            </div>
            <div class="form-group">
                <label for="body">Body:</label>
                <textarea name="body" id="body" rows="5" class="form-control" required>{{ $emailTemplate->body }}</textarea>
            </div>
            <div class="form-group">
                <label for="header">Header:</label>
                <textarea name="header" id="header" rows="3" class="form-control">{{ $emailTemplate->header }}</textarea>
            </div>
            <div class="form-group">
                <label for="footer">Footer:</label>
                <textarea name="footer" id="footer" rows="3" class="form-control">{{ $emailTemplate->footer }}</textarea>
            </div>
            <button type="submit" class="btn btn-primary">Update Template</button>
        </form>
    </div>
@endsection
