@extends('admin.layouts.admin-layout')

@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Apartments By COUNTY</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
              <li class="breadcrumb-item active">Dashboard v1</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <section class="content">
        <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
            <div class="row">
                       @include('partials._message_box')
            </div>
                                <h5><strong> Assign Landlord to Apartment</strong></h5>

                                {{-- <form method="POST" action="{{ route('assign.landlord') }}">
                                    @csrf --}}

                                    {{-- <!-- Dropdown for selecting a user with the "landlord" role -->
                                    <div class="form-group">
                                        <label for="user_id">Select Landlord:</label>
                                        <select name="user_id" id="user_id" class="form-control">
                                            @foreach ($landlords as $user)
                                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <!-- Dropdown for selecting an apartment -->
                                    <div class="form-group">
                                        <label for="apartment_id">Select Apartment:</label>
                                        <select name="apartment_id" id="apartment_id" class="form-control">
                                            @foreach ($apartments as $apartment)
                                                <option value="{{ $apartment->id }}">{{ $apartment->name }}</option>
                                            @endforeach
                                        </select>
                                    </div> --}}
                                    {{-- <label for="apartment_id">Select Apartment:</label>
                                    <select name="apartment_id" id="apartment_id">
                                        @foreach ($apartments as $apartment)
                                            <option value="{{ $apartment->id }}">{{ $apartment->name }}</option>
                                        @endforeach
                                    </select>

                                    <label for="landlord_id">Select Landlord (User with Landlord Role):</label>
                                    <select name="landlord_id" id="landlord_id">
                                        @foreach ($landlords as $landlord)
                                            <option value="{{ $landlord->id }}">{{ $landlord->name }}</option>
                                        @endforeach
                                    </select>

                                    <!-- Assign button -->
                                    <button type="submit" class="btn btn-primary">Assign Landlord</button>
                                </form>
                            </div> --}}


                        </div>
                    <section class="mb-5 p-7">

                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Apartment Name</th>
                                    <th>County</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($apartments as $apartment)
                                <tr>
                                    <td>{{ $apartment->name }}</td>
                                    <td>
                                        @if ($apartment->county)
                                            {{ $apartment->county }}
                                        @else
                                            <span class="text-danger">Not assigned</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if (!$apartment->county)
                                            <button class="assign-county-btn" data-apartment-id="{{ $apartment->id }}" data-apartment-name="{{ $apartment->name }}">Assign County</button>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach

                            </tbody>
                        </table>


                    </section>
                    <section>
                        <!-- Modal -->
                        <div class="modal fade" id="assignCountyModal" tabindex="-1" role="dialog" aria-labelledby="assignCountyModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="assignCountyModalLabel">Assign Apartment to County</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <!-- Apartment Name -->
          <div class="row mb-3">
            <div class="col">
              <label for="apartmentName">Apartment Name:</label>
              <input type="text" class="form-control" id="apartmentName" value="Apartment Name" disabled>
            </div>
          </div>
          <!-- County Dropdown -->
          <div class="row mb-3">
            <div class="col">
              <label for="countySelect">Select County:</label>
              <select class="form-control" id="countySelect">
                <!-- Populate dropdown options dynamically from backend -->
                @foreach($counties as $county)
                <option value="{{ $county->id }}">{{ $county->name }}</option>
                @endforeach
              </select>
            </div>
          </div>
          <!-- Buttons -->
          <div class="row">
            <div class="col">
              <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
              <button type="button" class="btn btn-primary" id="assignCountyBtn">Assign</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

                    </section>

                </div>
                </div></div>

                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        var modal = document.getElementById('assignCountyModal');
                        var btns = document.querySelectorAll('.assign-county-btn');
                        var span = document.querySelector('.close');

                        btns.forEach(function(btn) {
                            btn.onclick = function() {
                                var apartmentId = btn.dataset.apartmentId;
                                var apartmentName = btn.dataset.apartmentName;
                                document.getElementById('apartmentName').innerText = apartmentName;
                                modal.style.display = 'block';
                            }
                        });

                        span.onclick = function() {
                            modal.style.display = 'none';
                        }

                        window.onclick = function(event) {
                            if (event.target == modal) {
                                modal.style.display = 'none';
                            }
                        }

                        document.getElementById('assignCountyBtn').onclick = function() {
                            var apartmentId = document.querySelector('.assign-county-btn').dataset.apartmentId;
                            var countyId = document.getElementById('countySelect').value;

                            // Send an AJAX request to assign the apartment to the county
                            // Here you can use Axios, Fetch API, or any other method to send the request
                            // Example:
                            // axios.post('/assign-county', { apartmentId: apartmentId, countyId: countyId })
                            //     .then(function(response) {
                            //         // Handle success
                            //         modal.style.display = 'none';
                            //         alert('Apartment assigned to county successfully!');
                            //     })
                            //     .catch(function(error) {
                            //         // Handle error
                            //         console.error('Error assigning county:', error);
                            //         alert('An error occurred while assigning county. Please try again later.');
                            //     });
                        }
                    });
                </script>



@endsection
