<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->string('password');
            $table->string('first_name')->default(''); // Add first name column
            $table->string('surname')->default(''); // Add surname column
            $table->string('last_name')->default(''); // Add last name column\
            $table->integer('is_admin')->default('0'); // Add last name column
            $table->boolean('active')->default(false); // Custom column for active status
            $table->timestamp('last_payment')->nullable(); // Custom column for last payment made
            $table->rememberToken();
            $table->timestamps();



        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
