<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Schema::create('invoices', function (Blueprint $table) {
        //     $table->id();
        //     $table->unsignedBigInteger('room_id'); // Foreign key to link to the room
        //     $table->decimal('amount', 10, 2)->default(0.00); // Decimal field for the invoice amount
        //     $table->enum('payment_status', ['unpaid', 'paid'])->default('unpaid'); // Payment status enum
        //     $table->timestamps();

        //     // Define the foreign key constraint to link the invoice to a room
        //     $table->foreign('room_id')->references('id')->on('rooms')->onDelete('cascade');
        // });
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_number')->unique();
            $table->unsignedBigInteger('room_id');
            $table->unsignedBigInteger('user_id');
            $table->decimal('total_amount', 10, 2)->default(0.00);
            $table->decimal('amount_paid', 10, 2)->default(0.00);
            $table->enum('payment_status', ['unpaid', 'partial', 'paid'])->default('unpaid');
            $table->timestamps();
            $table->json('payments')->nullable();
            $table->json('invoice_items')->nullable();

            // Foreign key constraints
            $table->foreign('room_id')->references('id')->on('rooms');
            $table->foreign('user_id')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
    }
}
