<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLicensesTable01 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('licenses', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->enum('type', ['basic_tenant', 'premium_tenant', 'starter_landlord', 'professional_landlord', 'standard_landlord', 'lite_landlord', 'enterprise_landlord', 'executive_landlord']);
            $table->timestamp('expiry_date');
            $table->unsignedBigInteger('room_id')->nullable(); // For tenants
            $table->unsignedBigInteger('apartment_id')->nullable(); // For landlords
            // Add other relevant fields

            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users');
            $table->foreign('room_id')->references('id')->on('rooms'); // Assuming you have a 'rooms' table
            $table->foreign('apartment_id')->references('id')->on('apartments'); // Assuming you have an 'apartments' table
        });
    }

    public function down()
    {
        Schema::dropIfExists('licenses');
    }
}
