<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->string('action');
            $table->unsignedBigInteger('apartment_id');
            $table->unsignedBigInteger('tenant_id');
            $table->json('changed_fields');
            $table->ipAddress('ip_address');
            $table->timestamps();

            // Add foreign key constraints if necessary
            $table->foreign('user_id')->references('id')->on('users');
            // Add more foreign keys as needed

            $table->index(['user_id', 'apartment_id', 'tenant_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_logs');
    }
}
