<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToApartmentsTable extends Migration
{
    public function up()
    {
        Schema::table('apartments', function (Blueprint $table) {
            // Add country, county, district, division, location, and sub-location
            $table->string('country')->nullable();
            $table->string('county')->nullable();
            $table->string('district')->nullable();
            $table->string('division')->nullable();
            $table->string('location')->nullable();
            $table->string('sub_location')->nullable();

            // Add payment methods
            $table->json('payment_methods')->nullable();

            // Add active theme
            $table->string('active_theme')->nullable();

            // Add features
            $table->text('features')->nullable();

            // Add images
            $table->json('images')->nullable();

            // Add socials
            $table->json('socials')->nullable();
        });
    }

    public function down()
    {
        Schema::table('apartments', function (Blueprint $table) {
            $table->dropColumn([
                'country', 'county', 'district', 'division', 'location', 'sub_location',
                'payment_methods', 'active_theme', 'features', 'images', 'socials'
            ]);
        });
    }
}
