<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApartmentSmtpConfigurationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('apartment_smtp_configurations', function (Blueprint $table) {
            $table->id();
        $table->unsignedBigInteger('apartment_id');
        $table->string('driver');
        $table->string('host');
        $table->integer('port');
        $table->string('encryption');
        $table->string('username');
        $table->string('password');
        // Add other necessary fields
        $table->timestamps();

        $table->foreign('apartment_id')->references('id')->on('apartments')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('apartment_smtp_configurations');
    }
}
