<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApartmentSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        

Schema::create('apartment_settings', function (Blueprint $table) {
    $table->id();
    $table->unsignedBigInteger('apartment_id');
    $table->string('category');
    $table->string('sub_category')->nullable();
    $table->string('setting_key');
    $table->text('setting_value')->nullable();
    $table->timestamps();

    $table->foreign('apartment_id')->references('id')->on('apartments')->onDelete('cascade');
});

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('apartment_settings');
    }
}
