<?php
// app/Services/StatisticsService.php

namespace App\Services;

use App\Models\User;
use App\Models\Rooms;

class StatisticsService
{
    public function getUsersCount()
    {
        return User::count();
    }

    public function getActiveUsersCount()
    {
        return User::where('status', 'active')->count();
    }

    public function getRoomsCount()
    {
        return Rooms::count();
    }

    public function getOccupiedRoomsCount()
    {
        return Rooms::where('status', 'occupied')->count();
    }
}
