<?php

namespace App\Services;

use App\Models\Apartments;
use App\Models\EmailTemplate;

use App\Services\ApartmentEmail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\ApartmentSmtpConfiguration;

class EmailService
{
    // public static function sendEmail($apartmentId, $to, $subject, $body)
    // // Get the apartment instance

    // {
    //     $apartment = Apartments::find($apartmentId);
    //     // Retrieve SMTP configuration for the apartment
    //     $smtpConfig = ApartmentSmtpConfiguration::where('apartment_id', $apartmentId)->first();

    //         // Retrieve email templates associated with the apartment
    //     $emailTemplates = $apartment->emailTemplates;
    //     // Check if configuration exists
    //     if ($smtpConfig) {
    //         // Use apartment's SMTP configuration
    //         config([
    //             'mail.mailers.smtp.host' => $smtpConfig->host,
    //             'mail.mailers.smtp.port' => $smtpConfig->port,
    //             'mail.mailers.smtp.encryption' => $smtpConfig->encryption,
    //             'mail.mailers.smtp.username' => $smtpConfig->username,
    //             'mail.mailers.smtp.password' => $smtpConfig->password,
    //             'mail.from.address' => $smtpConfig->username, // Or use a default 'from' address
    //             'mail.from.name' => 'Your Application Name' // Or use a default 'from' name
    //         ]);
    //     }

    //     // Send email
    //     // Mail::to($to)->send(new \App\Mail\CustomEmail($subject, $body));
    //      // Send email using the template
    // Mail::to($recipient)->send(new $template->mailable);
    // }

    public function sendEmail(Request $request)
    {
        // Validate the request data
        $validator = Validator::make($request->all(), [
            'template_id' => 'required|exists:email_templates,id',
            'email' => 'required|email',
        ]);

        // Check if validation fails
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 400);
        }

        // Retrieve selected email template ID from the request
        $templateId = $request->input('template_id');

        // Retrieve the selected email template
        $emailTemplate = EmailTemplate::findOrFail($templateId);

        // Get the recipient's email address from the request (assuming it's stored in the 'email' field)
        $recipientEmail = $request->input('email');

        // Instantiate your Mailable class using the selected template
        $mailable = new ApartmentEmail($emailTemplate);

        // Send the email to the recipient using the Mailable instance
        Mail::to($recipientEmail)->send($mailable);

        // Optionally, you can check if the email was sent successfully and return a response
        if (Mail::failures()) {
            return response()->json(['message' => 'Failed to send email'], 500);
        } else {
            return response()->json(['message' => 'Email sent successfully'], 200);
        }
    }

}
