<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TicketResponse extends Model
{

    use HasFactory;

    protected $fillable = [
        'message', // Add 'message' to the fillable attributes
        'user_id', // Add 'user_id' to the fillable attributes
        'status',
        'ticket_id',
        // Other fillable attributes, if any
    ];

    public function ticket()
{
    return $this->belongsTo(Ticket::class);
}
// TicketResponse.php
public function user()
{
    return $this->belongsTo(User::class);
}

}
