<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;


    protected $fillable = [
        'user_id',
        'invoice_id',
        'amount_paid',
        'payment_date',
    ];

    // Define a relationship with the User model (assuming a user can make payments).
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Define a relationship with the Invoice model (assuming a payment is related to an invoice).
    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }
}
